/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.core.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.CommitToPsiFileAction;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomModelImpl
extends UserDataHolderBase
implements PomModel {
    private static final Logger LOG = Logger.getInstance("#com.intellij.pom.core.impl.PomModelImpl");
    private final Project myProject;
    private final Map<Class<? extends PomModelAspect>, PomModelAspect> myAspects = new HashMap<Class<? extends PomModelAspect>, PomModelAspect>();
    private final Map<PomModelAspect, List<PomModelAspect>> myIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Map<PomModelAspect, List<PomModelAspect>> myInvertedIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Collection<PomModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Stack<Pair<PomModelAspect, PomTransaction>> myBlockedAspects = new Stack();
    private static volatile boolean allowPsiModification = true;

    public PomModelImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public <T extends PomModelAspect> T getModelAspect(@NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/pom/core/impl/PomModelImpl", "getModelAspect"));
        }
        return (T)this.myAspects.get(aClass);
    }

    @Override
    public void registerAspect(@NotNull Class<? extends PomModelAspect> aClass, @NotNull PomModelAspect aspect, @NotNull Set<PomModelAspect> dependencies) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/pom/core/impl/PomModelImpl", "registerAspect"));
        }
        if (aspect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aspect", "com/intellij/pom/core/impl/PomModelImpl", "registerAspect"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/pom/core/impl/PomModelImpl", "registerAspect"));
        }
        this.myAspects.put(aClass, aspect);
        Iterator<PomModelAspect> iterator = dependencies.iterator();
        ArrayList<PomModelAspect> deps = new ArrayList<PomModelAspect>();
        while (iterator.hasNext()) {
            PomModelAspect depend = iterator.next();
            deps.addAll(this.getAllDependencies(depend));
        }
        deps.add(aspect);
        for (PomModelAspect pomModelAspect : deps) {
            List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(pomModelAspect);
            if (pomModelAspects != null) {
                pomModelAspects.add(aspect);
                continue;
            }
            this.myInvertedIncidence.put(pomModelAspect, new ArrayList<PomModelAspect>(Collections.singletonList(aspect)));
        }
        this.myIncidence.put(aspect, deps);
    }

    private List<PomModelAspect> getAllDependencies(PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    private List<PomModelAspect> getAllDependants(PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    @Override
    public void addModelListener(@NotNull PomModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/pom/core/impl/PomModelImpl", "addModelListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public void addModelListener(final @NotNull PomModelListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/pom/core/impl/PomModelImpl", "addModelListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/pom/core/impl/PomModelImpl", "addModelListener"));
        }
        this.addModelListener(listener);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                PomModelImpl.this.removeModelListener(listener);
            }
        });
    }

    @Override
    public void removeModelListener(@NotNull PomModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/pom/core/impl/PomModelImpl", "removeModelListener"));
        }
        this.myListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runTransaction(@NotNull PomTransaction transaction) throws IncorrectOperationException {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/pom/core/impl/PomModelImpl", "runTransaction"));
        }
        if (!PomModelImpl.isAllowPsiModification()) {
            throw new IncorrectOperationException("Must not modify PSI inside save listener");
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            block58: {
                ArrayList<Throwable> throwables;
                block55: {
                    Pair<PomModelAspect, PomTransaction> block;
                    PomModelEvent event;
                    block54: {
                        throwables = new ArrayList<Throwable>(0);
                        PomModelAspect aspect = transaction.getTransactionAspect();
                        this.startTransaction(transaction);
                        DebugUtil.startPsiModification(null);
                        this.myBlockedAspects.push(Pair.create(aspect, transaction));
                        try {
                            transaction.run();
                            event = transaction.getAccumulatedEvent();
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            LOG.error(e);
                            try {
                                this.commitTransaction(transaction);
                            }
                            catch (ProcessCanceledException e2) {
                                throw e2;
                            }
                            catch (Throwable t) {
                                throwables.add(t);
                            }
                            finally {
                                DebugUtil.finishPsiModification();
                            }
                            if (throwables.isEmpty()) return;
                            CompoundRuntimeException.throwIfNotEmpty(throwables);
                            return;
                        }
                        finally {
                            this.myBlockedAspects.pop();
                        }
                        block = this.getBlockingTransaction(aspect, transaction);
                        if (block != null) break block54;
                        Set<PomModelAspect> changedAspects = event.getChangedAspects();
                        LinkedHashSet<PomModelAspect> dependants = new LinkedHashSet<PomModelAspect>();
                        for (PomModelAspect pomModelAspect : changedAspects) {
                            dependants.addAll(this.getAllDependants(pomModelAspect));
                        }
                        for (PomModelAspect modelAspect : dependants) {
                            if (changedAspects.contains(modelAspect)) continue;
                            modelAspect.update(event);
                        }
                        block47: for (PomModelListener listener : this.myListeners) {
                            Set<PomModelAspect> changedAspects2 = event.getChangedAspects();
                            for (PomModelAspect modelAspect : changedAspects2) {
                                if (!listener.isAspectChangeInteresting(modelAspect)) continue;
                                listener.modelChanged(event);
                                continue block47;
                            }
                        }
                        break block55;
                    }
                    PomModelEvent currentEvent = block.getSecond().getAccumulatedEvent();
                    currentEvent.merge(event);
                    try {
                        this.commitTransaction(transaction);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throwables.add(t);
                    }
                    finally {
                        DebugUtil.finishPsiModification();
                    }
                    if (throwables.isEmpty()) return;
                    CompoundRuntimeException.throwIfNotEmpty(throwables);
                    return;
                }
                try {
                    this.commitTransaction(transaction);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throwables.add(t);
                }
                finally {
                    DebugUtil.finishPsiModification();
                }
                if (throwables.isEmpty()) return;
                CompoundRuntimeException.throwIfNotEmpty(throwables);
                break block58;
                catch (Throwable t) {
                    throwables.add(t);
                    break block58;
                }
                finally {
                    try {
                        this.commitTransaction(transaction);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throwables.add(t);
                    }
                    finally {
                        DebugUtil.finishPsiModification();
                    }
                    if (!throwables.isEmpty()) {
                        CompoundRuntimeException.throwIfNotEmpty(throwables);
                    }
                }
            }
            return;
        }
    }

    @Nullable
    private Pair<PomModelAspect, PomTransaction> getBlockingTransaction(PomModelAspect aspect, PomTransaction transaction) {
        List<PomModelAspect> allDependants = this.getAllDependants(aspect);
        for (PomModelAspect pomModelAspect : allDependants) {
            ListIterator blocksIterator = this.myBlockedAspects.listIterator(this.myBlockedAspects.size());
            while (blocksIterator.hasPrevious()) {
                Pair pair = (Pair)blocksIterator.previous();
                if (pomModelAspect != pair.getFirst() || !PsiTreeUtil.isAncestor(((PomTransaction)pair.getSecond()).getChangeScope(), transaction.getChangeScope(), false) || PomModelImpl.getContainingFileByTree(((PomTransaction)pair.getSecond()).getChangeScope()) == null) continue;
                return pair;
            }
        }
        return null;
    }

    private void commitTransaction(PomTransaction transaction) {
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(transaction.getChangeScope());
        Document document = containingFileByTree != null ? manager.getCachedDocument(containingFileByTree) : null;
        boolean docSynced = false;
        if (document != null) {
            int oldLength = containingFileByTree.getTextLength();
            docSynced = synchronizer.commitTransaction(document);
            if (docSynced) {
                BlockSupportImpl.sendAfterChildrenChangedEvent((PsiManagerImpl)PsiManager.getInstance(this.myProject), containingFileByTree, oldLength, true);
            }
        }
        if (containingFileByTree != null) {
            boolean isFromCommit;
            boolean bl = isFromCommit = ApplicationManager.getApplication().isDispatchThread() && ApplicationManager.getApplication().hasWriteAction(CommitToPsiFileAction.class);
            if (!isFromCommit && !synchronizer.isIgnorePsiEvents()) {
                this.reparseParallelTrees(containingFileByTree);
                if (docSynced) {
                    containingFileByTree.getViewProvider().contentsSynchronized();
                }
            }
        }
        if (progressIndicator != null) {
            progressIndicator.finishNonCancelableSection();
        }
    }

    private void reparseParallelTrees(PsiFile changedFile) {
        List<PsiFile> allFiles = changedFile.getViewProvider().getAllFiles();
        if (allFiles.size() <= 1) {
            return;
        }
        CharSequence newText = changedFile.getNode().getChars();
        for (PsiFile file : allFiles) {
            FileElement fileElement;
            if (file == changedFile || (fileElement = ((PsiFileImpl)file).getTreeElement()) == null) continue;
            this.reparseFile(file, fileElement, newText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparseFile(final @NotNull PsiFile file, @NotNull FileElement treeElement, @NotNull CharSequence newText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/pom/core/impl/PomModelImpl", "reparseFile"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/pom/core/impl/PomModelImpl", "reparseFile"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/pom/core/impl/PomModelImpl", "reparseFile"));
        }
        PsiToDocumentSynchronizer synchronizer = ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject)).getSynchronizer();
        TextRange changedPsiRange = DocumentCommitProcessor.getChangedPsiRange(file, treeElement, newText);
        if (changedPsiRange == null) {
            return;
        }
        final DiffLog log = BlockSupport.getInstance(this.myProject).reparseRange(file, treeElement, changedPsiRange, newText, new EmptyProgressIndicator(), treeElement.getText());
        synchronizer.setIgnorePsiEvents(true);
        try {
            CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(new Runnable(){

                @Override
                public void run() {
                    PomModelImpl.this.runTransaction(new PomTransactionBase(file, PomModelImpl.this.getModelAspect(TreeAspect.class)){

                        @Override
                        @Nullable
                        public PomModelEvent runInner() throws IncorrectOperationException {
                            return new TreeAspectEvent(PomModelImpl.this, log.performActualPsiChange(file));
                        }
                    });
                }
            });
        }
        finally {
            synchronizer.setIgnorePsiEvents(false);
        }
    }

    private void startTransaction(@NotNull PomTransaction transaction) {
        Document document;
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/pom/core/impl/PomModelImpl", "startTransaction"));
        }
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.startNonCancelableSection();
        }
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiElement changeScope = transaction.getChangeScope();
        LOG.assertTrue(changeScope != null);
        PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(changeScope);
        boolean physical = changeScope.isPhysical();
        if (physical && synchronizer.toProcessPsiEvent()) {
            if (this.isDocumentUncommitted(containingFileByTree)) {
                throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
                throw new IncorrectOperationException("Must not change PSI outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
            }
        }
        if (containingFileByTree != null) {
            ((SmartPointerManagerImpl)SmartPointerManager.getInstance(this.myProject)).fastenBelts(containingFileByTree.getViewProvider().getVirtualFile());
        }
        BlockSupportImpl.sendBeforeChildrenChangeEvent((PsiManagerImpl)PsiManager.getInstance(this.myProject), changeScope, true);
        Document document2 = containingFileByTree == null ? null : (document = physical ? manager.getDocument(containingFileByTree) : manager.getCachedDocument(containingFileByTree));
        if (document != null) {
            synchronizer.startTransaction(this.myProject, document, changeScope);
        }
    }

    private boolean isDocumentUncommitted(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance(this.myProject);
        Document cachedDocument = manager.getCachedDocument(file);
        return cachedDocument != null && manager.isUncommited(cachedDocument);
    }

    @Nullable
    private static PsiFile getContainingFileByTree(@NotNull PsiElement changeScope) {
        PsiFile psiFile;
        if (changeScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeScope", "com/intellij/pom/core/impl/PomModelImpl", "getContainingFileByTree"));
        }
        ASTNode node = changeScope.getNode();
        if (node == null) {
            psiFile = changeScope.getContainingFile();
        } else {
            FileElement fileElement = TreeUtil.getFileElement((TreeElement)node);
            if (fileElement == null) {
                return null;
            }
            psiFile = (PsiFile)fileElement.getPsi();
        }
        return psiFile.getNode() != null ? psiFile : null;
    }

    public static <T extends Throwable> void guardPsiModificationsIn(@NotNull ThrowableRunnable<T> runnable) throws T {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/pom/core/impl/PomModelImpl", "guardPsiModificationsIn"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean old = allowPsiModification;
        try {
            allowPsiModification = false;
            runnable.run();
        }
        finally {
            allowPsiModification = old;
        }
    }

    public static boolean isAllowPsiModification() {
        return allowPsiModification;
    }
}

