/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.ui.UIUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

class StaticInheritanceFix
extends InspectionGadgetsFix {
    private final boolean myReplaceInWholeProject;

    StaticInheritanceFix(boolean replaceInWholeProject) {
        this.myReplaceInWholeProject = replaceInWholeProject;
    }

    @Override
    @NotNull
    public String getName() {
        String scope = this.myReplaceInWholeProject ? InspectionGadgetsBundle.message("the.whole.project", new Object[0]) : InspectionGadgetsBundle.message("this.class", new Object[0]);
        String string = InspectionGadgetsBundle.message("static.inheritance.replace.quickfix", scope);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/StaticInheritanceFix", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Replace inheritance with qualified reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/StaticInheritanceFix", "getFamilyName"));
        }
        return "Replace inheritance with qualified reference";
    }

    @Override
    public void doFix(final Project project, final ProblemDescriptor descriptor) throws IncorrectOperationException {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                StaticInheritanceFix.this.dodoFix(project, descriptor);
            }
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    private void dodoFix(final Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)descriptor.getPsiElement();
        final PsiClass iface = (PsiClass)referenceElement.resolve();
        assert (iface != null);
        final PsiField[] allFields = iface.getAllFields();
        final PsiClass implementingClass = ClassUtils.getContainingClass(referenceElement);
        final PsiManager manager = referenceElement.getManager();
        assert (implementingClass != null);
        final PsiFile file = implementingClass.getContainingFile();
        ProgressManager.getInstance().run(new Task.Modal(project, "Replacing usages of " + iface.getName(), false){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/siyeh/ig/inheritance/StaticInheritanceFix$2", "run"));
                }
                for (final PsiField field : allFields) {
                    SearchScope scope = ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

                        @Override
                        public SearchScope compute() {
                            return implementingClass.getUseScope();
                        }
                    });
                    Query<PsiReference> search = ReferencesSearch.search(field, scope, false);
                    for (PsiReference reference : search) {
                        boolean isInheritor;
                        if (!(reference instanceof PsiReferenceExpression)) continue;
                        final PsiReferenceExpression referenceExpression = (PsiReferenceExpression)reference;
                        if (!StaticInheritanceFix.this.myReplaceInWholeProject && !(isInheritor = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                            @Override
                            public Boolean compute() {
                                boolean isInheritor = false;
                                PsiClass aClass = PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
                                while (aClass != null && !(isInheritor = InheritanceUtil.isInheritorOrSelf(aClass, implementingClass, true))) {
                                    aClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
                                }
                                return isInheritor;
                            }
                        }).booleanValue())) continue;
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                if (!FileModificationService.getInstance().preparePsiElementsForWrite(referenceExpression)) {
                                    return;
                                }
                                PsiElementFactory elementFactory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
                                PsiReferenceExpression qualified = (PsiReferenceExpression)elementFactory.createExpressionFromText("xxx." + referenceExpression.getText(), referenceExpression);
                                PsiReferenceExpression newReference = (PsiReferenceExpression)referenceExpression.replace(qualified);
                                PsiReferenceExpression qualifier = (PsiReferenceExpression)newReference.getQualifierExpression();
                                assert (qualifier != null) : DebugUtil.psiToString(newReference, false);
                                PsiClass containingClass = field.getContainingClass();
                                qualifier.bindToElement(containingClass);
                            }
                        };
                        StaticInheritanceFix.invokeWriteAction(runnable, file);
                    }
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        PsiClassType classType = JavaPsiFacade.getInstance(project).getElementFactory().createType(iface);
                        LocalQuickFixAndIntentionActionOnPsiElement fix = QuickFixFactory.getInstance().createExtendsListFix(implementingClass, classType, false);
                        fix.invoke(project, null, file);
                    }
                };
                StaticInheritanceFix.invokeWriteAction(runnable, file);
            }
        });
    }

    private static void invokeWriteAction(final Runnable runnable, final PsiFile file) {
        UIUtil.invokeLaterIfNeeded(new Runnable(){

            @Override
            public void run() {
                new WriteCommandAction(file.getProject(), new PsiFile[]{file}){

                    @Override
                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/siyeh/ig/inheritance/StaticInheritanceFix$3$1", "run"));
                        }
                        runnable.run();
                    }
                }.execute();
            }
        });
    }
}

