/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateThrows;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.DeleteThrowsFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateThrowsInspection
extends BaseJavaBatchLocalInspectionTool
implements CleanupLocalInspectionTool {
    public boolean ignoreSubclassing = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.duplicate.throws.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("DuplicateThrows" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection", "getShortName"));
        }
        return "DuplicateThrows";
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message("inspection.duplicate.throws.ignore.subclassing.option", new Object[0]), this, "ignoreSubclassing");
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethod(PsiMethod method) {
                PsiReferenceList throwsList = method.getThrowsList();
                PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
                PsiClassType[] types = throwsList.getReferencedTypes();
                for (int i = 0; i < types.length; ++i) {
                    for (int j = i + 1; j < types.length; ++j) {
                        PsiClassType type = types[i];
                        PsiClassType otherType = types[j];
                        String problem = null;
                        PsiJavaCodeReferenceElement ref = refs[i];
                        if (type.equals(otherType)) {
                            problem = InspectionsBundle.message("inspection.duplicate.throws.problem", new Object[0]);
                        } else if (!DuplicateThrowsInspection.this.ignoreSubclassing) {
                            if (otherType.isAssignableFrom(type)) {
                                problem = InspectionsBundle.message("inspection.duplicate.throws.more.general.problem", otherType.getCanonicalText());
                            } else if (type.isAssignableFrom(otherType)) {
                                problem = InspectionsBundle.message("inspection.duplicate.throws.more.general.problem", type.getCanonicalText());
                                ref = refs[j];
                                type = otherType;
                            }
                        }
                        if (problem == null) continue;
                        holder.registerProblem((PsiElement)ref, problem, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new DeleteThrowsFix(method, type));
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }
}

