/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateMemberAccessBetweenOuterAndInnerClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.problem.descriptor", aClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        if (infos.length == 1) {
            return new MakePackagePrivateFix(className, true);
        }
        PsiMember member = (PsiMember)infos[1];
        String memberName = member instanceof PsiMethod ? member.getName() + "()" : member.getName();
        String elementName = className + '.' + memberName;
        return new MakePackagePrivateFix(elementName, false);
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PrivateMemberAccessFromInnerClassVisitor();
    }

    private static class PrivateMemberAccessFromInnerClassVisitor
    extends BaseInspectionVisitor {
        private PrivateMemberAccessFromInnerClassVisitor() {
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (expression.getType() instanceof PsiArrayType) {
                return;
            }
            PsiClass containingClass = PrivateMemberAccessFromInnerClassVisitor.getContainingContextClass(expression);
            if (containingClass == null) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
                if (classReference == null) {
                    return;
                }
                PsiElement target = classReference.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                PsiClass aClass = (PsiClass)target;
                if (!aClass.hasModifierProperty("private")) {
                    return;
                }
                if (aClass.equals(containingClass)) {
                    return;
                }
                this.registerNewExpressionError(expression, aClass);
            } else {
                if (!constructor.hasModifierProperty("private")) {
                    return;
                }
                PsiClass aClass = constructor.getContainingClass();
                if (containingClass.equals(aClass)) {
                    return;
                }
                this.registerNewExpressionError(expression, aClass);
            }
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$PrivateMemberAccessFromInnerClassVisitor", "visitReferenceExpression"));
            }
            super.visitReferenceExpression(expression);
            PsiElement referenceNameElement = expression.getReferenceNameElement();
            if (referenceNameElement == null) {
                return;
            }
            PsiElement element = expression.resolve();
            if (!(element instanceof PsiMethod) && !(element instanceof PsiField)) {
                return;
            }
            PsiMember member = (PsiMember)element;
            if (!member.hasModifierProperty("private")) {
                return;
            }
            Object value = ExpressionUtils.computeConstantExpression(expression);
            if (value != null) {
                return;
            }
            PsiClass containingClass = PrivateMemberAccessFromInnerClassVisitor.getContainingContextClass(expression);
            if (containingClass == null) {
                return;
            }
            PsiClass memberClass = ClassUtils.getContainingClass(member);
            if (memberClass == null || memberClass.equals(containingClass) || !PsiTreeUtil.isAncestor(containingClass, memberClass, true) && !PsiTreeUtil.isAncestor(memberClass, containingClass, true)) {
                return;
            }
            this.registerError(referenceNameElement, memberClass, member);
        }

        @Nullable
        private static PsiClass getContainingContextClass(PsiElement element) {
            PsiAnonymousClass anonymousClass;
            PsiExpressionList arguments;
            PsiClass aClass = ClassUtils.getContainingClass(element);
            if (aClass instanceof PsiAnonymousClass && (arguments = (anonymousClass = (PsiAnonymousClass)aClass).getArgumentList()) != null && PsiTreeUtil.isAncestor(arguments, element, true)) {
                return ClassUtils.getContainingClass(aClass);
            }
            return aClass;
        }
    }

    private static class MakePackagePrivateFix
    extends InspectionGadgetsFix {
        private final String elementName;
        private final boolean constructor;

        private MakePackagePrivateFix(String elementName, boolean constructor) {
            this.elementName = elementName;
            this.constructor = constructor;
        }

        @Override
        @NotNull
        public String getName() {
            if (this.constructor) {
                String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.constructor.package.local.quickfix", this.elementName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$MakePackagePrivateFix", "getName"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.local.quickfix", this.elementName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$MakePackagePrivateFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Make package-local" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$MakePackagePrivateFix", "getFamilyName"));
            }
            return "Make package-local";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (this.constructor) {
                MakePackagePrivateFix.makeConstructorPackageLocal(project, element);
            } else {
                MakePackagePrivateFix.makeMemberPackageLocal(element);
            }
        }

        private static void makeMemberPackageLocal(PsiElement element) {
            PsiElement parent = element.getParent();
            PsiReferenceExpression reference = (PsiReferenceExpression)parent;
            PsiModifierListOwner member = (PsiModifierListOwner)reference.resolve();
            if (member == null) {
                return;
            }
            PsiModifierList modifiers = member.getModifierList();
            if (modifiers == null) {
                return;
            }
            modifiers.setModifierProperty("public", false);
            modifiers.setModifierProperty("protected", false);
            modifiers.setModifierProperty("private", false);
        }

        private static void makeConstructorPackageLocal(Project project, PsiElement element) {
            PsiNewExpression newExpression = PsiTreeUtil.getParentOfType(element, PsiNewExpression.class);
            if (newExpression == null) {
                return;
            }
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor != null) {
                PsiModifierList modifierList = constructor.getModifierList();
                modifierList.setModifierProperty("private", false);
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
            PsiMethod newConstructor = elementFactory.createConstructor();
            PsiModifierList modifierList = newConstructor.getModifierList();
            modifierList.setModifierProperty("packageLocal", true);
            aClass.add(newConstructor);
        }
    }
}

