/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousMethodCallUtil {
    static void setupPatternMethods(PsiManager manager, GlobalSearchScope searchScope, List<PsiMethod> patternMethods, IntArrayList indices) {
        PsiClass concurrentMapClass;
        PsiClass mapClass;
        PsiClass listClass;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(manager.getProject());
        PsiClass collectionClass = javaPsiFacade.findClass("java.util.Collection", searchScope);
        PsiType[] javaLangObject = new PsiType[]{PsiType.getJavaLangObject(manager, searchScope)};
        MethodSignature removeSignature = MethodSignatureUtil.createMethodSignature("remove", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
        if (collectionClass != null) {
            PsiMethod remove = MethodSignatureUtil.findMethodBySignature(collectionClass, removeSignature, false);
            SuspiciousMethodCallUtil.addMethod(remove, 0, patternMethods, indices);
            MethodSignature containsSignature = MethodSignatureUtil.createMethodSignature("contains", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod contains = MethodSignatureUtil.findMethodBySignature(collectionClass, containsSignature, false);
            SuspiciousMethodCallUtil.addMethod(contains, 0, patternMethods, indices);
            if (PsiUtil.isLanguageLevel5OrHigher(collectionClass)) {
                PsiClassType wildcardCollection = javaPsiFacade.getElementFactory().createType(collectionClass, (PsiType)PsiWildcardType.createUnbounded(manager));
                MethodSignature removeAllSignature = MethodSignatureUtil.createMethodSignature("removeAll", new PsiType[]{wildcardCollection}, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
                PsiMethod removeAll = MethodSignatureUtil.findMethodBySignature(collectionClass, removeAllSignature, false);
                SuspiciousMethodCallUtil.addMethod(removeAll, 0, patternMethods, indices);
            }
        }
        if ((listClass = javaPsiFacade.findClass("java.util.List", searchScope)) != null) {
            MethodSignature indexofSignature = MethodSignatureUtil.createMethodSignature("indexOf", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod indexof = MethodSignatureUtil.findMethodBySignature(listClass, indexofSignature, false);
            SuspiciousMethodCallUtil.addMethod(indexof, 0, patternMethods, indices);
            MethodSignature lastindexofSignature = MethodSignatureUtil.createMethodSignature("lastIndexOf", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod lastindexof = MethodSignatureUtil.findMethodBySignature(listClass, lastindexofSignature, false);
            SuspiciousMethodCallUtil.addMethod(lastindexof, 0, patternMethods, indices);
        }
        if ((mapClass = javaPsiFacade.findClass("java.util.Map", searchScope)) != null) {
            PsiMethod remove = MethodSignatureUtil.findMethodBySignature(mapClass, removeSignature, false);
            SuspiciousMethodCallUtil.addMethod(remove, 0, patternMethods, indices);
            MethodSignature getSignature = MethodSignatureUtil.createMethodSignature("get", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod get = MethodSignatureUtil.findMethodBySignature(mapClass, getSignature, false);
            SuspiciousMethodCallUtil.addMethod(get, 0, patternMethods, indices);
            MethodSignature containsKeySignature = MethodSignatureUtil.createMethodSignature("containsKey", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod containsKey = MethodSignatureUtil.findMethodBySignature(mapClass, containsKeySignature, false);
            SuspiciousMethodCallUtil.addMethod(containsKey, 0, patternMethods, indices);
            MethodSignature containsValueSignature = MethodSignatureUtil.createMethodSignature("containsValue", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod containsValue = MethodSignatureUtil.findMethodBySignature(mapClass, containsValueSignature, false);
            SuspiciousMethodCallUtil.addMethod(containsValue, 1, patternMethods, indices);
        }
        if ((concurrentMapClass = javaPsiFacade.findClass("java.util.concurrent.ConcurrentHashMap", searchScope)) != null) {
            MethodSignature containsSignature = MethodSignatureUtil.createMethodSignature("contains", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod contains = MethodSignatureUtil.findMethodBySignature(concurrentMapClass, containsSignature, false);
            SuspiciousMethodCallUtil.addMethod(contains, 1, patternMethods, indices);
        }
    }

    private static void addMethod(PsiMethod patternMethod, int typeParamIndex, List<PsiMethod> patternMethods, IntArrayList indices) {
        if (patternMethod != null) {
            patternMethods.add(patternMethod);
            indices.add(typeParamIndex);
        }
    }

    static boolean isInheritorOrSelf(PsiMethod inheritorCandidate, PsiMethod base) {
        PsiClass aClass = inheritorCandidate.getContainingClass();
        PsiClass bClass = base.getContainingClass();
        if (aClass == null || bClass == null) {
            return false;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor(bClass, aClass, PsiSubstitutor.EMPTY);
        return substitutor != null && MethodSignatureUtil.findMethodBySignature(bClass, inheritorCandidate.getSignature(substitutor), false) == base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getSuspiciousMethodCallMessage(@NotNull PsiMethodCallExpression methodCall, PsiType argType, boolean reportConvertibleMethodCalls, @NotNull List<PsiMethod> patternMethods, @NotNull IntArrayList indices) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/miscGenerics/SuspiciousMethodCallUtil", "getSuspiciousMethodCallMessage"));
        }
        if (patternMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMethods", "com/intellij/codeInspection/miscGenerics/SuspiciousMethodCallUtil", "getSuspiciousMethodCallMessage"));
        }
        if (indices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indices", "com/intellij/codeInspection/miscGenerics/SuspiciousMethodCallUtil", "getSuspiciousMethodCallMessage"));
        }
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
            return null;
        }
        if (argType instanceof PsiPrimitiveType) {
            argType = ((PsiPrimitiveType)argType).getBoxedType(methodCall);
        }
        if (argType == null) {
            return null;
        }
        JavaResolveResult resolveResult = methodExpression.advancedResolve(false);
        PsiMethod calleeMethod = (PsiMethod)resolveResult.getElement();
        if (calleeMethod == null) {
            return null;
        }
        PsiMethod contextMethod = PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
        List<PsiMethod> list = patternMethods;
        synchronized (list) {
            if (patternMethods.isEmpty()) {
                SuspiciousMethodCallUtil.setupPatternMethods(methodCall.getManager(), methodCall.getResolveScope(), patternMethods, indices);
            }
        }
        for (int i = 0; i < patternMethods.size(); ++i) {
            PsiType paramType;
            PsiMethod patternMethod = patternMethods.get(i);
            if (!patternMethod.getName().equals(methodExpression.getReferenceName())) continue;
            int index = indices.get(i);
            if (contextMethod != null && SuspiciousMethodCallUtil.isInheritorOrSelf(contextMethod, patternMethod)) {
                return null;
            }
            PsiClass calleeClass = calleeMethod.getContainingClass();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            PsiClass patternClass = patternMethod.getContainingClass();
            assert (patternClass != null);
            assert (calleeClass != null);
            if ((substitutor = TypeConversionUtil.getClassSubstitutor(patternClass, calleeClass, substitutor)) == null || !patternMethod.getSignature(substitutor).equals(calleeMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
            PsiTypeParameter[] typeParameters = patternClass.getTypeParameters();
            if (typeParameters.length <= index) {
                return null;
            }
            PsiTypeParameter typeParameter = typeParameters[index];
            PsiType typeParamMapping = substitutor.substitute(typeParameter);
            if (typeParamMapping == null) {
                return null;
            }
            PsiParameter[] parameters = patternMethod.getParameterList().getParameters();
            if (parameters.length == 1 && "removeAll".equals(patternMethod.getName()) && InheritanceUtil.isInheritor(paramType = parameters[0].getType(), "java.util.Collection")) {
                PsiType qualifierType = qualifier.getType();
                if (qualifierType != null) {
                    PsiType itemType = JavaGenericsUtil.getCollectionItemType(argType, calleeMethod.getResolveScope());
                    PsiType qualifierItemType = JavaGenericsUtil.getCollectionItemType(qualifierType, calleeMethod.getResolveScope());
                    if (qualifierItemType != null && itemType != null && !qualifierItemType.isAssignableFrom(itemType)) {
                        return InspectionsBundle.message("inspection.suspicious.collections.method.calls.problem.descriptor", PsiFormatUtil.formatType(qualifierType, 0, PsiSubstitutor.EMPTY), PsiFormatUtil.formatType(itemType, 0, PsiSubstitutor.EMPTY));
                    }
                }
                return null;
            }
            String message = null;
            if (typeParamMapping instanceof PsiCapturedWildcardType) {
                typeParamMapping = ((PsiCapturedWildcardType)typeParamMapping).getWildcard();
            }
            if (!typeParamMapping.isAssignableFrom(argType)) {
                if (typeParamMapping.isConvertibleFrom(argType)) {
                    if (reportConvertibleMethodCalls) {
                        message = InspectionsBundle.message("inspection.suspicious.collections.method.calls.problem.descriptor1", PsiFormatUtil.formatMethod(calleeMethod, substitutor, 4097, 2));
                    }
                } else {
                    PsiType qualifierType = qualifier.getType();
                    if (qualifierType != null) {
                        message = InspectionsBundle.message("inspection.suspicious.collections.method.calls.problem.descriptor", PsiFormatUtil.formatType(qualifierType, 0, PsiSubstitutor.EMPTY), PsiFormatUtil.formatType(argType, 0, PsiSubstitutor.EMPTY));
                    }
                }
            }
            return message;
        }
        return null;
    }
}

