/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredHighlighterIterator;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.ex.util.LimitedRangeHighlighterIterator;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TIntIntHashMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredLexerEditorHighlighter
extends LexerEditorHighlighter {
    private final Map<IElementType, LayerDescriptor> myTokensToLayer;
    private final Map<LayerDescriptor, Mapper> myLayerBuffers;
    private CharSequence myText;

    public LayeredLexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter", "<init>"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter", "<init>"));
        }
        super(highlighter, scheme);
        this.myTokensToLayer = new HashMap<IElementType, LayerDescriptor>();
        this.myLayerBuffers = new HashMap<LayerDescriptor, Mapper>();
    }

    @Override
    protected SegmentArrayWithData createSegments() {
        return new MappingSegments();
    }

    public synchronized void registerLayer(IElementType tokenType, LayerDescriptor layerHighlighter) {
        this.myTokensToLayer.put(tokenType, layerHighlighter);
        this.getSegments().removeAll();
    }

    public synchronized void unregisterLayer(IElementType tokenType) {
        LayerDescriptor layer = this.myTokensToLayer.remove(tokenType);
        if (layer != null) {
            this.myLayerBuffers.remove(layer);
            this.getSegments().removeAll();
        }
    }

    @Override
    public MappingSegments getSegments() {
        return (MappingSegments)super.getSegments();
    }

    @Override
    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter", "setText"));
        }
        this.updateLayers();
        this.myText = text;
        super.setText(text);
    }

    @Override
    protected LexerEditorHighlighter.TokenProcessor createTokenProcessor(final int startIndex) {
        return new LexerEditorHighlighter.TokenProcessor(){
            final Map<Mapper, LightMapper> docTexts;
            {
                super(LayeredLexerEditorHighlighter.this);
                this.docTexts = new FactoryMap<Mapper, LightMapper>(){

                    @Override
                    protected LightMapper create(Mapper key) {
                        MappedRange predecessor = key.findPredecessor(startIndex);
                        return new LightMapper(key, predecessor != null ? predecessor.range.getEndOffset() : 0);
                    }
                };
            }

            @Override
            public void addToken(int i, int startOffset, int endOffset, int data, IElementType tokenType) {
                LayeredLexerEditorHighlighter.this.getSegments().setElementLight(i, startOffset, endOffset, data);
                Mapper mapper = LayeredLexerEditorHighlighter.this.getMappingDocument(tokenType);
                if (mapper != null) {
                    this.docTexts.get(mapper).addToken(LayeredLexerEditorHighlighter.this.myText.subSequence(startOffset, endOffset), tokenType, i);
                }
            }

            @Override
            public void finish() {
                for (LightMapper mapper : this.docTexts.values()) {
                    mapper.finish();
                }
            }
        };
    }

    protected boolean updateLayers() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(DocumentEvent e) {
        boolean b = this.updateLayers();
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        synchronized (layeredLexerEditorHighlighter) {
            this.myText = e.getDocument().getCharsSequence();
            if (b) {
                this.setText(this.myText);
            } else {
                super.documentChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        boolean b = this.updateLayers();
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        // MONITORENTER : layeredLexerEditorHighlighter
        if (b) {
            this.setText(this.myText);
        }
        LayeredHighlighterIteratorImpl layeredHighlighterIteratorImpl = new LayeredHighlighterIteratorImpl(startOffset);
        // MONITOREXIT : layeredLexerEditorHighlighter
        if (layeredHighlighterIteratorImpl != null) return layeredHighlighterIteratorImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter", "createIterator"));
    }

    @Nullable
    private Mapper getMappingDocument(IElementType token) {
        LayerDescriptor descriptor = this.myTokensToLayer.get(token);
        if (descriptor == null) {
            return null;
        }
        Mapper mapper = this.myLayerBuffers.get(descriptor);
        if (mapper == null) {
            mapper = new Mapper(descriptor);
            this.myLayerBuffers.put(descriptor, mapper);
        }
        return mapper;
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter", "setColorScheme"));
        }
        super.setColorScheme(scheme);
        for (MappedRange mapping : this.getSegments().myRanges) {
            Mapper mapper;
            Mapper mapper2 = mapper = mapping == null ? null : mapping.mapper;
            if (mapper == null) continue;
            mapper.resetCachedTextAttributes();
        }
    }

    @NotNull
    protected static <T> T[] reallocateArray(@NotNull T[] array, int index) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter", "reallocateArray"));
        }
        if (index < array.length) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter", "reallocateArray"));
            }
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), SegmentArray.calcCapacity(array.length, index));
        System.arraycopy(array, 0, newArray, 0, array.length);
        if (newArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter", "reallocateArray"));
        }
        return newArray;
    }

    private class LayeredHighlighterIteratorImpl
    implements LayeredHighlighterIterator {
        private final HighlighterIterator myBaseIterator;
        private HighlighterIterator myLayerIterator;
        private int myLayerStartOffset = 0;
        private Mapper myCurrentMapper;

        private LayeredHighlighterIteratorImpl(int offset) {
            this.myBaseIterator = LayeredLexerEditorHighlighter.super.createIterator(offset);
            if (!this.myBaseIterator.atEnd()) {
                int shift = offset - this.myBaseIterator.getStart();
                this.initLayer(shift);
            }
        }

        private void initLayer(int shiftInToken) {
            if (this.myBaseIterator.atEnd()) {
                this.myLayerIterator = null;
                this.myCurrentMapper = null;
                return;
            }
            MappedRange mapping = LayeredLexerEditorHighlighter.this.getSegments().myRanges[((LexerEditorHighlighter.HighlighterIteratorImpl)this.myBaseIterator).currentIndex()];
            if (mapping != null) {
                this.myCurrentMapper = mapping.mapper;
                this.myLayerIterator = this.myCurrentMapper.createIterator(mapping, shiftInToken);
                this.myLayerStartOffset = this.myBaseIterator.getStart() - mapping.range.getStartOffset();
            } else {
                this.myCurrentMapper = null;
                this.myLayerIterator = null;
            }
        }

        @Override
        public TextAttributes getTextAttributes() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.getAttributes(this.getTokenType());
            }
            return this.myBaseIterator.getTextAttributes();
        }

        @Override
        public SyntaxHighlighter getActiveSyntaxHighlighter() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.mySyntaxHighlighter;
            }
            return LayeredLexerEditorHighlighter.this.getSyntaxHighlighter();
        }

        @Override
        public int getStart() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getStart() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getStart();
        }

        @Override
        public int getEnd() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getEnd() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getEnd();
        }

        @Override
        public IElementType getTokenType() {
            return this.myLayerIterator != null ? this.myLayerIterator.getTokenType() : this.myBaseIterator.getTokenType();
        }

        @Override
        public void advance() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.advance();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.advance();
            this.initLayer(0);
        }

        @Override
        public void retreat() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.retreat();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.retreat();
            this.initLayer(this.myBaseIterator.atEnd() ? 0 : this.myBaseIterator.getEnd() - this.myBaseIterator.getStart() - 1);
        }

        @Override
        public boolean atEnd() {
            return this.myBaseIterator.atEnd();
        }

        @Override
        public Document getDocument() {
            return this.myBaseIterator.getDocument();
        }
    }

    private static class MappedRange {
        private RangeMarker range;
        private final Mapper mapper;
        private final IElementType outerToken;

        MappedRange(@NotNull Mapper mapper, @NotNull RangeMarker range, @NotNull IElementType outerToken) {
            if (mapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappedRange", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappedRange", "<init>"));
            }
            if (outerToken == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerToken", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappedRange", "<init>"));
            }
            this.mapper = mapper;
            this.range = range;
            this.outerToken = outerToken;
            assert (mapper.doc == range.getDocument());
        }
    }

    private class Mapper
    implements HighlighterClient {
        private final DocumentImpl doc;
        private final EditorHighlighter highlighter;
        private final String mySeparator;
        private final Map<IElementType, TextAttributes> myAttributesMap = new HashMap<IElementType, TextAttributes>();
        private final SyntaxHighlighter mySyntaxHighlighter;
        private final TextAttributesKey myBackground;

        private Mapper(LayerDescriptor descriptor) {
            this.doc = new DocumentImpl("", true);
            this.mySyntaxHighlighter = descriptor.getLayerHighlighter();
            this.myBackground = descriptor.getBackgroundKey();
            this.highlighter = new LexerEditorHighlighter(this.mySyntaxHighlighter, LayeredLexerEditorHighlighter.this.getScheme());
            this.mySeparator = descriptor.getTokenSeparator();
            this.highlighter.setEditor(this);
            this.doc.addDocumentListener(this.highlighter);
        }

        public TextAttributes getAttributes(IElementType tokenType) {
            TextAttributes attrs = this.myAttributesMap.get(tokenType);
            if (attrs == null) {
                attrs = LayeredLexerEditorHighlighter.this.convertAttributes(SyntaxHighlighterBase.pack(this.myBackground, this.mySyntaxHighlighter.getTokenHighlights(tokenType)));
                this.myAttributesMap.put(tokenType, attrs);
            }
            return attrs;
        }

        public HighlighterIterator createIterator(MappedRange mapper, int shift) {
            int rangeStart = mapper.range.getStartOffset();
            int rangeEnd = mapper.range.getEndOffset();
            return new LimitedRangeHighlighterIterator(this.highlighter.createIterator(rangeStart + shift), rangeStart, rangeEnd);
        }

        @Override
        public Project getProject() {
            return LayeredLexerEditorHighlighter.this.getClient().getProject();
        }

        @Override
        public void repaint(int start, int end) {
        }

        @Override
        public Document getDocument() {
            return LayeredLexerEditorHighlighter.this.getDocument();
        }

        public void resetCachedTextAttributes() {
            this.myAttributesMap.clear();
        }

        public void updateMapping(int tokenIndex, MappedRange oldMapping) {
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int start = oldMapping.range.getStartOffset();
            int end = oldMapping.range.getEndOffset();
            if (Comparing.equal(this.doc.getCharsSequence().subSequence(start, end), tokenText)) {
                return;
            }
            this.doc.replaceString(start, end, tokenText);
            int newEnd = start + tokenText.length();
            if (oldMapping.range.getStartOffset() != start || oldMapping.range.getEndOffset() != newEnd) {
                assert (oldMapping.range.getDocument() == this.doc);
                oldMapping.range.dispose();
                oldMapping.range = this.doc.createRangeMarker(start, newEnd);
            }
        }

        @NotNull
        private MappedRange insertMapping(int tokenIndex, IElementType outerToken) {
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int length = tokenText.length();
            MappedRange predecessor = this.findPredecessor(tokenIndex);
            int insertOffset = predecessor != null ? predecessor.range.getEndOffset() : 0;
            this.doc.insertString(insertOffset, new MergingCharSequence(this.mySeparator, tokenText));
            RangeMarker marker = this.doc.createRangeMarker(insertOffset += this.mySeparator.length(), insertOffset + length);
            MappedRange mappedRange = new MappedRange(this, marker, outerToken);
            if (mappedRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$Mapper", "insertMapping"));
            }
            return mappedRange;
        }

        private CharSequence getTokenText(int tokenIndex) {
            return LayeredLexerEditorHighlighter.this.myText.subSequence(LayeredLexerEditorHighlighter.this.getSegments().getSegmentStart(tokenIndex), LayeredLexerEditorHighlighter.this.getSegments().getSegmentEnd(tokenIndex));
        }

        @Nullable
        private MappedRange findPredecessor(int token) {
            --token;
            while (token >= 0) {
                MappedRange mappedRange = LayeredLexerEditorHighlighter.this.getSegments().myRanges[token];
                if (mappedRange != null && mappedRange.mapper == this) {
                    return mappedRange;
                }
                --token;
            }
            return null;
        }

        private void removeMapping(MappedRange mapping) {
            RangeMarker rangeMarker = mapping.range;
            if (rangeMarker.isValid()) {
                int start = rangeMarker.getStartOffset();
                int end = rangeMarker.getEndOffset();
                assert (this.doc == rangeMarker.getDocument());
                this.doc.deleteString(start - this.mySeparator.length(), end);
                rangeMarker.dispose();
            }
        }
    }

    private class MappingSegments
    extends SegmentArrayWithData {
        MappedRange[] myRanges = new MappedRange[64];

        private MappingSegments() {
        }

        @Override
        public void removeAll() {
            if (this.mySegmentCount != 0) {
                Arrays.fill(this.myRanges, null);
            }
            LayeredLexerEditorHighlighter.this.myLayerBuffers.clear();
            super.removeAll();
        }

        @Override
        public void setElementAt(int i, int startOffset, int endOffset, int data) {
            this.setElementLight(i, startOffset, endOffset, (short)data);
            MappedRange range = this.myRanges[i];
            if (range != null) {
                range.mapper.removeMapping(range);
                this.myRanges[i] = null;
            }
            this.updateMappingForToken(i);
        }

        private void setElementLight(int i, int startOffset, int endOffset, int data) {
            super.setElementAt(i, startOffset, endOffset, data);
            this.myRanges = LayeredLexerEditorHighlighter.reallocateArray(this.myRanges, i + 1);
        }

        @Override
        public void remove(int startIndex, int endIndex) {
            FactoryMap<Mapper, Integer> mins = new FactoryMap<Mapper, Integer>(){

                @Override
                protected Integer create(Mapper key) {
                    return Integer.MAX_VALUE;
                }
            };
            FactoryMap<Mapper, Integer> maxs = new FactoryMap<Mapper, Integer>(){

                @Override
                protected Integer create(Mapper key) {
                    return 0;
                }
            };
            for (int i = startIndex; i < endIndex; ++i) {
                MappedRange range = this.myRanges[i];
                if (range != null && range.range.isValid()) {
                    mins.put(range.mapper, Math.min((Integer)mins.get(range.mapper), range.range.getStartOffset()));
                    maxs.put(range.mapper, Math.max((Integer)maxs.get(range.mapper), range.range.getEndOffset()));
                }
                this.myRanges[i] = null;
            }
            for (Mapper mapper : maxs.keySet()) {
                mapper.doc.deleteString((Integer)mins.get(mapper), (Integer)maxs.get(mapper));
            }
            this.myRanges = this.remove(this.myRanges, startIndex, endIndex);
            super.remove(startIndex, endIndex);
        }

        @Override
        public void replace(int startOffset, @NotNull SegmentArrayWithData data, int len) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments", "replace"));
            }
            super.replace(startOffset, data, len);
            for (int i = startOffset; i < startOffset + len; ++i) {
                this.updateMappingForToken(i);
            }
        }

        @NotNull
        private <T> T[] insert(@NotNull T[] array, @NotNull T[] insertArray, int startIndex, int insertLength) {
            if (array == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments", "insert"));
            }
            if (insertArray == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertArray", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments", "insert"));
            }
            T[] newArray = LayeredLexerEditorHighlighter.reallocateArray(array, this.mySegmentCount + insertLength);
            if (startIndex < this.mySegmentCount) {
                System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
            }
            System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
            if (newArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments", "insert"));
            }
            return newArray;
        }

        @NotNull
        private <T> T[] remove(@NotNull T[] array, int startIndex, int endIndex) {
            if (array == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments", "remove"));
            }
            if (endIndex < this.mySegmentCount) {
                System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
            }
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments", "remove"));
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
            if (segmentArray == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentArray", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments", "insert"));
            }
            LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = LayeredLexerEditorHighlighter.this;
            synchronized (layeredLexerEditorHighlighter) {
                super.insert(segmentArray, startIndex);
                int newCount = segmentArray.getSegmentCount();
                MappedRange[] newRanges = new MappedRange[newCount];
                this.myRanges = this.insert(this.myRanges, newRanges, startIndex, newCount);
                int endIndex = startIndex + segmentArray.getSegmentCount();
                LexerEditorHighlighter.TokenProcessor processor = LayeredLexerEditorHighlighter.this.createTokenProcessor(startIndex);
                for (int i = startIndex; i < endIndex; ++i) {
                    short data = this.getSegmentData(i);
                    IElementType token = LexerEditorHighlighter.unpackToken(data);
                    processor.addToken(i, this.getSegmentStart(i), this.getSegmentEnd(i), data, token);
                }
                processor.finish();
            }
        }

        private void updateMappingForToken(int i) {
            short data = this.getSegmentData(i);
            IElementType token = LexerEditorHighlighter.unpackToken(data);
            Mapper mapper = LayeredLexerEditorHighlighter.this.getMappingDocument(token);
            MappedRange oldMapping = this.myRanges[i];
            if (mapper != null) {
                if (oldMapping != null) {
                    if (oldMapping.mapper == mapper && oldMapping.outerToken == token) {
                        mapper.updateMapping(i, oldMapping);
                    } else {
                        oldMapping.mapper.removeMapping(oldMapping);
                        this.myRanges[i] = mapper.insertMapping(i, token);
                    }
                } else {
                    this.myRanges[i] = mapper.insertMapping(i, token);
                }
            } else if (oldMapping != null) {
                oldMapping.mapper.removeMapping(oldMapping);
                this.myRanges[i] = null;
            }
        }
    }

    private class LightMapper {
        final Mapper mapper;
        final StringBuilder text = new StringBuilder();
        final IntArrayList lengths = new IntArrayList();
        final List<IElementType> tokenTypes = new ArrayList<IElementType>();
        final TIntIntHashMap index2Global = new TIntIntHashMap();
        private final String mySeparator;
        final int insertOffset;

        LightMapper(Mapper mapper, int insertOffset) {
            this.mapper = mapper;
            this.mySeparator = mapper.mySeparator;
            this.insertOffset = insertOffset;
        }

        void addToken(CharSequence tokenText, IElementType tokenType, int globalIndex) {
            this.index2Global.put(this.tokenTypes.size(), globalIndex);
            this.text.append(this.mySeparator).append(tokenText);
            this.lengths.add(tokenText.length());
            this.tokenTypes.add(tokenType);
        }

        void finish() {
            assert (this.insertOffset >= 0);
            DocumentImpl document = this.mapper.doc;
            document.insertString(this.insertOffset, this.text);
            int start = this.insertOffset;
            for (int i = 0; i < this.tokenTypes.size(); ++i) {
                IElementType type = this.tokenTypes.get(i);
                int len = this.lengths.get(i);
                start += this.mySeparator.length();
                int globalIndex = this.index2Global.get(i);
                assert (LayeredLexerEditorHighlighter.this.getSegments().myRanges[globalIndex] == null) : LayeredLexerEditorHighlighter.access$300(LayeredLexerEditorHighlighter.this);
                LayeredLexerEditorHighlighter.this.getSegments().myRanges[globalIndex] = new MappedRange(this.mapper, document.createRangeMarker(start, start + len), type);
                start += len;
            }
        }
    }
}

