/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeLiteralEscaper
extends LiteralTextEscaper<XmlAttributeValueImpl> {
    private final XmlAttribute myXmlAttribute;

    public XmlAttributeLiteralEscaper(XmlAttributeValueImpl host) {
        super(host);
        PsiElement parent = host.getParent();
        this.myXmlAttribute = parent instanceof XmlAttribute ? (XmlAttribute)parent : XmlElementFactory.getInstance(host.getProject()).createXmlAttribute("a", host.getValue());
    }

    @Override
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/psi/impl/source/tree/injected/XmlAttributeLiteralEscaper", "decode"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/psi/impl/source/tree/injected/XmlAttributeLiteralEscaper", "decode"));
        }
        TextRange valueTextRange = this.myXmlAttribute.getValueTextRange();
        int startInDecoded = this.myXmlAttribute.physicalToDisplay(rangeInsideHost.getStartOffset() - valueTextRange.getStartOffset());
        int endInDecoded = this.myXmlAttribute.physicalToDisplay(rangeInsideHost.getEndOffset() - valueTextRange.getStartOffset());
        String displayValue = this.myXmlAttribute.getDisplayValue();
        int n = startInDecoded < 0 ? 0 : (startInDecoded = startInDecoded > displayValue.length() ? displayValue.length() : startInDecoded);
        int n2 = endInDecoded < 0 ? 0 : (endInDecoded = endInDecoded > displayValue.length() ? displayValue.length() : endInDecoded);
        if (startInDecoded > endInDecoded) {
            endInDecoded = startInDecoded;
        }
        outChars.append(displayValue, startInDecoded, endInDecoded);
        return true;
    }

    @Override
    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/psi/impl/source/tree/injected/XmlAttributeLiteralEscaper", "getOffsetInHost"));
        }
        TextRange valueTextRange = this.myXmlAttribute.getValueTextRange();
        int displayStart = this.myXmlAttribute.physicalToDisplay(rangeInsideHost.getStartOffset());
        int dp = this.myXmlAttribute.displayToPhysical(offsetInDecoded + displayStart - valueTextRange.getStartOffset());
        if (dp == -1) {
            return -1;
        }
        return dp + valueTextRange.getStartOffset();
    }

    @Override
    public boolean isOneLine() {
        return true;
    }
}

