/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class FindUsagesHelper {
    protected static boolean processUsagesInText(final @NotNull PsiElement element, @NotNull Collection<String> stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Processor<UsageInfo> processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/FindUsagesHelper", "processUsagesInText"));
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToSearch", "com/intellij/find/findUsages/FindUsagesHelper", "processUsagesInText"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/findUsages/FindUsagesHelper", "processUsagesInText"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/FindUsagesHelper", "processUsagesInText"));
        }
        final TextRange elementTextRange = ApplicationManager.getApplication().runReadAction(new NullableComputable<TextRange>(){

            @Override
            public TextRange compute() {
                if (!element.isValid() || element instanceof PsiCompiledElement) {
                    return null;
                }
                return element.getTextRange();
            }
        });
        UsageInfoFactory factory = new UsageInfoFactory(){

            @Override
            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                if (usage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/find/findUsages/FindUsagesHelper$2", "createUsageInfo"));
                }
                if (elementTextRange != null && usage.getContainingFile() == element.getContainingFile() && elementTextRange.contains(startOffset) && elementTextRange.contains(endOffset)) {
                    return null;
                }
                PsiReference someReference = usage.findReferenceAt(startOffset);
                if (someReference != null) {
                    PsiElement refElement = someReference.getElement();
                    for (PsiReference ref : PsiReferenceService.getService().getReferences(refElement, new PsiReferenceService.Hints(element, null))) {
                        if (!element.getManager().areElementsEquivalent(ref.resolve(), element)) continue;
                        TextRange range = ref.getRangeInElement().shiftRight(refElement.getTextRange().getStartOffset() - usage.getTextRange().getStartOffset());
                        return new UsageInfo(usage, range.getStartOffset(), range.getEndOffset(), true);
                    }
                }
                return new UsageInfo(usage, startOffset, endOffset, true);
            }
        };
        for (String s : stringToSearch) {
            if (PsiSearchHelperImpl.processTextOccurrences(element, s, searchScope, processor, factory)) continue;
            return false;
        }
        return true;
    }
}

