/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveCache {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.JavaResolveCache");
    private static final NotNullLazyKey<JavaResolveCache, Project> INSTANCE_KEY = ServiceManager.createLazyKey(JavaResolveCache.class);
    private final ConcurrentMap<PsiExpression, PsiType> myCalculatedTypes = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private final Map<PsiVariable, Object> myVarToConstValueMapPhysical = ContainerUtil.createConcurrentWeakMap();
    private final Map<PsiVariable, Object> myVarToConstValueMapNonPhysical = ContainerUtil.createConcurrentWeakMap();
    private static final Object NULL = Key.create("NULL");

    public static JavaResolveCache getInstance(Project project) {
        return INSTANCE_KEY.getValue(project);
    }

    public JavaResolveCache(@Nullable(value="can be null in com.intellij.core.JavaCoreApplicationEnvironment.JavaCoreApplicationEnvironment") MessageBus messageBus) {
        if (messageBus != null) {
            messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener.Adapter(){

                @Override
                public void beforePsiChanged(boolean isPhysical) {
                    JavaResolveCache.this.clearCaches(isPhysical);
                }
            });
        }
    }

    private void clearCaches(boolean isPhysical) {
        this.myCalculatedTypes.clear();
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.clear();
        }
        this.myVarToConstValueMapNonPhysical.clear();
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<T, PsiType> f) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/psi/impl/source/resolve/JavaResolveCache", "getType"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/psi/impl/source/resolve/JavaResolveCache", "getType"));
        }
        PsiType type = (PsiType)this.myCalculatedTypes.get(expr);
        if (type == null) {
            RecursionGuard.StackStamp dStackStamp = PsiDiamondType.ourDiamondGuard.markStack();
            type = f.fun(expr);
            if (!dStackStamp.mayCacheNow()) {
                return type;
            }
            boolean isOverloadCheck = MethodCandidateInfo.isOverloadCheck();
            if (isOverloadCheck && PsiPolyExpressionUtil.isPolyExpression(expr)) {
                return type;
            }
            if (type == null) {
                type = TypeConversionUtil.NULL_TYPE;
            }
            this.myCalculatedTypes.put(expr, type);
            if (type instanceof PsiClassReferenceType) {
                PsiClassType.ClassResolveResult result = ((PsiClassReferenceType)type).resolveGenerics();
                PsiClass psiClass = result.getElement();
                PsiType psiType = type = psiClass == null ? type : new PsiImmediateClassType(psiClass, result.getSubstitutor(), ((PsiClassReferenceType)type).getLanguageLevel(), type.getAnnotationProvider());
            }
        }
        if (!type.isValid()) {
            if (expr.isValid()) {
                PsiJavaCodeReferenceElement refInside = type instanceof PsiClassReferenceType ? ((PsiClassReferenceType)type).getReference() : null;
                String typeinfo = type + " (" + type.getClass() + ")" + (refInside == null ? "" : "; ref inside: " + refInside + " (" + refInside.getClass() + ") valid:" + refInside.isValid());
                LOG.error("Type is invalid: " + typeinfo + "; expr: '" + expr + "' (" + expr.getClass() + ") is valid");
            } else {
                LOG.error("Expression: '" + expr + "' is invalid, must not be used for getType()");
            }
        }
        return type == TypeConversionUtil.NULL_TYPE ? null : type;
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/impl/source/resolve/JavaResolveCache", "computeConstantValueWithCaching"));
        }
        if (computer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computer", "com/intellij/psi/impl/source/resolve/JavaResolveCache", "computeConstantValueWithCaching"));
        }
        boolean physical = variable.isPhysical();
        Map<PsiVariable, Object> map = physical ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical;
        Object cached = map.get(variable);
        if (cached == NULL) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Object result = computer.execute(variable, visitedVars);
        map.put(variable, result == null ? NULL : result);
        return result;
    }

    public static interface ConstValueComputer {
        public Object execute(@NotNull PsiVariable var1, Set<PsiVariable> var2);
    }
}

