/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaConstValue
extends DfaValue {
    private static final Throwable ourThrowable = new Throwable();
    private final Object myValue;
    @Nullable
    private final PsiVariable myConstant;

    private DfaConstValue(Object value, DfaValueFactory factory, @Nullable PsiVariable constant) {
        super(factory);
        this.myValue = value;
        this.myConstant = constant;
    }

    public String toString() {
        if (this.myValue == null) {
            return "null";
        }
        return this.myValue.toString();
    }

    public Object getValue() {
        return this.myValue;
    }

    @Nullable
    public PsiVariable getConstant() {
        return this.myConstant;
    }

    @Override
    public DfaValue createNegated() {
        if (this == this.myFactory.getConstFactory().getTrue()) {
            return this.myFactory.getConstFactory().getFalse();
        }
        if (this == this.myFactory.getConstFactory().getFalse()) {
            return this.myFactory.getConstFactory().getTrue();
        }
        return DfaUnknownValue.getInstance();
    }

    public static class Factory {
        private final DfaConstValue dfaNull;
        private final DfaConstValue dfaFalse;
        private final DfaConstValue dfaTrue;
        private final DfaConstValue dfaFail;
        private final DfaValueFactory myFactory;
        private final Map<Object, DfaConstValue> myValues = ContainerUtil.newHashMap();

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.dfaNull = new DfaConstValue(null, factory, null);
            this.dfaFalse = new DfaConstValue(Boolean.FALSE, factory, null);
            this.dfaTrue = new DfaConstValue(Boolean.TRUE, factory, null);
            this.dfaFail = new DfaConstValue(ourThrowable, factory, null);
        }

        @Nullable
        public DfaValue create(PsiLiteralExpression expr) {
            PsiType type = expr.getType();
            if (PsiType.NULL.equals(type)) {
                return this.dfaNull;
            }
            Object value = expr.getValue();
            if (value == null) {
                return null;
            }
            return this.createFromValue(value, type, null);
        }

        @Nullable
        public DfaValue create(PsiVariable variable) {
            Object value = variable.computeConstantValue();
            PsiType type = variable.getType();
            if (value == null) {
                Boolean boo = Factory.computeJavaLangBooleanFieldReference(variable);
                if (boo != null) {
                    DfaConstValue unboxed = this.createFromValue(boo, PsiType.BOOLEAN, variable);
                    return this.myFactory.getBoxedFactory().createBoxed(unboxed);
                }
                PsiExpression initializer = variable.getInitializer();
                if (initializer instanceof PsiLiteralExpression && initializer.textMatches("null")) {
                    return this.dfaNull;
                }
                return null;
            }
            return this.createFromValue(value, type, variable);
        }

        @Nullable
        private static Boolean computeJavaLangBooleanFieldReference(PsiVariable variable) {
            if (!(variable instanceof PsiField)) {
                return null;
            }
            PsiClass psiClass = ((PsiField)variable).getContainingClass();
            if (psiClass == null || !"java.lang.Boolean".equals(psiClass.getQualifiedName())) {
                return null;
            }
            String name = variable.getName();
            return "TRUE".equals(name) ? Boolean.TRUE : ("FALSE".equals(name) ? Boolean.FALSE : null);
        }

        @NotNull
        public DfaConstValue createFromValue(Object value, PsiType type, @Nullable PsiVariable constant) {
            DfaConstValue instance;
            if (value == Boolean.TRUE) {
                DfaConstValue dfaConstValue = this.dfaTrue;
                if (dfaConstValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaConstValue$Factory", "createFromValue"));
                }
                return dfaConstValue;
            }
            if (value == Boolean.FALSE) {
                DfaConstValue dfaConstValue = this.dfaFalse;
                if (dfaConstValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaConstValue$Factory", "createFromValue"));
                }
                return dfaConstValue;
            }
            if (TypeConversionUtil.isNumericType(type) && !TypeConversionUtil.isFloatOrDoubleType(type)) {
                value = TypeConversionUtil.computeCastTo(value, PsiType.LONG);
            }
            if (value instanceof Double || value instanceof Float) {
                double doubleValue = ((Number)value).doubleValue();
                if (doubleValue == -0.0) {
                    doubleValue = 0.0;
                }
                value = new Double(doubleValue);
            }
            if ((instance = this.myValues.get(value)) == null) {
                instance = new DfaConstValue(value, this.myFactory, constant);
                this.myValues.put(value, instance);
            }
            DfaConstValue dfaConstValue = instance;
            if (dfaConstValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaConstValue$Factory", "createFromValue"));
            }
            return dfaConstValue;
        }

        public DfaConstValue getContractFail() {
            return this.dfaFail;
        }

        public DfaConstValue getFalse() {
            return this.dfaFalse;
        }

        public DfaConstValue getTrue() {
            return this.dfaTrue;
        }

        public DfaConstValue getNull() {
            return this.dfaNull;
        }
    }
}

