/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalGetWithoutIsPresentInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("optional.get.without.is.present.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/OptionalGetWithoutIsPresentInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(type);
        String string = InspectionGadgetsBundle.message("optional.get.without.is.present.problem.descriptor", aClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/OptionalGetWithoutIsPresentInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OptionalGetWithoutIsPresentVisitor();
    }

    private static boolean isSurroundedByIsPresentGuard(PsiReferenceExpression referenceExpression) {
        PsiElement element = referenceExpression;
        PsiIfStatement ifStatement;
        while ((ifStatement = PsiTreeUtil.getParentOfType(element, PsiIfStatement.class, true, PsiMember.class, PsiLambdaExpression.class)) != null) {
            PsiExpression condition = ifStatement.getCondition();
            if (OptionalGetWithoutIsPresentInspection.isIsPresentCheck(condition, referenceExpression)) {
                return true;
            }
            element = ifStatement;
        }
        return false;
    }

    private static boolean isIsPresentCheck(@Nullable PsiExpression expression, PsiReferenceExpression reference) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"isPresent".equals(name)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement qTarget = referenceExpression.resolve();
            PsiElement target = reference.resolve();
            return qTarget != null && qTarget.equals(target);
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiExpression[] operands;
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                if (!OptionalGetWithoutIsPresentInspection.isIsPresentCheck(operand, reference)) continue;
                return true;
            }
        }
        return false;
    }

    private static class OptionalGetWithoutIsPresentVisitor
    extends BaseInspectionVisitor {
        private OptionalGetWithoutIsPresentVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!("get".equals(name) || "getAsDouble".equals(name) || "getAsInt".equals(name) || "getAsLong".equals(name))) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiType type = qualifier.getType();
            if (!TypeUtils.isOptional(type)) {
                return;
            }
            if (OptionalGetWithoutIsPresentInspection.isSurroundedByIsPresentGuard(referenceExpression)) {
                return;
            }
            this.registerMethodCallError(expression, type);
        }
    }
}

