/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import java.io.IOException;
import java.io.RandomAccessFile;

class RandomAccessFileWithLengthAndSizeTracking
extends RandomAccessFile {
    private static final Logger LOG = Logger.getInstance(RandomAccessFileWithLengthAndSizeTracking.class.getName());
    private static final boolean doAssertions = SystemProperties.getBooleanProperty("idea.do.random.access.wrapper.assertions", false);
    private final String myPath;
    private volatile long mySize = super.length();
    private volatile long myPointer;

    public RandomAccessFileWithLengthAndSizeTracking(String name) throws IOException {
        super(name, "rw");
        this.myPath = name;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Inst:" + this + "," + Thread.currentThread() + "," + this.getClass().getClassLoader());
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Seek:" + this + "," + Thread.currentThread() + "," + pos + "," + this.myPointer + "," + this.mySize);
        }
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        if (this.myPointer == pos) {
            return;
        }
        super.seek(pos);
        this.myPointer = pos;
    }

    @Override
    public long length() throws IOException {
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        return this.mySize;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)});
    }

    private void checkSizeAndPointerAssertions() throws IOException {
        if (this.myPointer != super.getFilePointer()) assert (false);
        if (this.mySize != super.length()) assert (false);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("write:" + this + "," + Thread.currentThread() + "," + len + "," + this.myPointer + "," + this.mySize);
        }
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        long pointer = this.myPointer;
        super.write(b, off, len);
        pointer = pointer == 0L ? super.getFilePointer() : (pointer += (long)len);
        this.myPointer = pointer;
        this.mySize = Math.max(pointer, this.mySize);
        if (LOG.isTraceEnabled()) {
            LOG.trace("after write:" + this + "," + Thread.currentThread() + "," + this.myPointer + "," + this.mySize);
        }
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
    }

    @Override
    public void setLength(long newLength) throws IOException {
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        super.setLength(newLength);
        this.mySize = newLength;
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        if (LOG.isTraceEnabled()) {
            LOG.trace("read:" + this + "," + Thread.currentThread() + "," + len + "," + this.myPointer);
        }
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        if ((read = super.read(b, off, len)) != -1) {
            this.myPointer += (long)read;
        }
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        ++this.myPointer;
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        return read;
    }

    @Override
    public long getFilePointer() throws IOException {
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        return this.myPointer;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int i = super.skipBytes(n);
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Closed:" + this + "," + Thread.currentThread());
        }
        super.close();
    }

    public String toString() {
        return this.myPath + "@" + Integer.toHexString(this.hashCode());
    }
}

