/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimplifyBooleanExpressionFix
extends LocalQuickFixOnPsiElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpression");
    public static final String FAMILY_NAME = QuickFixBundle.message("simplify.boolean.expression.family", new Object[0]);
    private final boolean mySubExpressionValue;

    public SimplifyBooleanExpressionFix(@NotNull PsiExpression subExpression, boolean subExpressionValue) {
        if (subExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subExpression", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "<init>"));
        }
        super(subExpression);
        this.mySubExpressionValue = subExpressionValue;
    }

    @Override
    @NotNull
    public String getText() {
        PsiExpression expression = this.getSubExpression();
        assert (expression != null);
        if (PsiUtil.skipParenthesizedExprUp(expression.getParent()) instanceof PsiIfStatement) {
            String string = this.mySubExpressionValue ? "Unwrap 'if' statement" : "Remove 'if' statement";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "getText"));
            }
            return string;
        }
        String string = QuickFixBundle.message("simplify.boolean.expression.text", expression.getText(), this.mySubExpressionValue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = FAMILY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        PsiExpression expression = this.getSubExpression();
        return super.isAvailable() && expression != null && expression.getManager().isInProject(expression) && !PsiUtil.isAccessedForWriting(expression);
    }

    @Override
    public void invoke(final @NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "invoke"));
        }
        if (!this.isAvailable()) {
            return;
        }
        final PsiExpression expression = this.getSubExpression();
        if (!FileModificationService.getInstance().preparePsiElementForWrite(expression)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                SimplifyBooleanExpressionFix.simplifyExpression(project, expression, SimplifyBooleanExpressionFix.this.mySubExpressionValue);
            }
        });
    }

    public static void simplifyExpression(Project project, PsiExpression subExpression, Boolean subExpressionValue) {
        PsiExpression expression;
        if (subExpressionValue == null) {
            expression = subExpression;
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            PsiExpression constExpression = factory.createExpressionFromText(Boolean.toString(subExpressionValue), subExpression);
            expression = (PsiExpression)subExpression.replace(constExpression);
        }
        while (expression.getParent() instanceof PsiExpression) {
            expression = (PsiExpression)expression.getParent();
        }
        SimplifyBooleanExpressionFix.simplifyExpression(expression);
    }

    public static boolean simplifyIfStatement(PsiExpression expression) throws IncorrectOperationException {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiIfStatement) || ((PsiIfStatement)parent).getCondition() != expression) {
            return false;
        }
        if (!(expression instanceof PsiLiteralExpression) || !PsiType.BOOLEAN.equals(expression.getType())) {
            return false;
        }
        boolean condition = Boolean.parseBoolean(expression.getText());
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        if (condition) {
            SimplifyBooleanExpressionFix.replaceWithStatements(ifStatement, ifStatement.getThenBranch());
        } else {
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                ifStatement.delete();
            } else {
                SimplifyBooleanExpressionFix.replaceWithStatements(ifStatement, elseBranch);
            }
        }
        return true;
    }

    private static void replaceWithStatements(PsiStatement orig, PsiStatement statement) throws IncorrectOperationException {
        if (statement == null) {
            orig.delete();
            return;
        }
        PsiElement parent = orig.getParent();
        if (parent == null) {
            return;
        }
        if (statement instanceof PsiBlockStatement && parent instanceof PsiCodeBlock) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement).getCodeBlock();
            PsiJavaToken lBrace = codeBlock.getLBrace();
            PsiJavaToken rBrace = codeBlock.getRBrace();
            if (lBrace == null || rBrace == null) {
                return;
            }
            PsiElement[] children = codeBlock.getChildren();
            if (children.length > 2) {
                PsiElement added = parent.addRangeBefore(children[1], children[children.length - 2], orig);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(orig.getManager());
                codeStyleManager.reformat(added);
            }
            orig.delete();
        } else {
            orig.replace(statement);
        }
    }

    public static void simplifyExpression(PsiExpression expression) throws IncorrectOperationException {
        PsiElement parent;
        final PsiExpression[] result = new PsiExpression[]{(PsiExpression)expression.copy()};
        final ExpressionVisitor expressionVisitor = new ExpressionVisitor(expression.getManager(), true);
        final IncorrectOperationException[] exception = new IncorrectOperationException[]{null};
        result[0].accept(new JavaRecursiveElementVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                PsiElement[] children;
                for (PsiElement child : children = element.getChildren()) {
                    child.accept(this);
                }
            }

            @Override
            public void visitExpression(PsiExpression expression) {
                super.visitExpression(expression);
                expressionVisitor.clear();
                expression.accept(expressionVisitor);
                if (expressionVisitor.resultExpression != null) {
                    LOG.assertTrue(expressionVisitor.resultExpression.isValid());
                    try {
                        if (expression != result[0]) {
                            expression.replace(expressionVisitor.resultExpression);
                        } else {
                            result[0] = expressionVisitor.resultExpression;
                        }
                    }
                    catch (IncorrectOperationException e) {
                        exception[0] = e;
                    }
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        PsiExpression newExpression = (PsiExpression)expression.replace(result[0]);
        if (newExpression instanceof PsiLiteralExpression && (parent = newExpression.getParent()) instanceof PsiAssertStatement && ((PsiLiteralExpression)newExpression).getValue() == Boolean.TRUE) {
            parent.delete();
            return;
        }
        if (!SimplifyBooleanExpressionFix.simplifyIfStatement(newExpression)) {
            ParenthesesUtils.removeParentheses(newExpression, false);
        }
    }

    public static boolean canBeSimplified(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "canBeSimplified"));
        }
        if (!(expression instanceof PsiConditionalExpression) && !PsiType.BOOLEAN.equals(expression.getType())) {
            return false;
        }
        final ExpressionVisitor expressionVisitor = new ExpressionVisitor(expression.getManager(), false);
        final Ref<Boolean> canBeSimplified = new Ref<Boolean>(Boolean.FALSE);
        expression.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (!((Boolean)canBeSimplified.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitExpression(PsiExpression expression) {
                super.visitExpression(expression);
                expressionVisitor.clear();
                expression.accept(expressionVisitor);
                if (expressionVisitor.canBeSimplifiedFlag) {
                    canBeSimplified.set(Boolean.TRUE);
                }
            }
        });
        return canBeSimplified.get();
    }

    private PsiExpression getSubExpression() {
        PsiElement element = this.getStartElement();
        return element instanceof PsiExpression ? (PsiExpression)element : null;
    }

    public static Boolean getConstBoolean(PsiExpression operand) {
        if (operand == null) {
            return null;
        }
        if ((operand = PsiUtil.deparenthesizeExpression(operand)) == null) {
            return null;
        }
        String text = operand.getText();
        return "true".equals(text) ? Boolean.TRUE : ("false".equals(text) ? Boolean.FALSE : null);
    }

    private static class ExpressionVisitor
    extends JavaElementVisitor {
        private PsiExpression resultExpression;
        private final PsiExpression trueExpression;
        private final PsiExpression falseExpression;
        private final boolean isCreateResult;
        boolean canBeSimplifiedFlag;

        private ExpressionVisitor(PsiManager psiManager, boolean createResult) {
            this.isCreateResult = createResult;
            this.trueExpression = createResult ? ExpressionVisitor.createExpression(psiManager, Boolean.toString(true)) : null;
            this.falseExpression = createResult ? ExpressionVisitor.createExpression(psiManager, Boolean.toString(false)) : null;
        }

        private static PsiExpression createExpression(PsiManager psiManager, @NonNls String text) {
            try {
                return JavaPsiFacade.getInstance(psiManager.getProject()).getElementFactory().createExpressionFromText(text, null);
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
                return null;
            }
        }

        private boolean markAndCheckCreateResult() {
            this.canBeSimplifiedFlag = true;
            return this.isCreateResult;
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            PsiExpression[] operands = expression.getOperands();
            PsiExpression lExpr = operands[0];
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.XOR == tokenType) {
                boolean negate = false;
                ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
                for (PsiExpression operand : operands) {
                    Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(operand);
                    if (constBoolean != null) {
                        this.markAndCheckCreateResult();
                        if (constBoolean != Boolean.TRUE) continue;
                        negate = !negate;
                        continue;
                    }
                    expressions.add(operand);
                }
                if (expressions.isEmpty()) {
                    this.resultExpression = negate ? this.trueExpression : this.falseExpression;
                } else {
                    String simplifiedText = StringUtil.join(expressions, new Function<PsiExpression, String>(){

                        @Override
                        public String fun(PsiExpression expression) {
                            return expression.getText();
                        }
                    }, " ^ ");
                    if (negate) {
                        simplifiedText = expressions.size() > 1 ? "!(" + simplifiedText + ")" : "!" + simplifiedText;
                    }
                    this.resultExpression = JavaPsiFacade.getElementFactory(expression.getProject()).createExpressionFromText(simplifiedText, expression);
                }
            } else {
                for (int i = 1; i < operands.length; ++i) {
                    Boolean l = SimplifyBooleanExpressionFix.getConstBoolean(lExpr);
                    PsiExpression operand = operands[i];
                    Boolean r = SimplifyBooleanExpressionFix.getConstBoolean(operand);
                    if (l != null) {
                        this.simplifyBinary(tokenType, l, operand);
                    } else if (r != null) {
                        this.simplifyBinary(tokenType, r, lExpr);
                    } else {
                        PsiJavaToken javaToken = expression.getTokenBeforeOperand(operand);
                        if (javaToken != null && !PsiTreeUtil.hasErrorElements(operand) && !PsiTreeUtil.hasErrorElements(lExpr)) {
                            try {
                                this.resultExpression = JavaPsiFacade.getElementFactory(expression.getProject()).createExpressionFromText(lExpr.getText() + javaToken.getText() + operand.getText(), expression);
                            }
                            catch (IncorrectOperationException e) {
                                this.resultExpression = null;
                            }
                        } else {
                            this.resultExpression = null;
                        }
                    }
                    if (this.resultExpression == null) continue;
                    lExpr = this.resultExpression;
                }
            }
        }

        private void simplifyBinary(IElementType tokenType, Boolean lConstBoolean, PsiExpression rOperand) {
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            if (JavaTokenType.ANDAND == tokenType || JavaTokenType.AND == tokenType) {
                this.resultExpression = lConstBoolean != false ? rOperand : this.falseExpression;
            } else if (JavaTokenType.OROR == tokenType || JavaTokenType.OR == tokenType) {
                this.resultExpression = lConstBoolean != false ? this.trueExpression : rOperand;
            } else if (JavaTokenType.EQEQ == tokenType) {
                this.simplifyEquation(lConstBoolean, rOperand);
            } else if (JavaTokenType.NE == tokenType) {
                PsiPrefixExpression negatedExpression = ExpressionVisitor.createNegatedExpression(rOperand);
                this.resultExpression = negatedExpression;
                this.visitPrefixExpression(negatedExpression);
                this.simplifyEquation(lConstBoolean, this.resultExpression);
            }
        }

        private void simplifyEquation(Boolean constBoolean, PsiExpression otherOperand) {
            if (constBoolean.booleanValue()) {
                this.resultExpression = otherOperand;
            } else {
                PsiPrefixExpression negated = ExpressionVisitor.createNegatedExpression(otherOperand);
                this.resultExpression = negated;
                this.visitPrefixExpression(negated);
            }
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression) {
            Boolean condition = SimplifyBooleanExpressionFix.getConstBoolean(expression.getCondition());
            if (condition == null) {
                return;
            }
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            this.resultExpression = condition != false ? expression.getThenExpression() : expression.getElseExpression();
        }

        private static PsiPrefixExpression createNegatedExpression(PsiExpression otherOperand) {
            PsiPrefixExpression expression = (PsiPrefixExpression)ExpressionVisitor.createExpression(otherOperand.getManager(), "!(xxx)");
            assert (expression != null);
            PsiExpression operand = expression.getOperand();
            assert (operand != null);
            try {
                operand.replace(otherOperand);
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
            return expression;
        }

        @Override
        public void visitPrefixExpression(PsiPrefixExpression expression) {
            PsiExpression operand = expression.getOperand();
            Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(operand);
            if (constBoolean == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.EXCL == tokenType) {
                if (!this.markAndCheckCreateResult()) {
                    return;
                }
                this.resultExpression = constBoolean != false ? this.falseExpression : this.trueExpression;
            }
        }

        @Override
        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            PsiExpression subExpr = expression.getExpression();
            Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(subExpr);
            if (constBoolean == null) {
                return;
            }
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            this.resultExpression = constBoolean != false ? this.trueExpression : this.falseExpression;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement(expression);
        }

        public void clear() {
            this.resultExpression = null;
        }
    }
}

