/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlSuppressionProvider
extends XmlSuppressionProvider
implements InspectionSuppressor {
    public static final String SUPPRESS_MARK = "suppress";

    @Override
    public boolean isProviderAvailable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/DefaultXmlSuppressionProvider", "isProviderAvailable"));
        }
        return true;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/DefaultXmlSuppressionProvider", "isSuppressedFor"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/codeInspection/DefaultXmlSuppressionProvider", "isSuppressedFor"));
        }
        XmlTag tag = element instanceof XmlFile ? ((XmlFile)element).getRootTag() : PsiTreeUtil.getContextOfType(element, XmlTag.class, false);
        return tag != null && this.findSuppression(tag, inspectionId, element) != null;
    }

    @Override
    public void suppressForFile(@NotNull PsiElement element, @NotNull String inspectionId) {
        PsiElement anchor;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/DefaultXmlSuppressionProvider", "suppressForFile"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/codeInspection/DefaultXmlSuppressionProvider", "suppressForFile"));
        }
        PsiFile file = element.getContainingFile();
        XmlDocument document = ((XmlFile)file).getDocument();
        PsiElement psiElement = anchor = document != null ? document.getRootTag() : file.findElementAt(0);
        assert (anchor != null);
        this.suppress(file, this.findFileSuppression(anchor, null, element), inspectionId, anchor.getTextRange().getStartOffset());
    }

    @Override
    public void suppressForTag(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/DefaultXmlSuppressionProvider", "suppressForTag"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/codeInspection/DefaultXmlSuppressionProvider", "suppressForTag"));
        }
        XmlTag tag = PsiTreeUtil.getParentOfType(element, XmlTag.class);
        assert (tag != null);
        this.suppress(element.getContainingFile(), this.findSuppressionLeaf(tag, null, 0), inspectionId, tag.getTextRange().getStartOffset());
    }

    @Nullable
    protected PsiElement findSuppression(PsiElement anchor, String id, PsiElement originalElement) {
        PsiElement element = this.findSuppressionLeaf(anchor, id, 0);
        if (element != null) {
            return element;
        }
        return this.findFileSuppression(anchor, id, originalElement);
    }

    @Nullable
    protected PsiElement findFileSuppression(PsiElement anchor, String id, PsiElement originalElement) {
        PsiFile file = anchor.getContainingFile();
        if (file instanceof XmlFile) {
            XmlDocument document = ((XmlFile)file).getDocument();
            XmlTag rootTag = document != null ? document.getRootTag() : null;
            PsiElement leaf = rootTag != null ? rootTag.getPrevSibling() : file.findElementAt(0);
            return this.findSuppressionLeaf(leaf, id, 0);
        }
        return null;
    }

    @Nullable
    protected PsiElement findSuppressionLeaf(PsiElement leaf, @Nullable String id, int offset) {
        while (leaf != null && leaf.getTextOffset() >= offset) {
            String text;
            if ((leaf instanceof PsiComment || leaf instanceof XmlProlog || leaf instanceof XmlText) && this.isSuppressedFor(text = leaf.getText(), id)) {
                return leaf;
            }
            if (!((leaf = leaf.getPrevSibling()) instanceof XmlTag)) continue;
            return null;
        }
        return null;
    }

    private boolean isSuppressedFor(@NonNls String text, @Nullable String id) {
        if (!text.contains(this.getPrefix())) {
            return false;
        }
        if (id == null) {
            return true;
        }
        HashSet<String> parts = ContainerUtil.newHashSet(StringUtil.getWordsIn(text));
        return parts.contains(id) || parts.contains("ALL");
    }

    protected void suppress(PsiFile file, PsiElement suppressionElement, String inspectionId, int offset) {
        Project project = file.getProject();
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        Document doc = PsiDocumentManager.getInstance(project).getDocument(file);
        assert (doc != null);
        if (suppressionElement != null) {
            TextRange textRange = suppressionElement.getTextRange();
            String text = suppressionElement.getText();
            String suppressionText = this.getSuppressionText(inspectionId, text);
            doc.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), suppressionText);
        } else {
            String suppressionText = this.getSuppressionText(inspectionId, null);
            doc.insertString(offset, suppressionText);
            CodeStyleManager.getInstance(project).adjustLineIndent(doc, offset + suppressionText.length());
            UndoUtil.markPsiFileForUndo(file);
        }
    }

    protected String getSuppressionText(String inspectionId, @Nullable String originalText) {
        if (originalText == null) {
            return this.getPrefix() + inspectionId + this.getSuffix() + "\n";
        }
        if (inspectionId.equals("ALL")) {
            int pos = originalText.indexOf(this.getPrefix());
            return originalText.substring(0, pos) + this.getPrefix() + inspectionId + this.getSuffix() + "\n";
        }
        return StringUtil.replace(originalText, this.getSuffix(), ", " + inspectionId + this.getSuffix());
    }

    @NonNls
    protected String getPrefix() {
        return "<!--suppress ";
    }

    @NonNls
    protected String getSuffix() {
        return " -->";
    }
}

