/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.ClassesWithAnnotatedMembersSearch;
import com.intellij.psi.search.searches.ScopedQueryExecutor;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.hash.HashSet;
import org.jetbrains.annotations.NotNull;

public class ClassesWithAnnotatedMembersSearcher
extends QueryExecutorBase<PsiClass, ClassesWithAnnotatedMembersSearch.Parameters> {
    @Override
    public void processQuery(@NotNull ClassesWithAnnotatedMembersSearch.Parameters queryParameters, final @NotNull Processor<PsiClass> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/ClassesWithAnnotatedMembersSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/ClassesWithAnnotatedMembersSearcher", "processQuery"));
        }
        SearchScope scope = queryParameters.getScope();
        for (QueryExecutor executor : Extensions.getExtensions(ClassesWithAnnotatedMembersSearch.EP_NAME)) {
            if (!(executor instanceof ScopedQueryExecutor)) continue;
            scope = scope.intersectWith(GlobalSearchScope.notScope(((ScopedQueryExecutor)executor).getScope(queryParameters)));
        }
        final HashSet processed = new HashSet();
        AnnotatedElementsSearch.searchPsiMembers(queryParameters.getAnnotationClass(), scope).forEach(new Processor<PsiMember>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean process(PsiMember member) {
                PsiClass psiClass;
                AccessToken token = ReadAction.start();
                try {
                    psiClass = member instanceof PsiClass ? (PsiClass)member : member.getContainingClass();
                }
                finally {
                    token.finish();
                }
                if (psiClass != null && processed.add(psiClass)) {
                    consumer.process(psiClass);
                }
                return true;
            }
        });
    }
}

