/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStringUtil {
    private XmlStringUtil() {
    }

    @NotNull
    public static String wrapInCDATA(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/xml/util/XmlStringUtil", "wrapInCDATA"));
        }
        StringBuilder sb = new StringBuilder();
        int cur = 0;
        int len = str.length();
        while (cur < len) {
            int next = StringUtil.indexOf((CharSequence)str, "]]>", cur);
            next = next < 0 ? len : next + 1;
            sb.append("<![CDATA[").append(str.subSequence(cur, next)).append("]]>");
            cur = next;
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlStringUtil", "wrapInCDATA"));
        }
        return string;
    }

    public static String escapeString(@Nullable String str) {
        return XmlStringUtil.escapeString(str, false);
    }

    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace) {
        return XmlStringUtil.escapeString(str, escapeWhiteSpace, true);
    }

    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace, boolean convertNoBreakSpace) {
        if (str == null) {
            return null;
        }
        StringBuilder buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    entity = escapeWhiteSpace ? "&#10;" : null;
                    break;
                }
                case '\r': {
                    entity = escapeWhiteSpace ? "&#13;" : null;
                    break;
                }
                case '\t': {
                    entity = escapeWhiteSpace ? "&#9;" : null;
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\u00a0': {
                    entity = convertNoBreakSpace ? "&nbsp;" : null;
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    @NotNull
    public static String wrapInHtml(@NotNull CharSequence result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xml/util/XmlStringUtil", "wrapInHtml"));
        }
        String string = "<html>" + result + "</html>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlStringUtil", "wrapInHtml"));
        }
        return string;
    }

    public static boolean isWrappedInHtml(@NotNull String tooltip) {
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "com/intellij/xml/util/XmlStringUtil", "isWrappedInHtml"));
        }
        return StringUtil.startsWithIgnoreCase(tooltip, "<html>") && StringUtil.endsWithIgnoreCase(tooltip, "</html>");
    }

    @NotNull
    public static String stripHtml(@NotNull String toolTip) {
        if (toolTip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolTip", "com/intellij/xml/util/XmlStringUtil", "stripHtml"));
        }
        toolTip = StringUtil.trimStart(toolTip, "<html>");
        toolTip = StringUtil.trimStart(toolTip, "<body>");
        toolTip = StringUtil.trimEnd(toolTip, "</html>");
        String string = toolTip = StringUtil.trimEnd(toolTip, "</body>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlStringUtil", "stripHtml"));
        }
        return string;
    }

    @NotNull
    public static String convertToHtmlContent(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xml/util/XmlStringUtil", "convertToHtmlContent"));
        }
        String string = XmlStringUtil.isWrappedInHtml(text) ? XmlStringUtil.stripHtml(text) : XmlStringUtil.escapeString(text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlStringUtil", "convertToHtmlContent"));
        }
        return string;
    }
}

