/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.content;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.model.impl.module.content.JpsContentEntry;
import org.jetbrains.annotations.NotNull;

public class JpsContentFolderBase
implements Disposable,
ContentFolder {
    protected final JpsContentEntry myContentEntry;
    protected VirtualFilePointer myFilePointer;

    public JpsContentFolderBase(String url, JpsContentEntry contentEntry) {
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
        this.myContentEntry = contentEntry;
    }

    @Override
    public VirtualFile getFile() {
        return this.myFilePointer.getFile();
    }

    @Override
    @NotNull
    public ContentEntry getContentEntry() {
        JpsContentEntry jpsContentEntry = this.myContentEntry;
        if (jpsContentEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentFolderBase", "getContentEntry"));
        }
        return jpsContentEntry;
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.myFilePointer.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentFolderBase", "getUrl"));
        }
        return string;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public void dispose() {
    }
}

