/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AnonymousClassVariableHidesOuterClassVariableVisitor
extends BaseInspectionVisitor {
    AnonymousClassVariableHidesOuterClassVariableVisitor() {
    }

    @Override
    public void visitAnonymousClass(PsiAnonymousClass aClass) {
        PsiParameter[] parameters;
        super.visitAnonymousClass(aClass);
        PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiCodeBlock.class);
        if (codeBlock == null) {
            return;
        }
        VariableCollector collector = new VariableCollector();
        aClass.acceptChildren(collector);
        PsiStatement[] statements = codeBlock.getStatements();
        int offset = aClass.getTextOffset();
        for (PsiStatement statement : statements) {
            PsiElement[] declaredElements;
            if (statement.getTextOffset() >= offset) break;
            if (!(statement instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                PsiVariable[] variables;
                if (!(declaredElement instanceof PsiLocalVariable)) continue;
                PsiLocalVariable localVariable = (PsiLocalVariable)declaredElement;
                String name = localVariable.getName();
                for (PsiVariable variable : variables = collector.getVariables(name)) {
                    this.registerVariableError(variable, variable);
                }
            }
        }
        Object containingMethod = PsiTreeUtil.getParentOfType((PsiElement)codeBlock, PsiMethod.class, PsiLambdaExpression.class);
        if (containingMethod == null) {
            return;
        }
        PsiParameterList parameterList = containingMethod instanceof PsiMethod ? ((PsiMethod)containingMethod).getParameterList() : ((PsiLambdaExpression)containingMethod).getParameterList();
        for (PsiParameter parameter : parameters = parameterList.getParameters()) {
            PsiVariable[] variables;
            String name = parameter.getName();
            for (PsiVariable variable : variables = collector.getVariables(name)) {
                this.registerVariableError(variable, variable);
            }
        }
    }

    private static class VariableCollector
    extends JavaRecursiveElementWalkingVisitor {
        private static final PsiVariable[] EMPTY_VARIABLE_LIST = new PsiVariable[0];
        private final Map<String, List<PsiVariable>> variableMap = new HashMap<String, List<PsiVariable>>();

        private VariableCollector() {
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            String name = variable.getName();
            List<PsiVariable> variableList = this.variableMap.get(name);
            if (variableList == null) {
                ArrayList<PsiVariable> list = new ArrayList<PsiVariable>();
                list.add(variable);
                this.variableMap.put(name, list);
            } else {
                variableList.add(variable);
            }
        }

        @Override
        public void visitClass(PsiClass aClass) {
        }

        public PsiVariable[] getVariables(String name) {
            List<PsiVariable> variableList = this.variableMap.get(name);
            if (variableList == null) {
                return EMPTY_VARIABLE_LIST;
            }
            return variableList.toArray(new PsiVariable[variableList.size()]);
        }
    }
}

