/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class ParameterNameDiffersFromOverriddenParameterInspectionBase
extends BaseInspection {
    public boolean m_ignoreSingleCharacterNames = false;
    public boolean m_ignoreOverridesOfLibraryMethods = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterNameDiffersFromOverriddenParameterVisitor();
    }

    private class ParameterNameDiffersFromOverriddenParameterVisitor
    extends BaseInspectionVisitor {
        private ParameterNameDiffersFromOverriddenParameterVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspectionBase$ParameterNameDiffersFromOverriddenParameterVisitor", "visitMethod"));
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() == 0) {
                return;
            }
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod == null) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            this.checkParameters(superMethod, parameters);
        }

        private void checkParameters(@NotNull PsiMethod superMethod, PsiParameter[] parameters) {
            PsiClass containingClass;
            if (superMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspectionBase$ParameterNameDiffersFromOverriddenParameterVisitor", "checkParameters"));
            }
            if (ParameterNameDiffersFromOverriddenParameterInspectionBase.this.m_ignoreOverridesOfLibraryMethods && (containingClass = superMethod.getContainingClass()) != null && LibraryUtil.classIsInLibrary(containingClass)) {
                return;
            }
            PsiParameterList superParameterList = superMethod.getParameterList();
            PsiParameter[] superParameters = superParameterList.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                String parameterName = parameter.getName();
                String superParameterName = superParameters[i].getName();
                if (superParameterName == null || superParameterName.equals(parameterName) || ParameterNameDiffersFromOverriddenParameterInspectionBase.this.m_ignoreSingleCharacterNames && superParameterName.length() == 1) continue;
                this.registerVariableError(parameter, superParameterName);
            }
        }
    }
}

