/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfoHolder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder");
    private final PsiFile myContextFile;
    private final HighlightInfoFilter[] myFilters;
    private final AnnotationSession myAnnotationSession;
    private int myErrorCount;
    private final List<HighlightInfo> myInfos;

    public HighlightInfoHolder(@NotNull PsiFile contextFile, HighlightInfoFilter ... filters) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder", "<init>"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder", "<init>"));
        }
        this.myInfos = new ArrayList<HighlightInfo>(5);
        this.myContextFile = contextFile;
        this.myAnnotationSession = new AnnotationSession(contextFile);
        this.myFilters = filters;
    }

    @NotNull
    public AnnotationSession getAnnotationSession() {
        AnnotationSession annotationSession = this.myAnnotationSession;
        if (annotationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder", "getAnnotationSession"));
        }
        return annotationSession;
    }

    public boolean add(@Nullable HighlightInfo info) {
        if (info == null || !this.accepted(info)) {
            return false;
        }
        HighlightSeverity severity = info.getSeverity();
        if (severity == HighlightSeverity.ERROR) {
            ++this.myErrorCount;
        }
        return this.myInfos.add(info);
    }

    public void clear() {
        this.myErrorCount = 0;
        this.myInfos.clear();
    }

    public boolean hasErrorResults() {
        return this.myErrorCount != 0;
    }

    public boolean addAll(Collection<? extends HighlightInfo> highlightInfos) {
        if (highlightInfos == null) {
            return false;
        }
        LOG.assertTrue(highlightInfos != this);
        boolean added = false;
        for (HighlightInfo highlightInfo : highlightInfos) {
            added |= this.add(highlightInfo);
        }
        return added;
    }

    public int size() {
        return this.myInfos.size();
    }

    public HighlightInfo get(int i) {
        return this.myInfos.get(i);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myContextFile.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder", "getProject"));
        }
        return project;
    }

    @NotNull
    public PsiFile getContextFile() {
        PsiFile psiFile = this.myContextFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder", "getContextFile"));
        }
        return psiFile;
    }

    private boolean accepted(@NotNull HighlightInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder", "accepted"));
        }
        for (HighlightInfoFilter filter : this.myFilters) {
            if (filter.accept(info, this.getContextFile())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public TextAttributesScheme getColorsScheme() {
        TextAttributesScheme textAttributesScheme = new TextAttributesScheme(){

            @Override
            public TextAttributes getAttributes(TextAttributesKey key) {
                return key.getDefaultAttributes();
            }
        };
        if (textAttributesScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder", "getColorsScheme"));
        }
        return textAttributesScheme;
    }
}

