/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalExpressionWithIdenticalBranchesInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean myReportOnlyExactlyIdentical;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report only exactly identical branches", this, "myReportOnlyExactlyIdentical");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConditionalExpressionWithIdenticalBranchesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        EquivalenceChecker.Decision decision = (EquivalenceChecker.Decision)infos[1];
        String string = InspectionGadgetsBundle.message(decision.isExact() ? "conditional.expression.with.identical.branches.problem.descriptor" : "conditional.expression.with.similar.branches.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConditionalExpressionWithIdenticalBranchesInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseConditional((PsiConditionalExpression)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionWithIdenticalBranchesVisitor();
    }

    private class ConditionalExpressionWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionWithIdenticalBranchesVisitor() {
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            PsiExpression thenExpression = expression.getThenExpression();
            PsiExpression elseExpression = expression.getElseExpression();
            EquivalenceChecker.Decision decision = EquivalenceChecker.expressionsAreEquivalentDecision(thenExpression, elseExpression);
            if (thenExpression != null && (ConditionalExpressionWithIdenticalBranchesInspection.this.myReportOnlyExactlyIdentical ? decision.getExactlyMatches() : !decision.isExactUnMatches())) {
                this.registerError((PsiElement)expression, expression, decision);
            }
        }
    }

    private static class CollapseConditional
    extends InspectionGadgetsFix {
        private final SmartPsiElementPointer<PsiConditionalExpression> myConditionalExpression;

        public CollapseConditional(PsiConditionalExpression expression) {
            this.myConditionalExpression = SmartPointerManager.getInstance(expression.getProject()).createSmartPsiElementPointer(expression);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message(this.getEquivalenceDecision().getExactlyMatches() ? "conditional.expression.with.identical.branches.collapse.quickfix" : "conditional.expression.with.identical.branches.push.inside.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConditionalExpressionWithIdenticalBranchesInspection$CollapseConditional", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.collapse.quickfix.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConditionalExpressionWithIdenticalBranchesInspection$CollapseConditional", "getFamilyName"));
            }
            return string;
        }

        public PsiConditionalExpression getConditionalExpression() {
            return this.myConditionalExpression.getElement();
        }

        private EquivalenceChecker.Decision getEquivalenceDecision() {
            return EquivalenceChecker.expressionsAreEquivalentDecision(this.getConditionalExpression().getThenExpression(), this.getConditionalExpression().getElseExpression());
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            EquivalenceChecker.Decision decision = this.getEquivalenceDecision();
            PsiConditionalExpression conditionalExpression = this.getConditionalExpression();
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            assert (thenExpression != null);
            if (decision.getExactlyMatches()) {
                PsiConditionalExpression expression = (PsiConditionalExpression)descriptor.getPsiElement();
                String bodyText = thenExpression.getText();
                PsiReplacementUtil.replaceExpression(expression, bodyText);
            } else if (!decision.isExactUnMatches()) {
                PsiElement leftDiff = decision.getLeftDiff();
                PsiElement rightDiff = decision.getRightDiff();
                String expression = "(" + conditionalExpression.getCondition().getText() + " ? " + leftDiff.getText() + " : " + rightDiff.getText() + ")";
                PsiExpression newConditionalExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText(expression, conditionalExpression);
                PsiElement replacedConditionalExpression = leftDiff.replace(newConditionalExpression);
                ParenthesesUtils.removeParentheses((PsiExpression)replacedConditionalExpression, false);
                conditionalExpression.replace(thenExpression);
            }
        }
    }
}

