/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.CustomHighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.concurrency.JobScheduler;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralHighlightingPass
extends ProgressableTextEditorHighlightingPass
implements DumbAware {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass");
    private static final String PRESENTABLE_NAME = DaemonBundle.message("pass.syntax", new Object[0]);
    private static final Key<Boolean> HAS_ERROR_ELEMENT = Key.create("HAS_ERROR_ELEMENT");
    static final Condition<PsiFile> SHOULD_HIGHLIGHT_FILTER = new Condition<PsiFile>(){

        @Override
        public boolean value(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass$1", "value"));
            }
            return HighlightingLevelManager.getInstance(file.getProject()).shouldHighlight(file);
        }
    };
    private static final Random RESTART_DAEMON_RANDOM = new Random();
    protected final boolean myUpdateAll;
    protected final ProperTextRange myPriorityRange;
    protected final List<HighlightInfo> myHighlights;
    protected volatile boolean myHasErrorElement;
    private volatile boolean myErrorFound;
    protected final EditorColorsScheme myGlobalScheme;
    private volatile NotNullProducer<HighlightVisitor[]> myHighlightVisitorProducer;
    private static final Key<AtomicInteger> HIGHLIGHT_VISITOR_INSTANCE_COUNT = new Key("HIGHLIGHT_VISITOR_INSTANCE_COUNT");
    private static final int POST_UPDATE_ALL = 5;

    public GeneralHighlightingPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Document document, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        super(project, document, PRESENTABLE_NAME, file, editor, TextRange.create(startOffset, endOffset), true, highlightInfoProcessor);
        this.myHighlights = new ArrayList<HighlightInfo>();
        this.myHighlightVisitorProducer = new NotNullProducer<HighlightVisitor[]>(){

            @Override
            @NotNull
            public HighlightVisitor[] produce() {
                HighlightVisitor[] highlightVisitorArray = GeneralHighlightingPass.this.cloneHighlightVisitors();
                if (highlightVisitorArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass$2", "produce"));
                }
                return highlightVisitorArray;
            }
        };
        this.myUpdateAll = updateAll;
        this.myPriorityRange = priorityRange;
        PsiUtilCore.ensureValid(file);
        boolean wholeFileHighlighting = this.isWholeFileHighlighting();
        this.myHasErrorElement = !wholeFileHighlighting && Boolean.TRUE.equals(this.getFile().getUserData(HAS_ERROR_ELEMENT));
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        this.myErrorFound = !wholeFileHighlighting && fileStatusMap.wasErrorFound(this.getDocument());
        this.setProgressLimit(document.getTextLength() / 2);
        this.myGlobalScheme = editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getFile"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = super.getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getDocument"));
        }
        return document;
    }

    @NotNull
    private HighlightVisitor[] cloneHighlightVisitors() {
        int oldCount = this.incVisitorUsageCount(1);
        HighlightVisitor[] highlightVisitors = Extensions.getExtensions(HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)this.myProject);
        if (oldCount != 0) {
            HighlightVisitor[] clones = new HighlightVisitor[highlightVisitors.length];
            for (int i = 0; i < highlightVisitors.length; ++i) {
                HighlightVisitor highlightVisitor = highlightVisitors[i];
                HighlightVisitor cloned = highlightVisitor.clone();
                assert (cloned.getClass() == highlightVisitor.getClass()) : highlightVisitor.getClass() + ".clone() must return a copy of " + highlightVisitor.getClass() + "; but got: " + cloned + " of " + cloned.getClass();
                clones[i] = cloned;
            }
            highlightVisitors = clones;
        }
        if (highlightVisitors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "cloneHighlightVisitors"));
        }
        return highlightVisitors;
    }

    @NotNull
    private HighlightVisitor[] filterVisitors(@NotNull HighlightVisitor[] highlightVisitors, @NotNull PsiFile psiFile) {
        if (highlightVisitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightVisitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "filterVisitors"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "filterVisitors"));
        }
        ArrayList<HighlightVisitor> visitors = new ArrayList<HighlightVisitor>(highlightVisitors.length);
        List<HighlightVisitor> list = Arrays.asList(highlightVisitors);
        for (HighlightVisitor visitor : DumbService.getInstance(this.myProject).filterByDumbAwareness(list)) {
            if (!visitor.suitableForFile(psiFile)) continue;
            visitors.add(visitor);
        }
        if (visitors.isEmpty()) {
            LOG.error("No visitors registered. list=" + list + "; all visitors are:" + Arrays.asList(Extensions.getExtensions(HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)this.myProject)));
        }
        HighlightVisitor[] highlightVisitorArray = visitors.toArray(new HighlightVisitor[visitors.size()]);
        if (highlightVisitorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "filterVisitors"));
        }
        return highlightVisitorArray;
    }

    public void setHighlightVisitorProducer(@NotNull NotNullProducer<HighlightVisitor[]> highlightVisitorProducer) {
        if (highlightVisitorProducer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightVisitorProducer", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "setHighlightVisitorProducer"));
        }
        this.myHighlightVisitorProducer = highlightVisitorProducer;
    }

    @NotNull
    HighlightVisitor[] getHighlightVisitors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getHighlightVisitors"));
        }
        HighlightVisitor[] highlightVisitorArray = this.filterVisitors(this.myHighlightVisitorProducer.produce(), psiFile);
        if (highlightVisitorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getHighlightVisitors"));
        }
        return highlightVisitorArray;
    }

    public int incVisitorUsageCount(int delta) {
        AtomicInteger count = this.myProject.getUserData(HIGHLIGHT_VISITOR_INSTANCE_COUNT);
        if (count == null) {
            count = ((UserDataHolderEx)((Object)this.myProject)).putUserDataIfAbsent(HIGHLIGHT_VISITOR_INSTANCE_COUNT, new AtomicInteger(0));
        }
        int old = count.getAndAdd(delta);
        assert (old + delta >= 0) : old + ";" + delta;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectInformationWithProgress"));
        }
        ArrayList<HighlightInfo> outsideResult = new ArrayList<HighlightInfo>(100);
        ArrayList<HighlightInfo> insideResult = new ArrayList<HighlightInfo>(100);
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        HighlightVisitor[] filteredVisitors = this.getHighlightVisitors(this.getFile());
        ArrayList<PsiElement> insideElements = new ArrayList<PsiElement>();
        ArrayList<PsiElement> outsideElements = new ArrayList<PsiElement>();
        try {
            boolean success;
            ArrayList<ProperTextRange> insideRanges = new ArrayList<ProperTextRange>();
            ArrayList<ProperTextRange> outsideRanges = new ArrayList<ProperTextRange>();
            Divider.divideInsideAndOutside(this.getFile(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myPriorityRange, insideElements, insideRanges, outsideElements, outsideRanges, false, SHOULD_HIGHLIGHT_FILTER);
            if (!insideElements.isEmpty() && insideElements.get(insideElements.size() - 1) instanceof PsiFile && !(insideElements.get(insideElements.size() - 1) instanceof PsiCodeFragment)) {
                PsiElement file = (PsiElement)insideElements.remove(insideElements.size() - 1);
                outsideElements.add(file);
                ProperTextRange range = (ProperTextRange)insideRanges.remove(insideRanges.size() - 1);
                outsideRanges.add(range);
            }
            this.setProgressLimit(insideElements.size() + outsideElements.size());
            boolean forceHighlightParents = this.forceHighlightParents();
            if (!this.isDumbMode()) {
                GeneralHighlightingPass.highlightTodos(this.getFile(), this.getDocument().getCharsSequence(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), progress, this.myPriorityRange, insideResult, outsideResult);
            }
            if (success = this.collectHighlights(insideElements, insideRanges, outsideElements, outsideRanges, progress, filteredVisitors, insideResult, outsideResult, forceHighlightParents)) {
                this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, outsideResult, this.myPriorityRange, this.myRestrictRange, this.getId());
                if (this.myUpdateAll) {
                    daemonCodeAnalyzer.getFileStatusMap().setErrorFoundFlag(this.myProject, this.getDocument(), this.myErrorFound);
                }
            } else {
                GeneralHighlightingPass.cancelAndRestartDaemonLater(progress, this.myProject);
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
            this.myHighlights.addAll(insideResult);
            this.myHighlights.addAll(outsideResult);
        }
    }

    boolean isFailFastOnAcquireReadAction() {
        return true;
    }

    private boolean isWholeFileHighlighting() {
        return this.myUpdateAll && this.myRestrictRange.equalsToRange(0, this.getDocument().getTextLength());
    }

    @Override
    protected void applyInformationWithProgress() {
        this.getFile().putUserData(HAS_ERROR_ELEMENT, this.myHasErrorElement);
        if (this.myUpdateAll) {
            this.reportErrorsToWolf();
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        ArrayList<HighlightInfo> arrayList = new ArrayList<HighlightInfo>(this.myHighlights);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getInfos"));
        }
        return arrayList;
    }

    private boolean collectHighlights(final @NotNull List<PsiElement> elements1, final @NotNull List<ProperTextRange> ranges1, @NotNull List<PsiElement> elements2, @NotNull List<ProperTextRange> ranges2, final @NotNull ProgressIndicator progress, @NotNull HighlightVisitor[] visitors, @NotNull List<HighlightInfo> insideResult, @NotNull List<HighlightInfo> outsideResult, boolean forceHighlightParents) {
        if (elements1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements1", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (ranges1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges1", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (elements2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements2", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (ranges2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges2", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (visitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (insideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (outsideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        THashSet skipParentsSet = new THashSet();
        HighlightInfoHolder holder = this.createInfoHolder(this.getFile());
        final int chunkSize = Math.max(1, (elements1.size() + elements2.size()) / 100);
        boolean success = this.analyzeByVisitors(visitors, holder, 0, new Runnable((Set)skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors, elements2, ranges2){
            final /* synthetic */ Set val$skipParentsSet;
            final /* synthetic */ HighlightInfoHolder val$holder;
            final /* synthetic */ List val$insideResult;
            final /* synthetic */ List val$outsideResult;
            final /* synthetic */ boolean val$forceHighlightParents;
            final /* synthetic */ HighlightVisitor[] val$visitors;
            final /* synthetic */ List val$elements2;
            final /* synthetic */ List val$ranges2;
            {
                this.val$skipParentsSet = set;
                this.val$holder = highlightInfoHolder;
                this.val$insideResult = list3;
                this.val$outsideResult = list4;
                this.val$forceHighlightParents = bl;
                this.val$visitors = highlightVisitorArray;
                this.val$elements2 = list5;
                this.val$ranges2 = list6;
            }

            @Override
            public void run() {
                GeneralHighlightingPass.this.runVisitors(elements1, ranges1, chunkSize, progress, this.val$skipParentsSet, this.val$holder, this.val$insideResult, this.val$outsideResult, this.val$forceHighlightParents, this.val$visitors);
                ProperTextRange priorityIntersection = GeneralHighlightingPass.this.myPriorityRange.intersection(GeneralHighlightingPass.this.myRestrictRange);
                if (!(elements1.isEmpty() && this.val$insideResult.isEmpty() || priorityIntersection == null)) {
                    GeneralHighlightingPass.this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(GeneralHighlightingPass.this.myHighlightingSession, this.val$insideResult, GeneralHighlightingPass.this.myPriorityRange, GeneralHighlightingPass.this.myRestrictRange, GeneralHighlightingPass.this.getId());
                }
                GeneralHighlightingPass.this.runVisitors(this.val$elements2, this.val$ranges2, chunkSize, progress, this.val$skipParentsSet, this.val$holder, this.val$insideResult, this.val$outsideResult, this.val$forceHighlightParents, this.val$visitors);
            }
        });
        ArrayList<HighlightInfo> postInfos = new ArrayList<HighlightInfo>(holder.size());
        for (int j = 0; j < holder.size(); ++j) {
            HighlightInfo info = holder.get(j);
            assert (info != null);
            postInfos.add(info);
        }
        this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, postInfos, this.getFile().getTextRange(), this.getFile().getTextRange(), 5);
        return success;
    }

    private boolean analyzeByVisitors(final @NotNull HighlightVisitor[] visitors, final @NotNull HighlightInfoHolder holder, final int i, final @NotNull Runnable action) {
        if (visitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "analyzeByVisitors"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "analyzeByVisitors"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "analyzeByVisitors"));
        }
        final boolean[] success = new boolean[]{true};
        if (i == visitors.length) {
            action.run();
        } else if (!visitors[i].analyze(this.getFile(), this.myUpdateAll, holder, new Runnable(){

            @Override
            public void run() {
                success[0] = GeneralHighlightingPass.this.analyzeByVisitors(visitors, holder, i + 1, action);
            }
        })) {
            success[0] = false;
        }
        return success[0];
    }

    private void runVisitors(@NotNull List<PsiElement> elements, @NotNull List<ProperTextRange> ranges, int chunkSize, @NotNull ProgressIndicator progress, @NotNull Set<PsiElement> skipParentsSet, @NotNull HighlightInfoHolder holder, @NotNull List<HighlightInfo> insideResult, @NotNull List<HighlightInfo> outsideResult, boolean forceHighlightParents, @NotNull HighlightVisitor[] visitors) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (skipParentsSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipParentsSet", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (insideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (outsideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (visitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        Stack<TextRange> nestedRange = new Stack<TextRange>();
        Stack<ArrayList<HighlightInfo>> nestedInfos = new Stack<ArrayList<HighlightInfo>>();
        boolean failed = false;
        int nextLimit = chunkSize;
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            progress.checkCanceled();
            PsiElement parent = element.getParent();
            if (element != this.getFile() && !skipParentsSet.isEmpty() && element.getFirstChild() != null && skipParentsSet.contains(element)) {
                skipParentsSet.add(parent);
                continue;
            }
            boolean isErrorElement = element instanceof PsiErrorElement;
            if (isErrorElement) {
                this.myHasErrorElement = true;
            }
            for (HighlightVisitor visitor : visitors) {
                try {
                    visitor.visit(element);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!failed) {
                        LOG.error(e);
                    }
                    failed = true;
                }
            }
            if (i == nextLimit) {
                this.advanceProgress(chunkSize);
                nextLimit = i + chunkSize;
            }
            TextRange elementRange = ranges.get(i);
            List<HighlightInfo> infosForThisRange = holder.size() == 0 ? null : new ArrayList<HighlightInfo>(holder.size());
            for (int j = 0; j < holder.size(); ++j) {
                boolean isError;
                List<HighlightInfo> result;
                HighlightInfo info = holder.get(j);
                if (!this.myRestrictRange.containsRange(info.getStartOffset(), info.getEndOffset())) continue;
                List<HighlightInfo> list = result = this.myPriorityRange.containsRange(info.getStartOffset(), info.getEndOffset()) && !(element instanceof PsiFile) ? insideResult : outsideResult;
                if (!result.add(info)) continue;
                boolean bl = isError = info.getSeverity() == HighlightSeverity.ERROR;
                if (isError) {
                    if (!forceHighlightParents) {
                        skipParentsSet.add(parent);
                    }
                    this.myErrorFound = true;
                }
                info.setBijective(elementRange.equalsToRange(info.startOffset, info.endOffset) || isErrorElement);
                this.myHighlightInfoProcessor.infoIsAvailable(this.myHighlightingSession, info, this.myPriorityRange, this.myRestrictRange, 4);
                infosForThisRange.add(info);
            }
            holder.clear();
            while (!nestedRange.isEmpty() && elementRange.contains((TextRange)nestedRange.peek())) {
                TextRange oldRange = (TextRange)nestedRange.pop();
                List oldInfos = (List)nestedInfos.pop();
                if (!elementRange.equals(oldRange)) continue;
                if (infosForThisRange == null) {
                    infosForThisRange = oldInfos;
                    continue;
                }
                if (oldInfos == null) continue;
                infosForThisRange.addAll(oldInfos);
            }
            nestedRange.push(elementRange);
            nestedInfos.push((ArrayList<HighlightInfo>)infosForThisRange);
            if (parent != null && (i == ranges.size() - 1 || elementRange.equals(ranges.get(i + 1))) && Comparing.equal(elementRange, parent.getTextRange())) continue;
            this.myHighlightInfoProcessor.allHighlightsForRangeAreProduced(this.myHighlightingSession, elementRange, infosForThisRange);
        }
        this.advanceProgress(elements.size() - (nextLimit - chunkSize));
    }

    private static void cancelAndRestartDaemonLater(@NotNull ProgressIndicator progress, final @NotNull Project project) throws ProcessCanceledException {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "cancelAndRestartDaemonLater"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "cancelAndRestartDaemonLater"));
        }
        progress.cancel();
        JobScheduler.getScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                Application application = ApplicationManager.getApplication();
                if (!(project.isDisposed() || application.isDisposed() || application.isUnitTestMode())) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DaemonCodeAnalyzer.getInstance(project).restart();
                        }
                    }, project.getDisposed());
                }
            }
        }, (long)RESTART_DAEMON_RANDOM.nextInt(100), TimeUnit.MILLISECONDS);
        throw new ProcessCanceledException();
    }

    private boolean forceHighlightParents() {
        boolean forceHighlightParents = false;
        for (HighlightRangeExtension extension : Extensions.getExtensions(HighlightRangeExtension.EP_NAME)) {
            if (!extension.isForceHighlightParents(this.getFile())) continue;
            forceHighlightParents = true;
            break;
        }
        return forceHighlightParents;
    }

    protected HighlightInfoHolder createInfoHolder(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "createInfoHolder"));
        }
        HighlightInfoFilter[] filters = HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions();
        return new CustomHighlightInfoHolder(file, this.getColorsScheme(), filters);
    }

    static void highlightTodos(@NotNull PsiFile file, @NotNull CharSequence text, int startOffset, int endOffset, @NotNull ProgressIndicator progress, @NotNull ProperTextRange priorityRange, @NotNull Collection<HighlightInfo> insideResult, @NotNull Collection<HighlightInfo> outsideResult) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (insideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (outsideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        PsiTodoSearchHelper helper = PsiTodoSearchHelper.SERVICE.getInstance(file.getProject());
        if (helper == null) {
            return;
        }
        TodoItem[] todoItems = helper.findTodoItems(file, startOffset, endOffset);
        if (todoItems.length == 0) {
            return;
        }
        for (TodoItem todoItem : todoItems) {
            progress.checkCanceled();
            TextRange range = todoItem.getTextRange();
            String description = text.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
            TextAttributes attributes = todoItem.getPattern().getAttributes().getTextAttributes();
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.TODO).range(range);
            builder.textAttributes(attributes);
            builder.descriptionAndTooltip(description);
            HighlightInfo info = builder.createUnconditionally();
            (priorityRange.containsRange(info.getStartOffset(), info.getEndOffset()) ? insideResult : outsideResult).add(info);
        }
    }

    private void reportErrorsToWolf() {
        if (!this.getFile().getViewProvider().isPhysical()) {
            return;
        }
        Project project = this.getFile().getProject();
        if (!PsiManager.getInstance(project).isInProject(this.getFile())) {
            return;
        }
        VirtualFile file = this.getFile().getVirtualFile();
        if (file == null) {
            return;
        }
        List<Problem> problems = GeneralHighlightingPass.convertToProblems(this.getInfos(), file, this.myHasErrorElement);
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance(project);
        boolean hasErrors = DaemonCodeAnalyzerEx.hasErrors(project, this.getDocument());
        if (!hasErrors || this.isWholeFileHighlighting()) {
            wolf.reportProblems(file, problems);
        } else {
            wolf.weHaveGotProblems(file, problems);
        }
    }

    @Override
    public double getProgress() {
        return this.myUpdateAll ? super.getProgress() : -1.0;
    }

    private static List<Problem> convertToProblems(@NotNull Collection<HighlightInfo> infos, @NotNull VirtualFile file, boolean hasErrorElement) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "convertToProblems"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "convertToProblems"));
        }
        SmartList<Problem> problems = new SmartList<Problem>();
        for (HighlightInfo info : infos) {
            if (info.getSeverity() != HighlightSeverity.ERROR) continue;
            ProblemImpl problem = new ProblemImpl(file, info, hasErrorElement);
            problems.add(problem);
        }
        return problems;
    }

    @Override
    public String toString() {
        return super.toString() + " updateAll=" + this.myUpdateAll + " range= " + this.myRestrictRange;
    }
}

