/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ModulesOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectOrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@State(name="ProjectRootManager")
public class ProjectRootManagerImpl
extends ProjectRootManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.projectRoots.impl.ProjectRootManagerImpl");
    @NonNls
    public static final String PROJECT_JDK_NAME_ATTR = "project-jdk-name";
    @NonNls
    public static final String PROJECT_JDK_TYPE_ATTR = "project-jdk-type";
    protected final Project myProject;
    private final EventDispatcher<ProjectRootManagerEx.ProjectJdkListener> myProjectJdkEventDispatcher = EventDispatcher.create(ProjectRootManagerEx.ProjectJdkListener.class);
    private String myProjectSdkName;
    private String myProjectSdkType;
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    private final OrderRootsCache myRootsCache;
    protected boolean myStartupActivityPerformed;
    private final RootProviderChangeListener myRootProviderChangeListener = new RootProviderChangeListener();
    protected final BatchSession myRootsChanged = new BatchSession(false);
    protected final BatchSession myFileTypesChanged = new BatchSession(true);
    private boolean myMergedCallStarted;
    private boolean myMergedCallHasRootChange;
    private int myRootsChangesDepth;
    protected boolean isFiringEvent;
    private final Object myLibraryTableListenersLock = new Object();
    private final Map<LibraryTable, LibraryTableMultiListener> myLibraryTableMultiListeners = new HashMap<LibraryTable, LibraryTableMultiListener>();
    private final JdkTableMultiListener myJdkTableMultiListener;
    private final Map<RootProvider, Set<OrderEntry>> myRegisteredRootProviders = new HashMap<RootProvider, Set<OrderEntry>>();

    public static ProjectRootManagerImpl getInstanceImpl(Project project) {
        return (ProjectRootManagerImpl)ProjectRootManagerImpl.getInstance(project);
    }

    public ProjectRootManagerImpl(Project project) {
        this.myProject = project;
        this.myRootsCache = new OrderRootsCache(project);
        this.myJdkTableMultiListener = new JdkTableMultiListener(project);
    }

    @Override
    @NotNull
    public ProjectFileIndex getFileIndex() {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(this.myProject);
        if (projectFileIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getFileIndex"));
        }
        return projectFileIndex;
    }

    @Override
    @NotNull
    public List<String> getContentRootUrls() {
        ArrayList<String> result = new ArrayList<String>();
        for (Module module : this.getModuleManager().getModules()) {
            String[] urls = ModuleRootManager.getInstance(module).getContentRootUrls();
            ContainerUtil.addAll(result, urls);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getContentRootUrls"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public VirtualFile[] getContentRoots() {
        ArrayList result = new ArrayList();
        for (Module module : this.getModuleManager().getModules()) {
            VirtualFile[] contentRoots = ModuleRootManager.getInstance(module).getContentRoots();
            ContainerUtil.addAll(result, contentRoots);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getContentRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getContentSourceRoots() {
        ArrayList result = new ArrayList();
        for (Module module : this.getModuleManager().getModules()) {
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance(module).getSourceRoots();
            ContainerUtil.addAll(result, sourceRoots);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getContentSourceRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public List<VirtualFile> getModuleSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypes", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getModuleSourceRoots"));
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (Module module : this.getModuleManager().getModules()) {
            roots.addAll(ModuleRootManager.getInstance(module).getSourceRoots(rootTypes));
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getModuleSourceRoots"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public OrderEnumerator orderEntries() {
        ProjectOrderEnumerator projectOrderEnumerator = new ProjectOrderEnumerator(this.myProject, this.myRootsCache);
        if (projectOrderEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "orderEntries"));
        }
        return projectOrderEnumerator;
    }

    @Override
    @NotNull
    public OrderEnumerator orderEntries(@NotNull Collection<? extends Module> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "orderEntries"));
        }
        ModulesOrderEnumerator modulesOrderEnumerator = new ModulesOrderEnumerator(modules);
        if (modulesOrderEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "orderEntries"));
        }
        return modulesOrderEnumerator;
    }

    @Override
    public VirtualFile[] getContentRootsFromAllModules() {
        Module[] modules;
        ArrayList result = new ArrayList();
        for (Module module : modules = this.getModuleManager().getSortedModules()) {
            VirtualFile[] files = ModuleRootManager.getInstance(module).getContentRoots();
            ContainerUtil.addAll(result, files);
        }
        ContainerUtil.addIfNotNull(this.myProject.getBaseDir(), result);
        return VfsUtilCore.toVirtualFileArray(result);
    }

    @Override
    public Sdk getProjectSdk() {
        return this.myProjectSdkName == null ? null : ProjectJdkTable.getInstance().findJdk(this.myProjectSdkName, this.myProjectSdkType);
    }

    @Override
    public String getProjectSdkName() {
        return this.myProjectSdkName;
    }

    @Override
    public void setProjectSdk(Sdk sdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (sdk == null) {
            this.myProjectSdkName = null;
            this.myProjectSdkType = null;
        } else {
            this.myProjectSdkName = sdk.getName();
            this.myProjectSdkType = sdk.getSdkType().getName();
        }
        this.projectJdkChanged();
    }

    private void projectJdkChanged() {
        this.mergeRootsChangesDuring(new Runnable(){

            @Override
            public void run() {
                ((ProjectRootManagerEx.ProjectJdkListener)ProjectRootManagerImpl.this.myProjectJdkEventDispatcher.getMulticaster()).projectJdkChanged();
            }
        });
        Sdk sdk = this.getProjectSdk();
        for (ProjectExtension extension : Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.projectSdkChanged(sdk);
        }
    }

    @Override
    public void setProjectSdkName(String name) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myProjectSdkName = name;
        this.projectJdkChanged();
    }

    @Override
    public void addProjectJdkListener(ProjectRootManagerEx.ProjectJdkListener listener) {
        this.myProjectJdkEventDispatcher.addListener(listener);
    }

    @Override
    public void removeProjectJdkListener(ProjectRootManagerEx.ProjectJdkListener listener) {
        this.myProjectJdkEventDispatcher.removeListener(listener);
    }

    @Override
    public void loadState(Element element) {
        for (ProjectExtension extension : Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.readExternal(element);
        }
        this.myProjectSdkName = element.getAttributeValue(PROJECT_JDK_NAME_ATTR);
        this.myProjectSdkType = element.getAttributeValue(PROJECT_JDK_TYPE_ATTR);
    }

    @Override
    @Nullable
    public Element getState() {
        Element element = new Element("state");
        element.setAttribute(ATTRIBUTE_VERSION, "2");
        for (ProjectExtension extension : Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.writeExternal(element);
        }
        if (this.myProjectSdkName != null) {
            element.setAttribute(PROJECT_JDK_NAME_ATTR, this.myProjectSdkName);
        }
        if (this.myProjectSdkType != null) {
            element.setAttribute(PROJECT_JDK_TYPE_ATTR, this.myProjectSdkType);
        }
        if (element.getAttributes().size() == 1) {
            element.removeAttribute(ATTRIBUTE_VERSION);
        }
        return element;
    }

    @Override
    public void mergeRootsChangesDuring(@NotNull Runnable runnable) {
        block7: {
            block6: {
                block5: {
                    if (runnable == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "mergeRootsChangesDuring"));
                    }
                    if (this.getBatchSession(false).myBatchLevel != 0 || this.myMergedCallStarted) break block6;
                    if (this.myRootsChangesDepth != 0) {
                        int depth = this.myRootsChangesDepth;
                        this.myRootsChangesDepth = 0;
                        LOG.error("Merged rootsChanged not allowed inside rootsChanged, rootsChanged level == " + depth);
                    }
                    this.myMergedCallStarted = true;
                    this.myMergedCallHasRootChange = false;
                    try {
                        runnable.run();
                        if (!this.myMergedCallHasRootChange) break block5;
                        LOG.assertTrue(this.myRootsChangesDepth == 1, "myMergedCallDepth = " + this.myRootsChangesDepth);
                    }
                    catch (Throwable throwable) {
                        if (this.myMergedCallHasRootChange) {
                            LOG.assertTrue(this.myRootsChangesDepth == 1, "myMergedCallDepth = " + this.myRootsChangesDepth);
                            this.getBatchSession(false).rootsChanged();
                        }
                        this.myMergedCallStarted = false;
                        this.myMergedCallHasRootChange = false;
                        throw throwable;
                    }
                    this.getBatchSession(false).rootsChanged();
                }
                this.myMergedCallStarted = false;
                this.myMergedCallHasRootChange = false;
                break block7;
            }
            runnable.run();
        }
    }

    protected void clearScopesCaches() {
        this.clearScopesCachesForModules();
    }

    @Override
    public void clearScopesCachesForModules() {
        Module[] modules;
        this.myRootsCache.clearCache();
        for (Module module : modules = ModuleManager.getInstance(this.myProject).getModules()) {
            ((ModuleRootManagerImpl)ModuleRootManager.getInstance(module)).dropCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeRootsChange(@NotNull Runnable runnable, boolean fileTypes, boolean fireEvents) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "makeRootsChange"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        BatchSession session = this.getBatchSession(fileTypes);
        if (fireEvents) {
            session.beforeRootsChanged();
        }
        try {
            runnable.run();
        }
        finally {
            if (fireEvents) {
                session.rootsChanged();
            }
        }
    }

    protected BatchSession getBatchSession(boolean fileTypes) {
        return fileTypes ? this.myFileTypesChanged : this.myRootsChanged;
    }

    private boolean fireBeforeRootsChanged(boolean fileTypes) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, "Do not use API that changes roots from roots events. Try using invoke later or something else.");
        if (this.myMergedCallStarted) {
            LOG.assertTrue(!fileTypes, "File types change is not supported inside merged call");
        }
        if (this.myRootsChangesDepth++ == 0) {
            if (this.myMergedCallStarted) {
                this.myMergedCallHasRootChange = true;
                ++this.myRootsChangesDepth;
            }
            this.fireBeforeRootsChangeEvent(fileTypes);
            return true;
        }
        return false;
    }

    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
    }

    private boolean fireRootsChanged(boolean fileTypes) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, "Do not use API that changes roots from roots events. Try using invoke later or something else.");
        if (this.myMergedCallStarted) {
            LOG.assertTrue(!fileTypes, "File types change is not supported inside merged call");
        }
        --this.myRootsChangesDepth;
        if (this.myRootsChangesDepth > 0) {
            return false;
        }
        if (this.myRootsChangesDepth < 0) {
            LOG.info("Restoring from roots change start/finish mismatch: ", new Throwable());
            this.myRootsChangesDepth = 0;
        }
        this.clearScopesCaches();
        this.incModificationCount();
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        psiManager.dropResolveCaches();
        ((PsiModificationTrackerImpl)psiManager.getModificationTracker()).incCounter();
        this.fireRootsChangedEvent(fileTypes);
        this.doSynchronizeRoots();
        this.addRootsToWatch();
        return true;
    }

    protected void fireRootsChangedEvent(boolean fileTypes) {
    }

    protected void addRootsToWatch() {
    }

    public Project getProject() {
        return this.myProject;
    }

    protected void doSynchronizeRoots() {
    }

    public static String extractLocalPath(String url) {
        String path = VfsUtilCore.urlToPath(url);
        int jarSeparatorIndex = path.indexOf("!/");
        if (jarSeparatorIndex > 0) {
            return path.substring(0, jarSeparatorIndex);
        }
        return path;
    }

    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance(this.myProject);
    }

    void subscribeToRootProvider(OrderEntry owner, RootProvider provider) {
        Set<OrderEntry> owners = this.myRegisteredRootProviders.get(provider);
        if (owners == null) {
            owners = new HashSet<OrderEntry>();
            this.myRegisteredRootProviders.put(provider, owners);
            provider.addRootSetChangedListener(this.myRootProviderChangeListener);
        }
        owners.add(owner);
    }

    void unsubscribeFromRootProvider(OrderEntry owner, RootProvider provider) {
        Set<OrderEntry> owners = this.myRegisteredRootProviders.get(provider);
        if (owners != null) {
            owners.remove(owner);
            if (owners.isEmpty()) {
                provider.removeRootSetChangedListener(this.myRootProviderChangeListener);
                this.myRegisteredRootProviders.remove(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListenerForTable(LibraryTable.Listener libraryListener, LibraryTable libraryTable) {
        Object object = this.myLibraryTableListenersLock;
        synchronized (object) {
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener == null) {
                multiListener = new LibraryTableMultiListener();
                libraryTable.addListener(multiListener);
                this.myLibraryTableMultiListeners.put(libraryTable, multiListener);
            }
            multiListener.addListener(libraryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListenerForTable(LibraryTable.Listener libraryListener, LibraryTable libraryTable) {
        Object object = this.myLibraryTableListenersLock;
        synchronized (object) {
            boolean last;
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener != null && (last = multiListener.removeListener(libraryListener))) {
                libraryTable.removeListener(multiListener);
                this.myLibraryTableMultiListeners.remove(libraryTable);
            }
        }
    }

    void addJdkTableListener(ProjectJdkTable.Listener jdkTableListener) {
        this.myJdkTableMultiListener.addListener(jdkTableListener);
    }

    void removeJdkTableListener(ProjectJdkTable.Listener jdkTableListener) {
        this.myJdkTableMultiListener.removeListener(jdkTableListener);
    }

    private class RootProviderChangeListener
    implements RootProvider.RootSetChangedListener {
        private boolean myInsideRootsChange;

        private RootProviderChangeListener() {
        }

        @Override
        public void rootSetChanged(RootProvider wrapper) {
            if (this.myInsideRootsChange) {
                return;
            }
            this.myInsideRootsChange = true;
            try {
                ProjectRootManagerImpl.this.makeRootsChange(EmptyRunnable.INSTANCE, false, true);
            }
            finally {
                this.myInsideRootsChange = false;
            }
        }
    }

    private class JdkTableMultiListener
    implements ProjectJdkTable.Listener {
        private final Set<ProjectJdkTable.Listener> myListeners = new LinkedHashSet<ProjectJdkTable.Listener>();
        private final MessageBusConnection listenerConnection;
        private ProjectJdkTable.Listener[] myListenersArray;

        private JdkTableMultiListener(Project project) {
            this.listenerConnection = project.getMessageBus().connect();
            this.listenerConnection.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, this);
        }

        private synchronized void addListener(ProjectJdkTable.Listener listener) {
            this.myListeners.add(listener);
            this.myListenersArray = null;
        }

        private synchronized void removeListener(ProjectJdkTable.Listener listener) {
            this.myListeners.remove(listener);
            this.myListenersArray = null;
        }

        private synchronized ProjectJdkTable.Listener[] getListeners() {
            if (this.myListenersArray == null) {
                this.myListenersArray = this.myListeners.toArray(new ProjectJdkTable.Listener[this.myListeners.size()]);
            }
            return this.myListenersArray;
        }

        @Override
        public void jdkAdded(final Sdk jdk) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (ProjectJdkTable.Listener listener : JdkTableMultiListener.this.getListeners()) {
                        listener.jdkAdded(jdk);
                    }
                }
            });
        }

        @Override
        public void jdkRemoved(final Sdk jdk) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (ProjectJdkTable.Listener listener : JdkTableMultiListener.this.getListeners()) {
                        listener.jdkRemoved(jdk);
                    }
                }
            });
        }

        @Override
        public void jdkNameChanged(final Sdk jdk, final String previousName) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (ProjectJdkTable.Listener listener : JdkTableMultiListener.this.getListeners()) {
                        listener.jdkNameChanged(jdk, previousName);
                    }
                }
            });
            String currentName = ProjectRootManagerImpl.this.getProjectSdkName();
            if (previousName != null && previousName.equals(currentName)) {
                ProjectRootManagerImpl.this.myProjectSdkName = jdk.getName();
                ProjectRootManagerImpl.this.myProjectSdkType = jdk.getSdkType().getName();
            }
        }
    }

    private class LibraryTableMultiListener
    implements LibraryTable.Listener {
        private final Set<LibraryTable.Listener> myListeners = new LinkedHashSet<LibraryTable.Listener>();
        private LibraryTable.Listener[] myListenersArray;

        private LibraryTableMultiListener() {
        }

        private synchronized void addListener(LibraryTable.Listener listener) {
            this.myListeners.add(listener);
            this.myListenersArray = null;
        }

        private synchronized boolean removeListener(LibraryTable.Listener listener) {
            this.myListeners.remove(listener);
            this.myListenersArray = null;
            return this.myListeners.isEmpty();
        }

        @Override
        public void afterLibraryAdded(final Library newLibrary) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultiListener.this.getListeners()) {
                        listener.afterLibraryAdded(newLibrary);
                    }
                }
            });
        }

        private synchronized LibraryTable.Listener[] getListeners() {
            if (this.myListenersArray == null) {
                this.myListenersArray = this.myListeners.toArray(new LibraryTable.Listener[this.myListeners.size()]);
            }
            return this.myListenersArray;
        }

        @Override
        public void afterLibraryRenamed(final Library library) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultiListener.this.getListeners()) {
                        listener.afterLibraryRenamed(library);
                    }
                }
            });
        }

        @Override
        public void beforeLibraryRemoved(final Library library) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultiListener.this.getListeners()) {
                        listener.beforeLibraryRemoved(library);
                    }
                }
            });
        }

        @Override
        public void afterLibraryRemoved(final Library library) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultiListener.this.getListeners()) {
                        listener.afterLibraryRemoved(library);
                    }
                }
            });
        }
    }

    protected class BatchSession {
        private int myBatchLevel;
        private boolean myChanged;
        private final boolean myFileTypes;

        private BatchSession(boolean fileTypes) {
            this.myFileTypes = fileTypes;
        }

        protected void levelUp() {
            if (this.myBatchLevel == 0) {
                this.myChanged = false;
            }
            ++this.myBatchLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void levelDown() {
            --this.myBatchLevel;
            if (this.myChanged && this.myBatchLevel == 0) {
                AccessToken token = WriteAction.start();
                try {
                    this.fireChange();
                }
                finally {
                    try {
                        this.myChanged = false;
                    }
                    finally {
                        token.finish();
                    }
                }
            }
        }

        private boolean fireChange() {
            return ProjectRootManagerImpl.this.fireRootsChanged(this.myFileTypes);
        }

        protected void beforeRootsChanged() {
            if ((this.myBatchLevel == 0 || !this.myChanged) && ProjectRootManagerImpl.this.fireBeforeRootsChanged(this.myFileTypes)) {
                this.myChanged = true;
            }
        }

        protected void rootsChanged() {
            if (this.myBatchLevel == 0 && this.fireChange()) {
                this.myChanged = false;
            }
        }
    }
}

