/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.StringFactory;
import java.util.ArrayList;

public class CharTrie {
    private ArrayList<Node> myAllNodes;

    public CharTrie() {
        this.init();
    }

    private void init() {
        this.myAllNodes = new ArrayList();
        Node root = new Node(-1, '\u0000');
        this.myAllNodes.add(root);
    }

    public int size() {
        return this.myAllNodes.size();
    }

    public String getReversedString(int hashCode) {
        return StringFactory.createShared(this.getReversedChars(hashCode));
    }

    public String getString(int hashCode) {
        return StringFactory.createShared(this.getChars(hashCode));
    }

    public int getHashCode(char[] chars) {
        return this.getHashCode(chars, 0, chars.length);
    }

    public int getHashCode(char[] chars, int offset, int length) {
        int index = 0;
        for (int i = offset; i < offset + length; ++i) {
            index = this.getSubNode(index, chars[i], true);
        }
        return index;
    }

    public int getHashCode(CharSequence seq) {
        int index = 0;
        int l = seq.length();
        for (int i = 0; i < l; ++i) {
            index = this.getSubNode(index, seq.charAt(i), true);
        }
        return index;
    }

    public long getMaximumMatch(CharSequence seq, int offset, int length) {
        int nextIndex;
        int index = 0;
        int resultingLength = 0;
        while (length-- > 0 && (nextIndex = this.findSubNode(index, seq.charAt(offset++))) != 0) {
            index = nextIndex;
            ++resultingLength;
        }
        return (long)index + ((long)resultingLength << 32);
    }

    public char[] getChars(int hashCode) {
        int length = 0;
        int run = hashCode;
        while (run > 0) {
            Node node = this.myAllNodes.get(run);
            ++length;
            run = node.myParent;
        }
        char[] result = new char[length];
        run = hashCode;
        for (int i = 0; i < length; ++i) {
            assert (run > 0);
            Node node = this.myAllNodes.get(run);
            result[length - i - 1] = node.myChar;
            run = node.myParent;
        }
        return result;
    }

    public int getHashCodeForReversedChars(char[] chars) {
        return this.getHashCodeForReversedChars(chars, chars.length - 1, chars.length);
    }

    public int getHashCodeForReversedChars(char[] chars, int offset, int length) {
        int index = 0;
        while (length-- > 0) {
            index = this.getSubNode(index, chars[offset--], true);
        }
        return index;
    }

    public char[] getReversedChars(int hashCode) {
        int length = 0;
        int run = hashCode;
        while (run > 0) {
            Node node = this.myAllNodes.get(run);
            ++length;
            run = node.myParent;
        }
        char[] result = new char[length];
        run = hashCode;
        for (int i = 0; i < length; ++i) {
            assert (run > 0);
            Node node = this.myAllNodes.get(run);
            result[i] = node.myChar;
            run = node.myParent;
        }
        return result;
    }

    public int findSubNode(int parentIndex, char c) {
        return this.getSubNode(parentIndex, c, false);
    }

    private int getSubNode(int parentIndex, char c, boolean createIfNotExists) {
        Node parentNode = this.myAllNodes.get(parentIndex);
        if (parentNode.myChildren == null) {
            if (!createIfNotExists) {
                return 0;
            }
            parentNode.myChildren = new IntArrayList(1);
        }
        IntArrayList children = parentNode.myChildren;
        int left = 0;
        int right = children.size() - 1;
        while (left <= right) {
            int middle = left + right >> 1;
            int index = children.get(middle);
            Node node = this.myAllNodes.get(index);
            int comp = node.myChar - c;
            if (comp == 0) {
                return index;
            }
            if (comp < 0) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        if (!createIfNotExists) {
            return 0;
        }
        int index = this.myAllNodes.size();
        children.add(left, index);
        this.myAllNodes.add(new Node(parentIndex, c));
        return index;
    }

    public void clear() {
        this.init();
    }

    private static class Node {
        private final char myChar;
        private final int myParent;
        private IntArrayList myChildren;

        Node(int parent, char c) {
            this.myChar = c;
            this.myParent = parent;
        }
    }
}

