/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IElementType {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.tree.IElementType");
    public static final IElementType[] EMPTY_ARRAY = new IElementType[0];
    public static final Predicate TRUE = new Predicate(){

        @Override
        public boolean matches(@NotNull IElementType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/tree/IElementType$1", "matches"));
            }
            return true;
        }
    };
    public static final short FIRST_TOKEN_INDEX = 1;
    private static final short MAX_INDEXED_TYPES = 15000;
    private static short size;
    private static volatile IElementType[] ourRegistry;
    private static final Object lock;
    private final short myIndex;
    @NotNull
    private final String myDebugName;
    @NotNull
    private final Language myLanguage;
    private static final ArrayFactory<IElementType> FACTORY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IElementType[] push(@NotNull IElementType[] types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/tree/IElementType", "push"));
        }
        Object object = lock;
        synchronized (object) {
            IElementType[] oldRegistry = ourRegistry;
            ourRegistry = types;
            size = (short)ContainerUtil.skipNulls(Arrays.asList(ourRegistry)).size();
            return oldRegistry;
        }
    }

    public IElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/psi/tree/IElementType", "<init>"));
        }
        this(debugName, language, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IElementType(@NotNull @NonNls String debugName, @Nullable Language language, boolean register) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/psi/tree/IElementType", "<init>"));
        }
        this.myDebugName = debugName;
        Language language2 = this.myLanguage = language == null ? Language.ANY : language;
        if (register) {
            Object object = lock;
            synchronized (object) {
                short s = size;
                size = (short)(s + 1);
                this.myIndex = s;
                LOG.assertTrue(this.myIndex < 15000, "Too many element types registered. Out of (short) range.");
                IElementType[] newRegistry = this.myIndex >= ourRegistry.length ? ArrayUtil.realloc(ourRegistry, ourRegistry.length * 3 / 2 + 1, FACTORY) : ourRegistry;
                newRegistry[this.myIndex] = this;
                ourRegistry = newRegistry;
            }
        } else {
            this.myIndex = (short)-1;
        }
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/IElementType", "getLanguage"));
        }
        return language;
    }

    public final short getIndex() {
        return this.myIndex;
    }

    public int hashCode() {
        return this.myIndex;
    }

    public String toString() {
        return this.myDebugName;
    }

    public boolean isLeftBound() {
        return false;
    }

    public static IElementType find(short idx) {
        return ourRegistry[idx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static short getAllocatedTypesCount() {
        Object object = lock;
        synchronized (object) {
            return size;
        }
    }

    @NotNull
    public static IElementType[] enumerate(@NotNull Predicate p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/tree/IElementType", "enumerate"));
        }
        ArrayList<IElementType> matches = new ArrayList<IElementType>();
        for (IElementType value : ourRegistry) {
            if (value == null || !p.matches(value)) continue;
            matches.add(value);
        }
        IElementType[] iElementTypeArray = matches.toArray(new IElementType[matches.size()]);
        if (iElementTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/IElementType", "enumerate"));
        }
        return iElementTypeArray;
    }

    public short getRegisteredIndex() {
        short myElementTypeIndex = this.getIndex();
        assert (myElementTypeIndex > 0) : "Element type must be registered: " + this;
        return myElementTypeIndex;
    }

    static {
        lock = new String("registry lock");
        IElementType[] init = new IElementType[137];
        init[0] = new IElementType("NULL", Language.ANY, false);
        IElementType.push(init);
        FACTORY = new ArrayFactory<IElementType>(){

            @NotNull
            public IElementType[] create(int count) {
                IElementType[] iElementTypeArray = new IElementType[count];
                if (iElementTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/IElementType$2", "create"));
                }
                return iElementTypeArray;
            }
        };
    }

    public static interface Predicate {
        public boolean matches(@NotNull IElementType var1);
    }
}

