/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.AbstractSizeAdjustingIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;

public class LayeredIcon
extends AbstractSizeAdjustingIcon {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.LayeredIcon");
    private final Icon[] myIcons;
    private Icon[] myScaledIcons;
    private float myScale;
    private final boolean[] myDisabledLayers;
    private final int[] myHShifts;
    private final int[] myVShifts;
    private int myXShift;
    private int myYShift;

    public LayeredIcon(int layerCount) {
        this.myScale = 1.0f;
        this.myIcons = new Icon[layerCount];
        this.myDisabledLayers = new boolean[layerCount];
        this.myHShifts = new int[layerCount];
        this.myVShifts = new int[layerCount];
    }

    public LayeredIcon(Icon ... icons) {
        if (icons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icons", "com/intellij/ui/LayeredIcon", "<init>"));
        }
        this(icons.length);
        for (int i = 0; i < icons.length; ++i) {
            this.setIcon(icons[i], i);
        }
    }

    public static LayeredIcon createHorizontalIcon(Icon ... icons) {
        if (icons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icons", "com/intellij/ui/LayeredIcon", "createHorizontalIcon"));
        }
        LayeredIcon result = new LayeredIcon(icons.length);
        int maxHeight = 0;
        for (Icon icon : icons) {
            maxHeight = Math.max(maxHeight, icon.getIconHeight());
        }
        int hShift = 0;
        for (int i = 0; i < icons.length; ++i) {
            result.setIcon(icons[i], i, hShift, (maxHeight - icons[i].getIconHeight()) / 2);
            hShift += icons[i].getIconWidth() + 1;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LayeredIcon)) {
            return false;
        }
        LayeredIcon icon = (LayeredIcon)o;
        if (this.myHeight != icon.myHeight) {
            return false;
        }
        if (this.myWidth != icon.myWidth) {
            return false;
        }
        if (this.myXShift != icon.myXShift) {
            return false;
        }
        if (this.myYShift != icon.myYShift) {
            return false;
        }
        if (!Arrays.equals(this.myHShifts, icon.myHShifts)) {
            return false;
        }
        if (!Arrays.equals(this.myIcons, icon.myIcons)) {
            return false;
        }
        if (!Arrays.equals(this.myVShifts, icon.myVShifts)) {
            return false;
        }
        return this.myScale == icon.myScale;
    }

    public int hashCode() {
        return 0;
    }

    public void setIcon(Icon icon, int layer) {
        this.setIcon(icon, layer, 0, 0);
    }

    public Icon getIcon(int layer) {
        return this.myIcons[layer];
    }

    public Icon[] getAllLayers() {
        return this.myIcons;
    }

    public void setIcon(Icon icon, int layer, int hShift, int vShift) {
        if (icon instanceof LayeredIcon) {
            ((LayeredIcon)icon).checkIHaventIconInsideMe(this);
        }
        this.myIcons[layer] = icon;
        this.myHShifts[layer] = hShift;
        this.myVShifts[layer] = vShift;
        this.adjustSize();
    }

    public void setIcon(Icon icon, int layer, int constraint) {
        int y;
        int x;
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        if (width <= 1 || height <= 1) {
            this.setIcon(icon, layer);
            return;
        }
        switch (constraint) {
            case 1: {
                x = (width - w) / 2;
                y = 0;
                break;
            }
            case 2: {
                x = width - w;
                y = 0;
                break;
            }
            case 3: {
                x = width - w;
                y = (height - h) / 2;
                break;
            }
            case 4: {
                x = width - w;
                y = height - h;
                break;
            }
            case 5: {
                x = (width - w) / 2;
                y = height - h;
                break;
            }
            case 6: {
                x = 0;
                y = height - h;
                break;
            }
            case 7: {
                x = 0;
                y = (height - h) / 2;
                break;
            }
            case 8: {
                x = 0;
                y = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("The constraint should be one of SwingConstants [NORTH...NORTH_WEST], actual value is " + constraint);
            }
        }
        this.setIcon(icon, layer, x, y);
    }

    private void checkIHaventIconInsideMe(Icon icon) {
        LOG.assertTrue(icon != this);
        for (Icon child : this.myIcons) {
            if (!(child instanceof LayeredIcon)) continue;
            ((LayeredIcon)child).checkIHaventIconInsideMe(icon);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        for (int i = 0; i < this.myIcons.length; ++i) {
            Icon icon = this.getOrScale(i);
            if (icon == null || this.myDisabledLayers[i]) continue;
            int xOffset = x + this.scale(this.myXShift + this.myHShifts[i]);
            int yOffset = y + this.scale(this.myYShift + this.myVShifts[i]);
            icon.paintIcon(c, g, xOffset, yOffset);
        }
    }

    private Icon getOrScale(int i) {
        Icon icon;
        if (this.myScale == 1.0f) {
            return this.myIcons[i];
        }
        if (this.myScaledIcons == null) {
            this.myScaledIcons = new Icon[this.myIcons.length];
        }
        if ((icon = this.myScaledIcons[i]) == null && this.myIcons[i] != null && (icon = this.myIcons[i]) instanceof ScalableIcon) {
            icon = this.myScaledIcons[i] = ((ScalableIcon)icon).scale(this.myScale);
        }
        return icon;
    }

    private Icon[] getIcons() {
        return this.myScaledIcons != null && this.myScale != 1.0f ? this.myScaledIcons : this.myIcons;
    }

    public boolean isLayerEnabled(int layer) {
        return !this.myDisabledLayers[layer];
    }

    public void setLayerEnabled(int layer, boolean enabled) {
        this.myDisabledLayers[layer] = !enabled;
    }

    @Override
    public int getIconWidth() {
        if (this.myWidth <= 1) {
            this.adjustSize();
            return this.scale(this.myWidth);
        }
        return this.scale(super.getIconWidth());
    }

    @Override
    public int getIconHeight() {
        if (this.myHeight <= 1) {
            this.adjustSize();
            return this.scale(this.myHeight);
        }
        return this.scale(super.getIconHeight());
    }

    private int scale(int n) {
        return this.myScale == 1.0f ? n : (int)((float)n * this.myScale);
    }

    @Override
    protected void adjustSize() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        boolean hasNotNullIcons = false;
        for (int i = 0; i < this.myIcons.length; ++i) {
            Icon icon = this.myIcons[i];
            if (icon == null) continue;
            hasNotNullIcons = true;
            int hShift = this.myHShifts[i];
            int vShift = this.myVShifts[i];
            minX = Math.min(minX, hShift);
            maxX = Math.max(maxX, hShift + icon.getIconWidth());
            minY = Math.min(minY, vShift);
            maxY = Math.max(maxY, vShift + icon.getIconHeight());
        }
        if (!hasNotNullIcons) {
            return;
        }
        this.myWidth = maxX - minX;
        this.myHeight = maxY - minY;
        if (this.myIcons.length > 1) {
            this.myXShift = -minX;
            this.myYShift = -minY;
        }
    }

    public static Icon create(Icon backgroundIcon, Icon foregroundIcon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(backgroundIcon, 0);
        layeredIcon.setIcon(foregroundIcon, 1);
        return layeredIcon;
    }

    public String toString() {
        return "Layered icon. myIcons=" + Arrays.asList(this.myIcons);
    }

    @Override
    public Icon scale(float scaleFactor) {
        if (this.myScale != scaleFactor) {
            this.myScale = scaleFactor;
            if (this.myScaledIcons != null) {
                Arrays.fill(this.myScaledIcons, null);
            }
            this.adjustSize();
        }
        return this;
    }
}

