/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardcodedContracts {
    public static List<MethodContract> getHardcodedContracts(@NotNull PsiMethod method, @Nullable PsiMethodCallExpression call) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "getHardcodedContracts"));
        }
        PsiClass owner = method.getContainingClass();
        if (owner == null) {
            return Collections.emptyList();
        }
        int paramCount = method.getParameterList().getParametersCount();
        String className = owner.getQualifiedName();
        if (className == null) {
            return Collections.emptyList();
        }
        String methodName = method.getName();
        if ("java.lang.System".equals(className)) {
            if ("exit".equals(methodName)) {
                return Collections.singletonList(new MethodContract(MethodContract.createConstraintArray(paramCount), MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else if ("com.google.common.base.Preconditions".equals(className)) {
            if ("checkNotNull".equals(methodName) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.NULL_VALUE;
                return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
            if (("checkArgument".equals(methodName) || "checkState".equals(methodName)) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.FALSE_VALUE;
                return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else if ("java.util.Objects".equals(className)) {
            if ("requireNonNull".equals(methodName) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.NULL_VALUE;
                return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else if ("org.apache.commons.lang.Validate".equals(className) || "org.apache.commons.lang3.Validate".equals(className) || "org.springframework.util.Assert".equals(className)) {
            if ("notNull".equals(methodName) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.NULL_VALUE;
                return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else if ("junit.framework.Assert".equals(className) || "org.junit.Assert".equals(className) || "junit.framework.TestCase".equals(className) || "com.google.common.truth.Truth".equals(className) || className.startsWith("org.assertj.core.api.") || "org.testng.Assert".equals(className) || "org.testng.AssertJUnit".equals(className)) {
            return HardcodedContracts.handleTestFrameworks(paramCount, className, methodName, call);
        }
        return Collections.emptyList();
    }

    private static boolean isNotNullMatcher(PsiExpression expr) {
        if (expr instanceof PsiMethodCallExpression) {
            PsiExpression[] equalArgs;
            PsiExpression[] notArgs;
            String calledName = ((PsiMethodCallExpression)expr).getMethodExpression().getReferenceName();
            if ("notNullValue".equals(calledName)) {
                return true;
            }
            if ("not".equals(calledName) && (notArgs = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length == 1 && notArgs[0] instanceof PsiMethodCallExpression && "equalTo".equals(((PsiMethodCallExpression)notArgs[0]).getMethodExpression().getReferenceName()) && (equalArgs = ((PsiMethodCallExpression)notArgs[0]).getArgumentList().getExpressions()).length == 1 && ExpressionUtils.isNullLiteral(equalArgs[0])) {
                return true;
            }
        }
        return false;
    }

    private static List<MethodContract> handleTestFrameworks(int paramCount, String className, String methodName, @Nullable PsiMethodCallExpression call) {
        if ("assertThat".equals(methodName) && call != null) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == paramCount) {
                PsiElement parent;
                for (int i = 1; i < args.length; ++i) {
                    if (!HardcodedContracts.isNotNullMatcher(args[i])) continue;
                    MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(args.length);
                    constraints[i - 1] = MethodContract.ValueConstraint.NULL_VALUE;
                    return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
                }
                if (args.length == 1 && (parent = call.getParent()) instanceof PsiReferenceExpression && "isNotNull".equals(((PsiReferenceExpression)parent).getReferenceName()) && parent.getParent() instanceof PsiMethodCallExpression) {
                    return Collections.singletonList(new MethodContract(new MethodContract.ValueConstraint[]{MethodContract.ValueConstraint.NULL_VALUE}, MethodContract.ValueConstraint.THROW_EXCEPTION));
                }
            }
            return Collections.emptyList();
        }
        if (!("junit.framework.Assert".equals(className) || "junit.framework.TestCase".equals(className) || "org.junit.Assert".equals(className) || "org.testng.Assert".equals(className) || "org.testng.AssertJUnit".equals(className))) {
            return Collections.emptyList();
        }
        boolean testng = className.startsWith("org.testng.");
        if ("fail".equals(methodName)) {
            return Collections.singletonList(new MethodContract(MethodContract.createConstraintArray(paramCount), MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        int checkedParam = testng ? 0 : paramCount - 1;
        MethodContract.ValueConstraint[] constraints = MethodContract.createConstraintArray(paramCount);
        if ("assertTrue".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.FALSE_VALUE;
            return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertFalse".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.TRUE_VALUE;
            return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertNull".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.NOT_NULL_VALUE;
            return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertNotNull".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.NULL_VALUE;
            return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        return Collections.emptyList();
    }

    public static boolean isHardcodedPure(PsiMethod method) {
        PsiParameter[] parameters;
        String qName = PsiUtil.getMemberQualifiedName(method);
        if ("java.lang.System.exit".equals(qName)) {
            return false;
        }
        return !"java.util.Objects.requireNonNull".equals(qName) || (parameters = method.getParameterList().getParameters()).length != 2 || !parameters[1].getType().getCanonicalText().contains("Supplier");
    }

    public static boolean hasHardcodedContracts(@Nullable PsiElement element) {
        if (element instanceof PsiMethod) {
            return !HardcodedContracts.getHardcodedContracts((PsiMethod)element, null).isEmpty();
        }
        if (element instanceof PsiParameter) {
            PsiElement parent = element.getParent();
            return parent != null && HardcodedContracts.hasHardcodedContracts(parent.getParent());
        }
        return false;
    }
}

