/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PurityInference {
    public static boolean inferPurity(final @NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/PurityInference", "inferPurity"));
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method) || PsiType.VOID.equals(method.getReturnType()) || method.getBody() == null || method.isConstructor() || PropertyUtil.isSimpleGetter(method)) {
            return false;
        }
        return CachedValuesManager.getCachedValue(method, new CachedValueProvider<Boolean>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                boolean pure = RecursionManager.doPreventingRecursion(method, true, new Computable<Boolean>(){

                    @Override
                    public Boolean compute() {
                        return PurityInference.doInferPurity(method);
                    }
                }) == Boolean.TRUE;
                return CachedValueProvider.Result.create(Boolean.valueOf(pure), method);
            }
        });
    }

    private static boolean doInferPurity(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        final Ref<Boolean> impureFound = Ref.create(false);
        final Ref<Boolean> hasReturns = Ref.create(false);
        final ArrayList calls = ContainerUtil.newArrayList();
        body.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                if (!PurityInference.isLocalVarReference(expression.getLExpression())) {
                    impureFound.set(true);
                }
                super.visitAssignmentExpression(expression);
            }

            @Override
            public void visitReturnStatement(PsiReturnStatement statement) {
                if (statement.getReturnValue() != null) {
                    hasReturns.set(true);
                }
                super.visitReturnStatement(statement);
            }

            @Override
            public void visitPrefixExpression(PsiPrefixExpression expression) {
                if (this.isMutatingOperation(expression.getOperationTokenType()) && !PurityInference.isLocalVarReference(expression.getOperand())) {
                    impureFound.set(true);
                }
                super.visitPrefixExpression(expression);
            }

            private boolean isMutatingOperation(IElementType operationTokenType) {
                return operationTokenType == JavaTokenType.PLUSPLUS || operationTokenType == JavaTokenType.MINUSMINUS;
            }

            @Override
            public void visitPostfixExpression(PsiPostfixExpression expression) {
                if (this.isMutatingOperation(expression.getOperationTokenType()) && !PurityInference.isLocalVarReference(expression.getOperand())) {
                    impureFound.set(true);
                }
                super.visitPostfixExpression(expression);
            }

            @Override
            public void visitCallExpression(PsiCallExpression callExpression) {
                if (!(callExpression instanceof PsiNewExpression) || ((PsiNewExpression)callExpression).getArrayDimensions().length == 0) {
                    calls.add(callExpression);
                }
                super.visitCallExpression(callExpression);
            }
        });
        if (impureFound.get().booleanValue() || calls.size() > 1 || !hasReturns.get().booleanValue()) {
            return false;
        }
        if (calls.isEmpty()) {
            return true;
        }
        PsiMethod called = ((PsiCallExpression)calls.get(0)).resolveMethod();
        return called != null && ControlFlowAnalyzer.isPure(called);
    }

    private static boolean isLocalVarReference(PsiExpression expression) {
        if (expression instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression).resolve();
            return target instanceof PsiLocalVariable || target instanceof PsiParameter;
        }
        if (expression instanceof PsiArrayAccessExpression) {
            return PurityInference.isLocalVarReference(((PsiArrayAccessExpression)expression).getArrayExpression());
        }
        return false;
    }
}

