/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaitNotInSynchronizedContextInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("WaitWhileNotSynced" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection", "getID"));
        }
        return "WaitWhileNotSynced";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("wait.not.in.synchronized.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String text;
        if (infos.length > 0) {
            PsiElement element = (PsiElement)infos[0];
            text = element.getText();
        } else {
            text = "this";
        }
        String string = InspectionGadgetsBundle.message("wait.not.in.synchronized.context.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitNotInSynchronizedContextVisitor();
    }

    private static class WaitNotInSynchronizedContextVisitor
    extends BaseInspectionVisitor {
        private WaitNotInSynchronizedContextVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection$WaitNotInSynchronizedContextVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"wait".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (!"java.lang.Object".equals(qualifiedName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                if (WaitNotInSynchronizedContextVisitor.isSynchronizedOnThis(expression)) {
                    return;
                }
                this.registerError((PsiElement)expression, new Object[0]);
            } else if (qualifier instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target = referenceExpression.resolve();
                if (WaitNotInSynchronizedContextVisitor.isSynchronizedOn(expression, target)) {
                    return;
                }
                this.registerError((PsiElement)expression, qualifier);
            }
        }

        private static boolean isSynchronizedOn(@NotNull PsiElement element, @Nullable PsiElement target) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection$WaitNotInSynchronizedContextVisitor", "isSynchronizedOn"));
            }
            if (target == null) {
                return false;
            }
            PsiSynchronizedStatement context = PsiTreeUtil.getParentOfType(element, PsiSynchronizedStatement.class);
            if (context == null) {
                return false;
            }
            PsiSynchronizedStatement synchronizedStatement = context;
            PsiExpression lockExpression = synchronizedStatement.getLockExpression();
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression;
            PsiElement lockTarget = referenceExpression.resolve();
            return target.equals(lockTarget) || WaitNotInSynchronizedContextVisitor.isSynchronizedOn(synchronizedStatement, target);
        }

        private static boolean isSynchronizedOnThis(@NotNull PsiElement element) {
            PsiMethod method;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection$WaitNotInSynchronizedContextVisitor", "isSynchronizedOnThis"));
            }
            Object context = PsiTreeUtil.getParentOfType(element, PsiMethod.class, PsiSynchronizedStatement.class);
            if (context instanceof PsiSynchronizedStatement) {
                PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)context;
                PsiExpression lockExpression = synchronizedStatement.getLockExpression();
                return lockExpression instanceof PsiThisExpression || WaitNotInSynchronizedContextVisitor.isSynchronizedOnThis(synchronizedStatement);
            }
            return context instanceof PsiMethod && (method = (PsiMethod)context).hasModifierProperty("synchronized");
        }
    }
}

