/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeStringLiteralToCharInMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConstructorParametersFixer;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertDoubleToFloatFix;
import com.intellij.codeInsight.daemon.impl.quickfix.PermuteArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveRedundantArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapArrayToArraysAsListFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightMethodUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final String MISMATCH_COLOR = UIUtil.isUnderDarcula() ? "ff6464" : "red";

    private HighlightMethodUtil() {
    }

    static String createClashMethodMessage(PsiMethod method1, PsiMethod method2, boolean showContainingClasses) {
        String pattern = showContainingClasses ? "clash.methods.message.show.classes" : "clash.methods.message";
        return JavaErrorMessages.message(pattern, JavaHighlightUtil.formatMethod(method1), JavaHighlightUtil.formatMethod(method2), HighlightUtil.formatClass(method1.getContainingClass()), HighlightUtil.formatClass(method2.getContainingClass()));
    }

    static HighlightInfo checkMethodWeakerPrivileges(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @NotNull PsiFile containingFile) {
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodWeakerPrivileges"));
        }
        if (superMethodSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignatures", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodWeakerPrivileges"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodWeakerPrivileges"));
        }
        PsiMethod method = methodSignature.getMethod();
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList.hasModifierProperty("public")) {
            return null;
        }
        int accessLevel = PsiUtil.getAccessLevel(modifierList);
        String accessModifier = PsiUtil.getAccessModifier(accessLevel);
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            HighlightInfo info;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            if (method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod(superMethod, method) || !PsiUtil.isAccessible(containingFile.getProject(), superMethod, method, null) || !includeRealPositionInfo && MethodSignatureUtil.isSuperMethod(superMethod, method) || (info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, includeRealPositionInfo)) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo isWeaker(PsiMethod method, PsiModifierList modifierList, String accessModifier, int accessLevel, PsiMethod superMethod, boolean includeRealPositionInfo) {
        int superAccessLevel = PsiUtil.getAccessLevel(superMethod.getModifierList());
        if (accessLevel < superAccessLevel) {
            TextRange textRange;
            String description = JavaErrorMessages.message("weaker.privileges", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), accessModifier, PsiUtil.getAccessModifier(superAccessLevel));
            if (includeRealPositionInfo) {
                if (modifierList.hasModifierProperty("packageLocal")) {
                    textRange = method.getNameIdentifier().getTextRange();
                } else {
                    PsiElement keyword = PsiUtil.findModifierInList(modifierList, accessModifier);
                    textRange = keyword.getTextRange();
                }
            } else {
                textRange = TextRange.EMPTY_RANGE;
            }
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(method, PsiUtil.getAccessModifier(superAccessLevel), true, false));
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo) {
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodIncompatibleReturnType"));
        }
        if (superMethodSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignatures", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodIncompatibleReturnType"));
        }
        return HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, includeRealPositionInfo, null);
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @Nullable TextRange textRange) {
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodIncompatibleReturnType"));
        }
        if (superMethodSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignatures", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodIncompatibleReturnType"));
        }
        PsiMethod method = methodSignature.getMethod();
        PsiType returnType = methodSignature.getSubstitutor().substitute(method.getReturnType());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            TextRange toHighlight;
            PsiClass superClass;
            PsiType declaredReturnType;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            PsiType superReturnType = declaredReturnType = superMethod.getReturnType();
            if (methodSignatureBackedByPsiMethod.isRaw()) {
                superReturnType = TypeConversionUtil.erasure(declaredReturnType);
            }
            if (returnType == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null) continue;
            TextRange textRange2 = textRange != null ? textRange : (toHighlight = includeRealPositionInfo ? method.getReturnTypeElement().getTextRange() : TextRange.EMPTY_RANGE);
            HighlightInfo highlightInfo = HighlightMethodUtil.checkSuperMethodSignature(superMethod, methodSignatureBackedByPsiMethod, superReturnType, method, methodSignature, returnType, JavaErrorMessages.message("incompatible.return.type", new Object[0]), toHighlight, PsiUtil.getLanguageLevel(aClass));
            if (highlightInfo == null) continue;
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodSignature(@NotNull PsiMethod superMethod, @NotNull MethodSignatureBackedByPsiMethod superMethodSignature, PsiType superReturnType, @NotNull PsiMethod method, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange range, @NotNull LanguageLevel languageLevel) {
        PsiSubstitutor unifyingSubstitutor;
        boolean isJdk15;
        PsiType substitutedSuperReturnType;
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (superMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (detailMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailMessage", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperMethodSignature"));
        }
        if (superReturnType == null) {
            return null;
        }
        if ("clone".equals(method.getName())) {
            PsiClass containingClass = method.getContainingClass();
            PsiClass superContainingClass = superMethod.getContainingClass();
            if (containingClass != null && superContainingClass != null && containingClass.isInterface() && !superContainingClass.isInterface()) {
                return null;
            }
        }
        if (returnType.equals(substitutedSuperReturnType = (isJdk15 = languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) && !superMethodSignature.isRaw() && superMethodSignature.equals(methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(methodSignature, superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superReturnType)) : TypeConversionUtil.erasure(superMethodSignature.getSubstitutor().substitute(superReturnType)))) {
            return null;
        }
        if (!(returnType instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && isJdk15 && TypeConversionUtil.isAssignable(substitutedSuperReturnType, returnType)) {
            return null;
        }
        return HighlightMethodUtil.createIncompatibleReturnTypeMessage(method, superMethod, substitutedSuperReturnType, returnType, detailMessage, range);
    }

    private static HighlightInfo createIncompatibleReturnTypeMessage(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull PsiType substitutedSuperReturnType, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange textRange) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        if (substitutedSuperReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedSuperReturnType", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        if (detailMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailMessage", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createIncompatibleReturnTypeMessage"));
        }
        String description = MessageFormat.format("{0}; {1}", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), detailMessage);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMethodReturnFix(method, substitutedSuperReturnType, false));
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createSuperMethodReturnFix(superMethod, returnType));
        return errorResult;
    }

    static HighlightInfo checkMethodOverridesFinal(MethodSignatureBackedByPsiMethod methodSignature, List<HierarchicalMethodSignature> superMethodSignatures) {
        PsiMethod method = methodSignature.getMethod();
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            HighlightInfo info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodIsFinal(PsiMethod method, PsiMethod superMethod) {
        if (superMethod.hasModifierProperty("final")) {
            String description = JavaErrorMessages.message("final.method.override", JavaHighlightUtil.formatMethod(method), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superMethod.getContainingClass()));
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(superMethod, "final", false, true));
            return errorResult;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleThrows(MethodSignatureBackedByPsiMethod methodSignature, List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, PsiClass analyzedClass) {
        PsiJavaCodeReferenceElement[] referenceElements;
        ArrayList<PsiJavaCodeReferenceElement> exceptionContexts;
        PsiMethod method = methodSignature.getMethod();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(aClass, analyzedClass, PsiSubstitutor.EMPTY);
        PsiClassType[] exceptions = method.getThrowsList().getReferencedTypes();
        if (includeRealPositionInfo) {
            exceptionContexts = new ArrayList<PsiJavaCodeReferenceElement>();
            referenceElements = method.getThrowsList().getReferenceElements();
        } else {
            exceptionContexts = null;
            referenceElements = null;
        }
        ArrayList<PsiClassType> checkedExceptions = new ArrayList<PsiClassType>();
        for (int i = 0; i < exceptions.length; ++i) {
            PsiClassType psiClassType = exceptions[i];
            if (ExceptionUtil.isUncheckedException(psiClassType)) continue;
            checkedExceptions.add(psiClassType);
            if (!includeRealPositionInfo || i >= referenceElements.length) continue;
            PsiJavaCodeReferenceElement exceptionRef = referenceElements[i];
            exceptionContexts.add(exceptionRef);
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            TextRange textRange;
            PsiClass superContainingClass;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            int index = HighlightMethodUtil.getExtraExceptionNum(methodSignature, methodSignatureBackedByPsiMethod, checkedExceptions, superSubstitutor);
            if (index == -1 || aClass.isInterface() && ((superContainingClass = superMethod.getContainingClass()) != null && !superContainingClass.isInterface() || superContainingClass != null && !aClass.isInheritor(superContainingClass, true))) continue;
            PsiClassType exception = (PsiClassType)checkedExceptions.get(index);
            String description = JavaErrorMessages.message("overridden.method.does.not.throw", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), JavaHighlightUtil.formatType(exception));
            if (includeRealPositionInfo) {
                PsiElement exceptionContext = (PsiElement)exceptionContexts.get(index);
                textRange = exceptionContext.getTextRange();
            } else {
                textRange = TextRange.EMPTY_RANGE;
            }
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(errorResult, new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, false, false)));
            QuickFixAction.registerQuickFixAction(errorResult, new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(superMethod, exception, true, true)));
            return errorResult;
        }
        return null;
    }

    private static int getExtraExceptionNum(MethodSignature methodSignature, MethodSignatureBackedByPsiMethod superSignature, List<PsiClassType> checkedExceptions, PsiSubstitutor substitutorForDerivedClass) {
        PsiMethod superMethod = superSignature.getMethod();
        PsiSubstitutor substitutorForMethod = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(methodSignature, superSignature);
        for (int i = 0; i < checkedExceptions.size(); ++i) {
            PsiClassType checkedEx = checkedExceptions.get(i);
            PsiType substituted = substitutorForMethod != null ? substitutorForMethod.substitute(checkedEx) : TypeConversionUtil.erasure(checkedEx);
            PsiType exception = substitutorForDerivedClass.substitute(substituted);
            if (HighlightMethodUtil.isMethodThrows(superMethod, substitutorForMethod, exception, substitutorForDerivedClass)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isMethodThrows(PsiMethod method, @Nullable PsiSubstitutor substitutorForMethod, PsiType exception, PsiSubstitutor substitutorForDerivedClass) {
        PsiClassType[] thrownExceptions;
        for (PsiClassType thrownException1 : thrownExceptions = method.getThrowsList().getReferencedTypes()) {
            PsiType thrownException = substitutorForMethod != null ? substitutorForMethod.substitute(thrownException1) : TypeConversionUtil.erasure(thrownException1);
            if (!TypeConversionUtil.isAssignable(thrownException = substitutorForDerivedClass.substitute(thrownException), exception)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull JavaSdkVersion javaSdkVersion) {
        HighlightInfo highlightInfo;
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCall"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCall"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCall"));
        }
        if (javaSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdkVersion", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCall"));
        }
        PsiExpressionList list = methodCall.getArgumentList();
        PsiReferenceExpression referenceToMethod = methodCall.getMethodExpression();
        JavaResolveResult[] results = referenceToMethod.multiResolve(true);
        JavaResolveResult resolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement resolved = resolveResult.getElement();
        boolean isDummy = HighlightMethodUtil.isDummyConstructorCall(methodCall, resolveHelper, list, referenceToMethod);
        if (isDummy) {
            return null;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (resolved instanceof PsiMethod && resolveResult.isValidResult()) {
            TextRange fixRange = HighlightMethodUtil.getFixRange(methodCall);
            highlightInfo = HighlightUtil.checkUnhandledExceptions(methodCall, fixRange);
            if (highlightInfo == null) {
                String invalidCallMessage = LambdaUtil.getInvalidQualifier4StaticInterfaceMethodMessage((PsiMethod)resolved, methodCall.getMethodExpression(), resolveResult.getCurrentFileResolveScope(), languageLevel);
                if (invalidCallMessage != null) {
                    highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip(invalidCallMessage).range(fixRange).create();
                    if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                        QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(LanguageLevel.JDK_1_8));
                    }
                } else {
                    highlightInfo = GenericsHighlightUtil.checkInferredIntersections(substitutor, fixRange);
                }
                if (highlightInfo == null) {
                    highlightInfo = HighlightMethodUtil.checkVarargParameterErasureToBeAccessible((MethodCandidateInfo)resolveResult, methodCall);
                }
            }
        } else {
            PsiMethod resolvedMethod = null;
            MethodCandidateInfo candidateInfo = null;
            if (resolveResult instanceof MethodCandidateInfo) {
                candidateInfo = (MethodCandidateInfo)resolveResult;
                resolvedMethod = candidateInfo.getElement();
            }
            if (!resolveResult.isAccessible() || !resolveResult.isStaticsScopeCorrect()) {
                highlightInfo = null;
            } else if (candidateInfo != null && !candidateInfo.isApplicable()) {
                if (candidateInfo.isTypeArgumentsApplicable()) {
                    PsiElement element;
                    String toolTip;
                    String methodName = HighlightMessageUtil.getSymbolName(resolved, substitutor);
                    PsiElement parent = resolved.getParent();
                    String containerName = parent == null ? "" : HighlightMessageUtil.getSymbolName(parent, substitutor);
                    String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                    String description = JavaErrorMessages.message("wrong.method.arguments", methodName, containerName, argTypes);
                    Ref<PsiElement> elementToHighlight = new Ref<PsiElement>(list);
                    if (parent instanceof PsiClass && !ApplicationManager.getApplication().isUnitTestMode()) {
                        toolTip = HighlightMethodUtil.buildOneLineMismatchDescription(list, candidateInfo, elementToHighlight);
                        if (toolTip == null) {
                            toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list);
                        }
                    } else {
                        toolTip = description;
                    }
                    int navigationShift = (element = (PsiElement)elementToHighlight.get()) instanceof PsiExpressionList ? 1 : 0;
                    highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).description(description).escapedToolTip(toolTip).navigationShift(navigationShift).create();
                    if (highlightInfo != null) {
                        HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list, resolveHelper);
                        HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, candidateInfo, methodCall);
                    }
                } else {
                    PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
                    PsiReferenceParameterList typeArgumentList = methodCall.getTypeArgumentList();
                    highlightInfo = typeArgumentList.getTypeArguments().length == 0 && resolvedMethod.hasTypeParameters() ? GenericsHighlightUtil.checkInferredTypeArguments(resolvedMethod, (PsiElement)methodCall, substitutor) : GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, methodExpression, substitutor, javaSdkVersion);
                }
            } else {
                String description = JavaErrorMessages.message("method.call.expected", new Object[0]);
                highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(methodCall).descriptionAndTooltip(description).create();
                if (resolved instanceof PsiClass) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createInsertNewFix(methodCall, (PsiClass)resolved));
                } else {
                    TextRange range = HighlightMethodUtil.getFixRange(methodCall);
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createCreateMethodFromUsageFix(methodCall));
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createCreateAbstractMethodFromUsageFix(methodCall));
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, QUICK_FIX_FACTORY.createCreatePropertyFromUsageFix(methodCall));
                }
            }
        }
        if (highlightInfo == null) {
            highlightInfo = GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, referenceToMethod, substitutor, javaSdkVersion);
        }
        return highlightInfo;
    }

    private static void registerMethodReturnFixAction(HighlightInfo highlightInfo, MethodCandidateInfo candidate, PsiCall methodCall) {
        PsiMethod containerMethod;
        if (methodCall.getParent() instanceof PsiReturnStatement && (containerMethod = PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, true, PsiLambdaExpression.class)) != null) {
            PsiMethod method = candidate.getElement();
            PsiExpression methodCallCopy = JavaPsiFacade.getElementFactory(method.getProject()).createExpressionFromText(methodCall.getText(), methodCall);
            PsiType methodCallTypeByArgs = methodCallCopy.getType();
            methodCallTypeByArgs = JavaPsiFacade.getElementFactory(method.getProject()).createRawSubstitutor(method).substitute(methodCallTypeByArgs);
            QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange(methodCall), QUICK_FIX_FACTORY.createMethodReturnFix(containerMethod, methodCallTypeByArgs, true));
        }
    }

    private static String buildOneLineMismatchDescription(@NotNull PsiExpressionList list, @NotNull MethodCandidateInfo candidateInfo, @NotNull Ref<PsiElement> elementToHighlight) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "buildOneLineMismatchDescription"));
        }
        if (candidateInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateInfo", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "buildOneLineMismatchDescription"));
        }
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "buildOneLineMismatchDescription"));
        }
        PsiExpression[] expressions = list.getExpressions();
        PsiMethod resolvedMethod = candidateInfo.getElement();
        PsiSubstitutor substitutor = candidateInfo.getSubstitutor();
        PsiParameter[] parameters = resolvedMethod.getParameterList().getParameters();
        if (expressions.length == parameters.length && parameters.length > 1) {
            PsiExpression wrongArg;
            PsiType argType;
            int idx = -1;
            for (int i = 0; i < expressions.length; ++i) {
                PsiExpression expression = expressions[i];
                if (TypeConversionUtil.areTypesAssignmentCompatible(substitutor.substitute(parameters[i].getType()), expression)) continue;
                if (idx != -1) {
                    idx = -1;
                    break;
                }
                idx = i;
            }
            if (idx > -1 && (argType = (wrongArg = expressions[idx]).getType()) != null) {
                elementToHighlight.set(wrongArg);
                String message = JavaErrorMessages.message("incompatible.call.types", idx + 1, substitutor.substitute(parameters[idx].getType()).getCanonicalText(), argType.getCanonicalText());
                return XmlStringUtil.wrapInHtml("<body>" + XmlStringUtil.escapeString(message) + " <a href=\"#assignment/" + XmlStringUtil.escapeString(HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list)) + "\"" + (UIUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message("inspection.extended.description", new Object[0]) + "</a></body>");
            }
        }
        return null;
    }

    static boolean isDummyConstructorCall(PsiMethodCallExpression methodCall, PsiResolveHelper resolveHelper, PsiExpressionList list, PsiReferenceExpression referenceToMethod) {
        CandidateInfo[] candidates;
        boolean isDummy = false;
        boolean isThisOrSuper = referenceToMethod.getReferenceNameElement() instanceof PsiKeyword;
        if (isThisOrSuper && list.getExpressions().length == 0 && (candidates = resolveHelper.getReferencedMethodCandidates(methodCall, true)).length == 1 && !candidates[0].getElement().isPhysical()) {
            isDummy = true;
        }
        return isDummy;
    }

    @Nullable
    static HighlightInfo checkAmbiguousMethodCallIdentifier(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult[] resolveResults, @NotNull PsiExpressionList list, PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper) {
        PsiElement elementToHighlight;
        String description;
        if (referenceToMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceToMethod", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallIdentifier"));
        }
        MethodCandidateInfo methodCandidate1 = null;
        MethodCandidateInfo methodCandidate2 = null;
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isApplicable() || candidate.getElement().isConstructor()) continue;
            if (methodCandidate1 == null) {
                methodCandidate1 = candidate;
                continue;
            }
            methodCandidate2 = candidate;
            break;
        }
        JavaResolveResult[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        if (methodCandidate2 != null) {
            return null;
        }
        if (element != null && !resolveResult.isAccessible()) {
            description = HighlightUtil.buildProblemWithAccessDescription(referenceToMethod, resolveResult);
            elementToHighlight = referenceToMethod.getReferenceNameElement();
        } else if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(referenceToMethod);
            String staticInterfaceMethodMessage = element instanceof PsiMethod ? LambdaUtil.getInvalidQualifier4StaticInterfaceMethodMessage((PsiMethod)element, referenceToMethod, resolveResult.getCurrentFileResolveScope(), languageLevel) : null;
            description = staticInterfaceMethodMessage != null ? staticInterfaceMethodMessage : HighlightUtil.buildProblemWithStaticDescription(element);
            elementToHighlight = referenceToMethod.getReferenceNameElement();
        } else {
            String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list);
            description = JavaErrorMessages.message("cannot.resolve.method", methodName);
            if (candidates.length == 0) {
                elementToHighlight = referenceToMethod.getReferenceNameElement();
                highlightInfoType = HighlightInfoType.WRONG_REF;
            } else {
                return null;
            }
        }
        String toolTip = XmlStringUtil.escapeString(description);
        HighlightInfo info = HighlightInfo.newHighlightInfo(highlightInfoType).range(elementToHighlight).description(description).escapedToolTip(toolTip).create();
        HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list, resolveHelper);
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightUtil.registerStaticProblemQuickFixAction(element, info, referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, methodCall, info, fixRange);
        WrapArrayToArraysAsListFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction(candidates, list.getExpressions(), info);
        HighlightMethodUtil.registerChangeParameterClassFix(methodCall, list, info);
        return info;
    }

    @Nullable
    static HighlightInfo checkAmbiguousMethodCallArguments(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult[] resolveResults, @NotNull PsiExpressionList list, PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull PsiElement elementToHighlight) {
        String toolTip;
        String description;
        if (referenceToMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceToMethod", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkAmbiguousMethodCallArguments"));
        }
        MethodCandidateInfo methodCandidate1 = null;
        MethodCandidateInfo methodCandidate2 = null;
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isApplicable() || candidate.getElement().isConstructor()) continue;
            if (methodCandidate1 == null) {
                methodCandidate1 = candidate;
                continue;
            }
            methodCandidate2 = candidate;
            break;
        }
        JavaResolveResult[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        if (methodCandidate2 != null) {
            VirtualFile virtualFile2;
            PsiMethod element1 = methodCandidate1.getElement();
            String m1 = PsiFormatUtil.formatMethod(element1, methodCandidate1.getSubstitutor(), 4353, 2);
            PsiMethod element2 = methodCandidate2.getElement();
            String m2 = PsiFormatUtil.formatMethod(element2, methodCandidate2.getSubstitutor(), 4353, 2);
            VirtualFile virtualFile1 = PsiUtilCore.getVirtualFile(element1);
            if (!Comparing.equal(virtualFile1, virtualFile2 = PsiUtilCore.getVirtualFile(element2))) {
                if (virtualFile1 != null) {
                    m1 = m1 + " (In " + virtualFile1.getPresentableUrl() + ")";
                }
                if (virtualFile2 != null) {
                    m2 = m2 + " (In " + virtualFile2.getPresentableUrl() + ")";
                }
            }
            description = JavaErrorMessages.message("ambiguous.method.call", m1, m2);
            toolTip = HighlightMethodUtil.createAmbiguousMethodHtmlTooltip(new MethodCandidateInfo[]{methodCandidate1, methodCandidate2});
        } else {
            if (element != null && !resolveResult.isAccessible()) {
                return null;
            }
            if (element != null && !resolveResult.isStaticsScopeCorrect()) {
                return null;
            }
            String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list);
            description = JavaErrorMessages.message("cannot.resolve.method", methodName);
            if (candidates.length == 0) {
                return null;
            }
            toolTip = XmlStringUtil.escapeString(description);
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo(highlightInfoType).range(elementToHighlight).description(description).escapedToolTip(toolTip).create();
        if (methodCandidate2 == null) {
            HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list, resolveHelper);
        }
        if (!resolveResult.isAccessible() && resolveResult.isStaticsScopeCorrect() && methodCandidate2 != null) {
            HighlightUtil.registerAccessQuickFixAction((PsiMember)element, referenceToMethod, info, resolveResult.getCurrentFileResolveScope());
        }
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightUtil.registerStaticProblemQuickFixAction(element, info, referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, methodCall, info, fixRange);
        WrapArrayToArraysAsListFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction(candidates, list.getExpressions(), info);
        HighlightMethodUtil.registerChangeParameterClassFix(methodCall, list, info);
        return info;
    }

    @NotNull
    private static MethodCandidateInfo[] toMethodCandidates(@NotNull JavaResolveResult[] resolveResults) {
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "toMethodCandidates"));
        }
        ArrayList<MethodCandidateInfo> candidateList = new ArrayList<MethodCandidateInfo>(resolveResults.length);
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isAccessible()) continue;
            candidateList.add(candidate);
        }
        MethodCandidateInfo[] methodCandidateInfoArray = candidateList.toArray(new MethodCandidateInfo[candidateList.size()]);
        if (methodCandidateInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "toMethodCandidates"));
        }
        return methodCandidateInfoArray;
    }

    private static void registerMethodCallIntentions(@Nullable HighlightInfo highlightInfo, PsiMethodCallExpression methodCall, PsiExpressionList list, PsiResolveHelper resolveHelper) {
        TextRange fixRange = HighlightMethodUtil.getFixRange(methodCall);
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateMethodFromUsageFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateAbstractMethodFromUsageFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateConstructorFromSuperFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateConstructorFromThisFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreatePropertyFromUsageFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createCreateGetterSetterPropertyFromUsageFix(methodCall));
        JavaResolveResult[] methodCandidates = resolveHelper.getReferencedMethodCandidates(methodCall, false);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])methodCandidates, methodCall, highlightInfo, fixRange);
        PermuteArgumentsFix.registerFix(highlightInfo, methodCall, (CandidateInfo[])methodCandidates, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions((CandidateInfo[])methodCandidates, methodCall, highlightInfo, fixRange);
        WrapArrayToArraysAsListFix.REGISTAR.registerCastActions((CandidateInfo[])methodCandidates, methodCall, highlightInfo, fixRange);
        HighlightMethodUtil.registerMethodAccessLevelIntentions((CandidateInfo[])methodCandidates, methodCall, list, highlightInfo);
        HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions(methodCandidates, list, highlightInfo, fixRange);
        RemoveRedundantArgumentsFix.registerIntentions(methodCandidates, list, highlightInfo, fixRange);
        ConvertDoubleToFloatFix.registerIntentions(methodCandidates, list, highlightInfo, fixRange);
        WrapExpressionFix.registerWrapAction(methodCandidates, list.getExpressions(), highlightInfo);
        HighlightMethodUtil.registerChangeParameterClassFix(methodCall, list, highlightInfo);
        if (methodCandidates.length == 0) {
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createStaticImportMethodFix(methodCall));
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.addMethodQualifierFix(methodCall));
        }
        for (IntentionAction action : QUICK_FIX_FACTORY.getVariableTypeFromCallFixes(methodCall, list)) {
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, action);
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createReplaceAddAllArrayToCollectionFix(methodCall));
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QUICK_FIX_FACTORY.createSurroundWithArrayFix(methodCall, null));
        QualifyThisArgumentFix.registerQuickFixAction((CandidateInfo[])methodCandidates, methodCall, highlightInfo, fixRange);
        CandidateInfo[] candidates = resolveHelper.getReferencedMethodCandidates(methodCall, true);
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(candidates, methodCall, highlightInfo);
    }

    private static void registerMethodAccessLevelIntentions(CandidateInfo[] methodCandidates, PsiMethodCallExpression methodCall, PsiExpressionList exprList, HighlightInfo highlightInfo) {
        for (CandidateInfo methodCandidate : methodCandidates) {
            PsiMethod method = (PsiMethod)methodCandidate.getElement();
            if (methodCandidate.isAccessible() || !PsiUtil.isApplicable(method, methodCandidate.getSubstitutor(), exprList)) continue;
            HighlightUtil.registerAccessQuickFixAction(method, methodCall.getMethodExpression(), highlightInfo, methodCandidate.getCurrentFileResolveScope());
        }
    }

    @NotNull
    private static String createAmbiguousMethodHtmlTooltip(MethodCandidateInfo[] methodCandidates) {
        String string = JavaErrorMessages.message("ambiguous.method.html.tooltip", methodCandidates[0].getElement().getParameterList().getParametersCount() + 2, HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[0]), HighlightMethodUtil.getContainingClassName(methodCandidates[0]), HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[1]), HighlightMethodUtil.getContainingClassName(methodCandidates[1]));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "createAmbiguousMethodHtmlTooltip"));
        }
        return string;
    }

    private static String getContainingClassName(MethodCandidateInfo methodCandidate) {
        PsiMethod method = methodCandidate.getElement();
        PsiClass containingClass = method.getContainingClass();
        return containingClass == null ? method.getContainingFile().getName() : HighlightUtil.formatClass(containingClass, false);
    }

    @Language(value="HTML")
    private static String createAmbiguousMethodHtmlTooltipMethodRow(MethodCandidateInfo methodCandidate) {
        PsiMethod method = methodCandidate.getElement();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        String ms = "<td><b>" + method.getName() + "</b></td>";
        for (int j = 0; j < parameters.length; ++j) {
            PsiParameter parameter = parameters[j];
            PsiType type = substitutor.substitute(parameter.getType());
            ms = ms + "<td><b>" + (j == 0 ? "(" : "") + XmlStringUtil.escapeString(type.getPresentableText()) + (j == parameters.length - 1 ? ")" : ",") + "</b></td>";
        }
        if (parameters.length == 0) {
            ms = ms + "<td><b>()</b></td>";
        }
        return ms;
    }

    private static String createMismatchedArgumentsHtmlTooltip(MethodCandidateInfo info, PsiExpressionList list) {
        PsiMethod method = info.getElement();
        PsiSubstitutor substitutor = info.getSubstitutor();
        PsiClass aClass = method.getContainingClass();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        String methodName = method.getName();
        return HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list, parameters, methodName, substitutor, aClass);
    }

    private static String createShortMismatchedArgumentsHtmlTooltip(PsiExpressionList list, PsiParameter[] parameters, String methodName, PsiSubstitutor substitutor, PsiClass aClass) {
        PsiExpression[] expressions = list.getExpressions();
        int cols = Math.max(parameters.length, expressions.length);
        String parensizedName = methodName + (parameters.length == 0 ? "(&nbsp;)&nbsp;" : "");
        String errorMessage = InferenceSession.getInferenceErrorMessage(list.getParent());
        return JavaErrorMessages.message("argument.mismatch.html.tooltip", cols - parameters.length + 1, parensizedName, HighlightUtil.formatClass(aClass, false), HighlightMethodUtil.createMismatchedArgsHtmlTooltipParamsRow(parameters, substitutor, expressions), HighlightMethodUtil.createMismatchedArgsHtmlTooltipArgumentsRow(expressions, parameters, substitutor, cols), errorMessage != null ? "<br/>reason: " + XmlStringUtil.escapeString(errorMessage).replaceAll("\n", "<br/>") : "");
    }

    private static String esctrim(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "esctrim"));
        }
        return XmlStringUtil.escapeString(HighlightMethodUtil.trimNicely(s));
    }

    private static String trimNicely(String s) {
        if (s.length() <= 40) {
            return s;
        }
        List<TextRange> wordIndices = StringUtil.getWordIndicesIn(s);
        if (wordIndices.size() > 2) {
            int firstWordEnd = wordIndices.get(0).getEndOffset();
            for (int i = 1; i < wordIndices.size(); ++i) {
                int stringLength = firstWordEnd + s.length() - wordIndices.get(i).getStartOffset();
                if (stringLength > 40) continue;
                return s.substring(0, firstWordEnd) + "..." + s.substring(wordIndices.get(i).getStartOffset());
            }
        }
        if (!wordIndices.isEmpty() && s.length() - wordIndices.get(wordIndices.size() - 1).getStartOffset() <= 40) {
            return "..." + s.substring(wordIndices.get(wordIndices.size() - 1).getStartOffset());
        }
        return StringUtil.last(s, 40, true).toString();
    }

    private static String createMismatchedArgumentsHtmlTooltip(PsiExpressionList list, PsiParameter[] parameters, String methodName, PsiSubstitutor substitutor, PsiClass aClass) {
        return Math.max(parameters.length, list.getExpressions().length) <= 2 ? HighlightMethodUtil.createShortMismatchedArgumentsHtmlTooltip(list, parameters, methodName, substitutor, aClass) : HighlightMethodUtil.createLongMismatchedArgumentsHtmlTooltip(list, parameters, methodName, substitutor, aClass);
    }

    @Language(value="HTML")
    private static String createLongMismatchedArgumentsHtmlTooltip(PsiExpressionList list, PsiParameter[] parameters, String methodName, PsiSubstitutor substitutor, PsiClass aClass) {
        PsiExpression[] expressions = list.getExpressions();
        String s = "<html><body><table border=0><tr><td colspan=3><nobr><b>" + methodName + "()</b> in <b>" + HighlightUtil.formatClass(aClass, false) + "</b> cannot be applied to:</nobr>" + "</td></tr>" + "<tr><td colspan=2 align=left>Expected<br>Parameters:</td><td align=left>Actual<br>Arguments:</td></tr>" + "<tr><td colspan=3><hr></td></tr>";
        for (int i = 0; i < Math.max(parameters.length, expressions.length); ++i) {
            PsiType type;
            String name;
            PsiParameter parameter = i < parameters.length ? parameters[i] : null;
            PsiExpression expression = i < expressions.length ? expressions[i] : null;
            boolean showShort = HighlightMethodUtil.showShortType(i, parameters, expressions, substitutor);
            String mismatchColor = showShort ? null : (UIUtil.isUnderDarcula() ? "FF6B68" : "red");
            s = s + "<tr" + (i % 2 == 0 ? " style='background-color: #" + (UIUtil.isUnderDarcula() ? ColorUtil.toHex(ColorUtil.shift(UIUtil.getToolTipBackground(), 1.1)) : "eeeeee") + "'" : "") + ">";
            s = s + "<td><b><nobr>";
            if (parameter != null && (name = parameter.getName()) != null) {
                s = s + HighlightMethodUtil.esctrim(name) + ":";
            }
            s = s + "</nobr></b></td>";
            s = s + "<td><b><nobr>";
            if (parameter != null) {
                type = substitutor.substitute(parameter.getType());
                s = s + "<font " + (mismatchColor == null ? "" : "color=" + mismatchColor) + ">" + HighlightMethodUtil.esctrim(showShort ? type.getPresentableText() : JavaHighlightUtil.formatType(type)) + "</font>";
            }
            s = s + "</nobr></b></td>";
            s = s + "<td><b><nobr>";
            if (expression != null) {
                type = expression.getType();
                s = s + "<font " + (mismatchColor == null ? "" : "color='" + mismatchColor + "'") + ">" + HighlightMethodUtil.esctrim(expression.getText()) + "&nbsp;&nbsp;" + (mismatchColor == null || type == null || type == PsiType.NULL ? "" : "(" + HighlightMethodUtil.esctrim(JavaHighlightUtil.formatType(type)) + ")") + "</font>";
            }
            s = s + "</nobr></b></td>";
            s = s + "</tr>";
        }
        s = s + "</table>";
        String errorMessage = InferenceSession.getInferenceErrorMessage(list.getParent());
        if (errorMessage != null) {
            s = s + "reason: ";
            s = s + XmlStringUtil.escapeString(errorMessage).replaceAll("\n", "<br/>");
        }
        s = s + "</body></html>";
        return s;
    }

    @Language(value="HTML")
    private static String createMismatchedArgsHtmlTooltipArgumentsRow(PsiExpression[] expressions, PsiParameter[] parameters, PsiSubstitutor substitutor, int cols) {
        int i;
        String ms = "";
        for (i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            PsiType type = expression.getType();
            boolean showShort = HighlightMethodUtil.showShortType(i, parameters, expressions, substitutor);
            String mismatchColor = showShort ? null : MISMATCH_COLOR;
            ms = ms + "<td> <b><nobr>" + (i == 0 ? "(" : "") + "<font " + (showShort ? "" : "color=" + mismatchColor) + ">" + XmlStringUtil.escapeString(showShort ? type.getPresentableText() : JavaHighlightUtil.formatType(type)) + "</font>" + (i == expressions.length - 1 ? ")" : ",") + "</nobr></b></td>";
        }
        for (i = expressions.length; i < cols + 1; ++i) {
            ms = ms + "<td>" + (i == 0 ? "<b>()</b>" : "") + "&nbsp;</td>";
        }
        return ms;
    }

    @Language(value="HTML")
    private static String createMismatchedArgsHtmlTooltipParamsRow(PsiParameter[] parameters, PsiSubstitutor substitutor, PsiExpression[] expressions) {
        String ms = "";
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType type = substitutor.substitute(parameter.getType());
            ms = ms + "<td><b><nobr>" + (i == 0 ? "(" : "") + XmlStringUtil.escapeString(HighlightMethodUtil.showShortType(i, parameters, expressions, substitutor) ? type.getPresentableText() : JavaHighlightUtil.formatType(type)) + (i == parameters.length - 1 ? ")" : ",") + "</nobr></b></td>";
        }
        return ms;
    }

    private static boolean showShortType(int i, PsiParameter[] parameters, PsiExpression[] expressions, PsiSubstitutor substitutor) {
        PsiExpression expression;
        PsiExpression psiExpression = expression = i < expressions.length ? expressions[i] : null;
        if (expression == null) {
            return true;
        }
        PsiType paramType = i < parameters.length && parameters[i] != null ? substitutor.substitute(parameters[i].getType()) : null;
        PsiType expressionType = expression.getType();
        return paramType != null && expressionType != null && TypeConversionUtil.isAssignable(paramType, expressionType);
    }

    static HighlightInfo checkMethodMustHaveBody(PsiMethod method, PsiClass aClass) {
        HighlightInfo errorResult = null;
        if (!(method.getBody() != null || method.hasModifierProperty("abstract") || method.hasModifierProperty("native") || aClass == null || aClass.isInterface() || PsiUtilCore.hasErrorElementChild(method))) {
            int start = method.getModifierList().getTextRange().getStartOffset();
            int end = method.getTextRange().getEndOffset();
            String description = JavaErrorMessages.message("missing.method.body", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description).create();
            if (HighlightUtil.getIncompatibleModifier("abstract", method.getModifierList()) == null) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(method, "abstract", true, false));
            }
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
        }
        return errorResult;
    }

    static HighlightInfo checkAbstractMethodInConcreteClass(PsiMethod method, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        PsiClass aClass = method.getContainingClass();
        if (method.hasModifierProperty("abstract") && aClass != null && !aClass.hasModifierProperty("abstract") && !aClass.isEnum() && !PsiUtilCore.hasErrorElementChild(method)) {
            String description = JavaErrorMessages.message("abstract.method.in.non.abstract.class", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            if (method.getBody() != null) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(method, "abstract", false, false));
            }
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(aClass, "abstract", true, false));
        }
        return errorResult;
    }

    static HighlightInfo checkConstructorName(PsiMethod method) {
        String methodName = method.getName();
        PsiClass aClass = method.getContainingClass();
        HighlightInfo errorResult = null;
        if (aClass != null) {
            String className;
            String string = className = aClass instanceof PsiAnonymousClass ? null : aClass.getName();
            if (className == null || !Comparing.strEqual(methodName, className)) {
                PsiIdentifier element = method.getNameIdentifier();
                String description = JavaErrorMessages.message("missing.return.type", new Object[0]);
                errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
                if (className != null) {
                    QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createRenameElementFix(method, className));
                }
            }
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkDuplicateMethod(PsiClass aClass, @NotNull PsiMethod method, @NotNull MostlySingularMultiMap<MethodSignature, PsiMethod> duplicateMethods) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkDuplicateMethod"));
        }
        if (duplicateMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicateMethods", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkDuplicateMethod"));
        }
        if (aClass == null || method instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        int methodCount = 1;
        List methods = (List)duplicateMethods.get(methodSignature);
        if (methods.size() > 1) {
            ++methodCount;
        }
        if (methodCount == 1 && aClass.isEnum() && GenericsHighlightUtil.isEnumSyntheticMethod(methodSignature, aClass.getProject())) {
            ++methodCount;
        }
        if (methodCount > 1) {
            String description = JavaErrorMessages.message("duplicate.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass));
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(method, textRange.getStartOffset(), textRange.getEndOffset()).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkMethodCanHaveBody(@NotNull PsiMethod method, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCanHaveBody"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkMethodCanHaveBody"));
        }
        PsiClass aClass = method.getContainingClass();
        boolean hasNoBody = method.getBody() == null;
        boolean isInterface = aClass != null && aClass.isInterface();
        boolean isExtension = method.hasModifierProperty("default");
        boolean isStatic = method.hasModifierProperty("static");
        boolean isPrivate = method.hasModifierProperty("private");
        ArrayList<IntentionAction> additionalFixes = new ArrayList<IntentionAction>();
        String description = null;
        if (hasNoBody) {
            if (isExtension) {
                description = JavaErrorMessages.message("extension.method.should.have.a.body", new Object[0]);
                additionalFixes.add(QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            } else if (isInterface && isStatic && languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                description = "Static methods in interfaces should have a body";
            }
        } else if (isInterface) {
            if (!(isExtension || isStatic || isPrivate)) {
                description = JavaErrorMessages.message("interface.methods.cannot.have.body", new Object[0]);
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix(method, "default", true, false));
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix(method, "static", true, false));
                }
            }
        } else if (isExtension) {
            description = JavaErrorMessages.message("extension.method.in.class", new Object[0]);
        } else if (method.hasModifierProperty("abstract")) {
            description = JavaErrorMessages.message("abstract.methods.cannot.have.a.body", new Object[0]);
        } else if (method.hasModifierProperty("native")) {
            description = JavaErrorMessages.message("native.methods.cannot.have.a.body", new Object[0]);
        }
        if (description == null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        if (!hasNoBody) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createDeleteMethodBodyFix(method));
        }
        if (method.hasModifierProperty("abstract") && !isInterface) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(method, "abstract", false, false));
        }
        for (IntentionAction intentionAction : additionalFixes) {
            QuickFixAction.registerQuickFixAction(info, intentionAction);
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkConstructorCallMustBeFirstStatement(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCallMustBeFirstStatement"));
        }
        if (!RefactoringChangeUtil.isSuperOrThisMethodCall(methodCall)) {
            return null;
        }
        PsiElement codeBlock = methodCall.getParent().getParent();
        if (codeBlock instanceof PsiCodeBlock && codeBlock.getParent() instanceof PsiMethod && ((PsiMethod)codeBlock.getParent()).isConstructor()) {
            PsiElement prevSibling = methodCall.getParent().getPrevSibling();
            while (true) {
                if (prevSibling == null) {
                    return null;
                }
                if (prevSibling instanceof PsiStatement) break;
                prevSibling = prevSibling.getPrevSibling();
            }
        }
        PsiReferenceExpression expression = methodCall.getMethodExpression();
        String message = JavaErrorMessages.message("constructor.call.must.be.first.statement", expression.getText() + "()");
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(methodCall).descriptionAndTooltip(message).create();
    }

    static HighlightInfo checkSuperAbstractMethodDirectCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkSuperAbstractMethodDirectCall"));
        }
        PsiReferenceExpression expression = methodCallExpression.getMethodExpression();
        if (!(expression.getQualifierExpression() instanceof PsiSuperExpression)) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method != null && method.hasModifierProperty("abstract")) {
            String message = JavaErrorMessages.message("direct.abstract.method.access", JavaHighlightUtil.formatMethod(method));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(methodCallExpression).descriptionAndTooltip(message).create();
        }
        return null;
    }

    static HighlightInfo checkConstructorCallsBaseClassConstructor(PsiMethod constructor, RefCountHolder refCountHolder, PsiResolveHelper resolveHelper) {
        PsiClassType[] handledExceptions;
        if (!constructor.isConstructor()) {
            return null;
        }
        PsiClass aClass = constructor.getContainingClass();
        if (aClass == null) {
            return null;
        }
        if (aClass.isEnum()) {
            return null;
        }
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return null;
        }
        PsiElement element = new PsiMatcherImpl(body).firstChild(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).getElement();
        if (element != null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(constructor);
        HighlightInfo info = HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, handledExceptions = constructor.getThrowsList().getReferencedTypes());
        if (info != null) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createInsertSuperFix(constructor));
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddDefaultConstructorFix(aClass.getSuperClass()));
        }
        return info;
    }

    static HighlightInfo checkStaticMethodOverride(@NotNull PsiMethod method, @NotNull PsiFile containingFile) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkStaticMethodOverride"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkStaticMethodOverride"));
        }
        if (method.isConstructor()) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        HierarchicalMethodSignature methodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(method);
        List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
        if (superSignatures.isEmpty()) {
            return null;
        }
        boolean isStatic = method.hasModifierProperty("static");
        for (HierarchicalMethodSignature signature : superSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod superMethod = signature.getMethod();
            PsiClass superClass = superMethod.getContainingClass();
            if (superClass == null || (highlightInfo = HighlightMethodUtil.checkStaticMethodOverride(aClass, method, isStatic, superClass, superMethod, containingFile)) == null) continue;
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkStaticMethodOverride(PsiClass aClass, PsiMethod method, boolean isMethodStatic, PsiClass superClass, PsiMethod superMethod, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkStaticMethodOverride"));
        }
        if (superMethod == null) {
            return null;
        }
        PsiManager manager = containingFile.getManager();
        PsiModifierList superModifierList = superMethod.getModifierList();
        PsiModifierList modifierList = method.getModifierList();
        if (superModifierList.hasModifierProperty("private")) {
            return null;
        }
        if (superModifierList.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance(manager.getProject()).arePackagesTheSame(aClass, superClass)) {
            return null;
        }
        boolean isSuperMethodStatic = superModifierList.hasModifierProperty("static");
        if (isMethodStatic != isSuperMethodStatic) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String messageKey = isMethodStatic ? "static.method.cannot.override.instance.method" : "instance.method.cannot.override.static.method";
            String description = JavaErrorMessages.message(messageKey, JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superClass));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            if (!isSuperMethodStatic || HighlightUtil.getIncompatibleModifier("static", modifierList) == null) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(method, "static", isSuperMethodStatic, false));
            }
            if (manager.isInProject(superMethod) && (!isMethodStatic || HighlightUtil.getIncompatibleModifier("static", superModifierList) == null)) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(superMethod, "static", isMethodStatic, true));
            }
            return info;
        }
        if (isMethodStatic) {
            if (superClass.isInterface()) {
                return null;
            }
            int accessLevel = PsiUtil.getAccessLevel(modifierList);
            String accessModifier = PsiUtil.getAccessModifier(accessLevel);
            HighlightInfo info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, true);
            if (info != null) {
                return info;
            }
            info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    private static HighlightInfo checkInterfaceInheritedMethodsReturnTypes(@NotNull List<? extends MethodSignatureBackedByPsiMethod> superMethodSignatures, @NotNull LanguageLevel languageLevel) {
        if (superMethodSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignatures", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkInterfaceInheritedMethodsReturnTypes"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkInterfaceInheritedMethodsReturnTypes"));
        }
        if (superMethodSignatures.size() < 2) {
            return null;
        }
        MethodSignatureBackedByPsiMethod returnTypeSubstitutable = superMethodSignatures.get(0);
        for (int i = 1; i < superMethodSignatures.size(); ++i) {
            PsiMethod currentMethod = returnTypeSubstitutable.getMethod();
            PsiType currentType = returnTypeSubstitutable.getSubstitutor().substitute(currentMethod.getReturnType());
            MethodSignatureBackedByPsiMethod otherSuperSignature = superMethodSignatures.get(i);
            PsiMethod otherSuperMethod = otherSuperSignature.getMethod();
            PsiType otherSuperReturnType = otherSuperSignature.getSubstitutor().substitute(otherSuperMethod.getReturnType());
            PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(returnTypeSubstitutable, otherSuperSignature);
            if (unifyingSubstitutor != null) {
                otherSuperReturnType = unifyingSubstitutor.substitute(otherSuperReturnType);
                currentType = unifyingSubstitutor.substitute(currentType);
            }
            if (otherSuperReturnType == null || currentType == null || otherSuperReturnType.equals(currentType)) continue;
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                if (!(otherSuperReturnType instanceof PsiPrimitiveType) && !(currentType instanceof PsiPrimitiveType)) {
                    if (otherSuperReturnType.isAssignableFrom(currentType)) continue;
                    if (currentType.isAssignableFrom(otherSuperReturnType)) {
                        returnTypeSubstitutable = otherSuperSignature;
                        continue;
                    }
                }
                if (currentMethod.getTypeParameters().length > 0 && JavaGenericsUtil.isRawToGeneric(currentType, otherSuperReturnType)) continue;
            }
            return HighlightMethodUtil.createIncompatibleReturnTypeMessage(currentMethod, otherSuperMethod, otherSuperReturnType, currentType, JavaErrorMessages.message("unrelated.overriding.methods.return.types", new Object[0]), TextRange.EMPTY_RANGE);
        }
        return null;
    }

    static HighlightInfo checkOverrideEquivalentInheritedMethods(PsiClass aClass, PsiFile containingFile, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkOverrideEquivalentInheritedMethods"));
        }
        String description = null;
        Collection<HierarchicalMethodSignature> visibleSignatures = aClass.getVisibleSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(aClass.getProject()).getResolveHelper();
        block0: for (HierarchicalMethodSignature signature : visibleSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod method = signature.getMethod();
            if (!resolveHelper.isAccessible(method, aClass, null)) continue;
            List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            boolean allAbstracts = method.hasModifierProperty("abstract");
            PsiClass containingClass = method.getContainingClass();
            if (aClass.equals(containingClass) || aClass.isInterface() && !containingClass.isInterface()) continue;
            if (allAbstracts) {
                superSignatures = new ArrayList<HierarchicalMethodSignature>(superSignatures);
                superSignatures.add(signature);
                highlightInfo = HighlightMethodUtil.checkInterfaceInheritedMethodsReturnTypes(superSignatures, languageLevel);
            } else {
                highlightInfo = HighlightMethodUtil.checkMethodIncompatibleReturnType(signature, superSignatures, false);
            }
            if (highlightInfo != null) {
                description = highlightInfo.getDescription();
            }
            if (method.hasModifierProperty("static")) {
                for (HierarchicalMethodSignature superSignature : superSignatures) {
                    PsiMethod superMethod = superSignature.getMethod();
                    if (superMethod.hasModifierProperty("static")) continue;
                    description = JavaErrorMessages.message("static.method.cannot.override.instance.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(containingClass), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superMethod.getContainingClass()));
                    break block0;
                }
                continue;
            }
            if (description == null && (highlightInfo = HighlightMethodUtil.checkMethodIncompatibleThrows(signature, superSignatures, false, aClass)) != null) {
                description = highlightInfo.getDescription();
            }
            if (description == null && (highlightInfo = HighlightMethodUtil.checkMethodWeakerPrivileges(signature, superSignatures, false, containingFile)) != null) {
                description = highlightInfo.getDescription();
            }
            if (description == null) continue;
            break;
        }
        if (description != null) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkConstructorHandleSuperClassExceptions(PsiMethod method) {
        PsiStatement[] statements;
        if (!method.isConstructor()) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        PsiStatement[] psiStatementArray = statements = body == null ? null : body.getStatements();
        if (statements == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions(method, method.getContainingClass());
        if (unhandled.isEmpty()) {
            return null;
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled);
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        for (PsiClassType exception : unhandled) {
            QuickFixAction.registerQuickFixAction(highlightInfo, new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, true, false)));
        }
        return highlightInfo;
    }

    static HighlightInfo checkRecursiveConstructorInvocation(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkRecursiveConstructorInvocation"));
        }
        if (HighlightControlFlowUtil.isRecursivelyCalledConstructor(method)) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String description = JavaErrorMessages.message("recursive.constructor.invocation", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @NotNull
    public static TextRange getFixRange(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "getFixRange"));
        }
        TextRange range = element.getTextRange();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        PsiElement nextSibling = element.getNextSibling();
        if (nextSibling instanceof PsiJavaToken && ((PsiJavaToken)nextSibling).getTokenType() == JavaTokenType.SEMICOLON) {
            TextRange textRange = new TextRange(start, end + 1);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "getFixRange"));
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "getFixRange"));
        }
        return textRange;
    }

    static void checkNewExpression(@NotNull PsiNewExpression expression, PsiType type, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkNewExpression"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkNewExpression"));
        }
        if (javaSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdkVersion", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkNewExpression"));
        }
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
        PsiClass aClass = typeResult.getElement();
        if (aClass == null) {
            return;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = (typeResult = ((PsiClassType)(type = ((PsiAnonymousClass)aClass).getBaseClassType())).resolveGenerics()).getElement()) == null) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        HighlightMethodUtil.checkConstructorCall(typeResult, expression, type, classReference, holder, javaSdkVersion);
    }

    static void checkConstructorCall(@NotNull PsiClassType.ClassResolveResult typeResolveResult, @NotNull PsiConstructorCall constructorCall, @NotNull PsiType type, PsiJavaCodeReferenceElement classReference, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        PsiExpression qualifier;
        if (typeResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolveResult", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCall"));
        }
        if (constructorCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCall"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCall"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCall"));
        }
        if (javaSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdkVersion", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "checkConstructorCall"));
        }
        PsiExpressionList list = constructorCall.getArgumentList();
        if (list == null) {
            return;
        }
        PsiClass aClass = typeResolveResult.getElement();
        if (aClass == null) {
            return;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(holder.getProject()).getResolveHelper();
        PsiClass accessObjectClass = null;
        if (constructorCall instanceof PsiNewExpression && (qualifier = ((PsiNewExpression)constructorCall).getQualifier()) != null) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass(qualifier).getElement();
        }
        if (classReference != null && !resolveHelper.isAccessible(aClass, constructorCall, accessObjectClass)) {
            String description = HighlightUtil.buildProblemWithAccessDescription(classReference, typeResolveResult);
            PsiElement element = classReference.getReferenceNameElement();
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            HighlightUtil.registerAccessQuickFixAction(aClass, classReference, info, null);
            holder.add(info);
            return;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            PsiReferenceParameterList typeArgumentList;
            if (list.getExpressions().length != 0) {
                String constructorName = aClass.getName();
                String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorMessages.message("wrong.constructor.arguments", constructorName + "()", argTypes);
                String tooltip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list, PsiParameter.EMPTY_ARRAY, constructorName, PsiSubstitutor.EMPTY, aClass);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list).description(description).escapedToolTip(tooltip).navigationShift(1).create();
                QuickFixAction.registerQuickFixAction(info, constructorCall.getTextRange(), QUICK_FIX_FACTORY.createCreateConstructorFromCallFix(constructorCall));
                if (classReference != null) {
                    ConstructorParametersFixer.registerFixActions(classReference, constructorCall, info, HighlightMethodUtil.getFixRange(list));
                }
                holder.add(info);
                return;
            }
            if (classReference != null && aClass.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass)) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference, typeResolveResult, aClass));
            } else if (aClass.isInterface() && constructorCall instanceof PsiNewExpression && (typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList()).getTypeArguments().length > 0) {
                holder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeArgumentList).descriptionAndTooltip("Anonymous class implements interface; cannot have type arguments").create());
            }
        } else {
            PsiReferenceParameterList typeArgumentList;
            HighlightInfo info;
            PsiElement infoElement;
            PsiAnonymousClass anonymousClass;
            PsiElement place = list;
            if (constructorCall instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)constructorCall).getAnonymousClass()) != null) {
                place = anonymousClass;
            }
            JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type, list, place);
            MethodCandidateInfo result = null;
            if (results.length == 1) {
                result = (MethodCandidateInfo)results[0];
            }
            PsiMethod constructor = result == null ? null : result.getElement();
            boolean applicable = true;
            try {
                applicable = constructor != null && result.isApplicable();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            PsiElement psiElement = infoElement = list.getTextLength() > 0 ? list : constructorCall;
            if (constructor == null) {
                String name = aClass.getName();
                name = name + HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorMessages.message("cannot.resolve.constructor", name);
                HighlightInfo info2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list).descriptionAndTooltip(description).navigationShift(1).create();
                WrapExpressionFix.registerWrapAction(results, list.getExpressions(), info2);
                HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference, list, aClass, constructors, results, infoElement, info2);
                holder.add(info2);
            } else if (classReference != null && (!result.isAccessible() || constructor.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass))) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference, result, constructor));
            } else if (!applicable) {
                String constructorName = HighlightMessageUtil.getSymbolName(constructor, result.getSubstitutor());
                String containerName = HighlightMessageUtil.getSymbolName(constructor.getContainingClass(), result.getSubstitutor());
                String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorMessages.message("wrong.method.arguments", constructorName, containerName, argTypes);
                String toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(result, list);
                HighlightInfo info3 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(infoElement).description(description).escapedToolTip(toolTip).navigationShift(1).create();
                if (info3 != null) {
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference, list, aClass, constructors, results, infoElement, info3);
                    HighlightMethodUtil.registerMethodReturnFixAction(info3, result, constructorCall);
                    holder.add(info3);
                }
            } else if (constructorCall instanceof PsiNewExpression && (info = GenericsHighlightUtil.checkReferenceTypeArgumentList(constructor, typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList(), result.getSubstitutor(), false, javaSdkVersion)) != null) {
                holder.add(info);
            }
            if (result != null && !holder.hasErrorResults()) {
                holder.add(HighlightMethodUtil.checkVarargParameterErasureToBeAccessible(result, constructorCall));
            }
        }
    }

    private static HighlightInfo checkVarargParameterErasureToBeAccessible(MethodCandidateInfo info, PsiCall place) {
        PsiMethod method = info.getElement();
        if (info.isVarargs() || method.isVarArgs() && !PsiUtil.isLanguageLevel8OrHigher(place)) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiType componentType = ((PsiEllipsisType)parameters[parameters.length - 1].getType()).getComponentType();
            PsiType substitutedTypeErasure = TypeConversionUtil.erasure(info.getSubstitutor().substitute(componentType));
            PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly(substitutedTypeErasure);
            if (targetClass != null && !PsiUtil.isAccessible(targetClass, place, null)) {
                PsiExpressionList argumentList = place.getArgumentList();
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Formal varargs element type " + PsiFormatUtil.formatClass(targetClass, 2048) + " is inaccessible here").range(argumentList != null ? argumentList : place).create();
            }
        }
        return null;
    }

    private static void registerFixesOnInvalidConstructorCall(PsiConstructorCall constructorCall, PsiJavaCodeReferenceElement classReference, PsiExpressionList list, PsiClass aClass, PsiMethod[] constructors, JavaResolveResult[] results, PsiElement infoElement, HighlightInfo info) {
        QuickFixAction.registerQuickFixAction(info, constructorCall.getTextRange(), QUICK_FIX_FACTORY.createCreateConstructorFromCallFix(constructorCall));
        if (classReference != null) {
            ConstructorParametersFixer.registerFixActions(classReference, constructorCall, info, HighlightMethodUtil.getFixRange(infoElement));
            ChangeTypeArgumentsFix.registerIntentions(results, list, info, aClass);
            ConvertDoubleToFloatFix.registerIntentions(results, list, info, null);
        }
        HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions(results, list, info, null);
        PermuteArgumentsFix.registerFix(info, constructorCall, HighlightMethodUtil.toMethodCandidates(results), HighlightMethodUtil.getFixRange(list));
        HighlightMethodUtil.registerChangeParameterClassFix(constructorCall, list, info);
        QuickFixAction.registerQuickFixAction(info, HighlightMethodUtil.getFixRange(list), QUICK_FIX_FACTORY.createSurroundWithArrayFix(constructorCall, null));
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(constructors, constructorCall, info);
    }

    private static HighlightInfo buildAccessProblem(@NotNull PsiJavaCodeReferenceElement classReference, JavaResolveResult result, PsiMember elementToFix) {
        if (classReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classReference", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "buildAccessProblem"));
        }
        String description = HighlightUtil.buildProblemWithAccessDescription(classReference, result);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(classReference).descriptionAndTooltip(description).navigationShift(1).create();
        if (result.isStaticsScopeCorrect()) {
            HighlightUtil.registerAccessQuickFixAction(elementToFix, classReference, info, result.getCurrentFileResolveScope());
        }
        return info;
    }

    private static boolean callingProtectedConstructorFromDerivedClass(PsiConstructorCall place, PsiClass constructorClass) {
        PsiClass aClass;
        if (constructorClass == null) {
            return false;
        }
        if (place instanceof PsiNewExpression && ((PsiNewExpression)place).getAnonymousClass() != null) {
            return false;
        }
        PsiElement curElement = place;
        PsiClass containingClass = constructorClass.getContainingClass();
        do {
            if ((aClass = PsiTreeUtil.getParentOfType(curElement, PsiClass.class)) == null) {
                return false;
            }
            curElement = aClass;
        } while (!aClass.isInheritor(constructorClass, true) && (containingClass == null || !aClass.isInheritor(containingClass, true)) || JavaPsiFacade.getInstance(aClass.getProject()).arePackagesTheSame(aClass, constructorClass));
        return true;
    }

    private static String buildArgTypesList(PsiExpressionList list) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        PsiExpression[] args = list.getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = args[i].getType()) != null ? JavaHighlightUtil.formatType(argType) : "?");
        }
        builder.append(")");
        return builder.toString();
    }

    private static void registerChangeParameterClassFix(@NotNull PsiCall methodCall, @NotNull PsiExpressionList list, HighlightInfo highlightInfo) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeParameterClassFix"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeParameterClassFix"));
        }
        JavaResolveResult result = methodCall.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions = list.getExpressions();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != expressions.length) {
            return;
        }
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            PsiParameter parameter = parameters[i];
            PsiType expressionType = expression.getType();
            PsiType parameterType = substitutor.substitute(parameter.getType());
            if (expressionType == null || expressionType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType(expressionType) || expressionType instanceof PsiArrayType || parameterType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType(parameterType) || parameterType instanceof PsiArrayType || parameterType.isAssignableFrom(expressionType)) continue;
            PsiClass parameterClass = PsiUtil.resolveClassInType(parameterType);
            PsiClass expressionClass = PsiUtil.resolveClassInType(expressionType);
            if (parameterClass == null || expressionClass == null || expressionClass instanceof PsiAnonymousClass || parameterClass.isInheritor(expressionClass, true)) continue;
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createChangeParameterClassFix(expressionClass, (PsiClassType)parameterType));
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeMethodSignatureFromUsageIntentions"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeMethodSignatureFromUsageIntentions"));
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntention(expressions, highlightInfo, fixRange, candidate, list);
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntention(@NotNull PsiExpression[] expressions, @Nullable HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeMethodSignatureFromUsageIntention"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeMethodSignatureFromUsageIntention"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil", "registerChangeMethodSignatureFromUsageIntention"));
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (method != null && context.getManager().isInProject(method)) {
            IntentionAction fix = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageFix(method, expressions, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, fix);
            IntentionAction f2 = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageReverseOrderFix(method, expressions, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, f2);
        }
    }
}

