/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import org.jetbrains.annotations.NotNull;

public class FinalPrivateMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("final.private.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/FinalPrivateMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("final.private.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/FinalPrivateMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinalPrivateMethodVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    private static class FinalPrivateMethodVisitor
    extends BaseInspectionVisitor {
        private FinalPrivateMethodVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/FinalPrivateMethodInspection$FinalPrivateMethodVisitor", "visitMethod"));
            }
            if (!method.hasModifierProperty("final") || !method.hasModifierProperty("private")) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "java.lang.SafeVarargs", false) && method.isVarArgs()) {
                return;
            }
            this.registerModifierError("final", method, "final");
        }
    }
}

