/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryQualifierForThisInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryQualifierForThisVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryQualifierForThisFix();
    }

    private static class UnnecessaryQualifierForThisVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryQualifierForThisVisitor() {
        }

        @Override
        public void visitThisExpression(@NotNull PsiThisExpression thisExpression) {
            if (thisExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisExpression", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisVisitor", "visitThisExpression"));
            }
            super.visitThisExpression(thisExpression);
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement referent = qualifier.resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass(thisExpression);
            if (containingClass == null) {
                return;
            }
            if (!containingClass.equals(referent)) {
                return;
            }
            this.registerError((PsiElement)qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }
    }

    private static class UnnecessaryQualifierForThisFix
    extends InspectionGadgetsFix {
        private UnnecessaryQualifierForThisFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement qualifier = descriptor.getPsiElement();
            PsiThisExpression thisExpression = (PsiThisExpression)qualifier.getParent();
            PsiReplacementUtil.replaceExpression(thisExpression, "this");
        }
    }
}

