/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.GeneralPath;
import java.lang.reflect.Field;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jetbrains.annotations.NotNull;

public class MacUIUtil {
    public static final boolean USE_QUARTZ = "true".equals(System.getProperty("apple.awt.graphics.UseQuartz"));
    public static final String MAC_FILL_BORDER = "MAC_FILL_BORDER";
    public static final int MAC_COMBO_BORDER_V_OFFSET = SystemInfo.isMacOSLion ? 1 : 0;
    private static Cursor INVERTED_TEXT_CURSOR;

    private MacUIUtil() {
    }

    public static void paintFocusRing(Graphics2D g2d, Color ringColor, Rectangle bounds) {
        MacUIUtil.paintFocusRing(g2d, ringColor, bounds, false);
    }

    public static void paintFocusRing(Graphics2D g, Color ringColor, Rectangle bounds, boolean oval) {
        int correction = UIUtil.isUnderDarcula() ? 50 : 0;
        Color[] colors = new Color[]{ColorUtil.toAlpha(ringColor, 180 - correction), ColorUtil.toAlpha(ringColor, 120 - correction), ColorUtil.toAlpha(ringColor, 70 - correction), ColorUtil.toAlpha(ringColor, 100 - correction), ColorUtil.toAlpha(ringColor, 50 - correction)};
        Object oldAntialiasingValue = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldStrokeControlValue = g.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, !oval && USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        Rectangle r = new Rectangle(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6);
        g.setColor(colors[0]);
        MacUIUtil.drawRectOrOval(g, oval, 5, r.x + 2, r.y + 2, r.width - 5, r.height - 5);
        g.setColor(colors[1]);
        MacUIUtil.drawRectOrOval(g, oval, 7, r.x + 1, r.y + 1, r.width - 3, r.height - 3);
        g.setColor(colors[2]);
        MacUIUtil.drawRectOrOval(g, oval, 9, r.x, r.y, r.width - 1, r.height - 1);
        g.setColor(colors[3]);
        MacUIUtil.drawRectOrOval(g, oval, 0, r.x + 3, r.y + 3, r.width - 7, r.height - 7);
        g.setColor(colors[4]);
        MacUIUtil.drawRectOrOval(g, oval, 0, r.x + 4, r.y + 4, r.width - 9, r.height - 9);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasingValue);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeControlValue);
    }

    private static void drawRectOrOval(Graphics2D g, boolean oval, int arc, int x, int y, int width, int height) {
        if (oval) {
            g.drawOval(x, y, width, height);
        } else if (arc == 0) {
            g.drawRect(x, y, width, height);
        } else {
            g.drawRoundRect(x, y, width, height, arc, arc);
        }
    }

    public static void hideCursor() {
        if (SystemInfo.isMac && Registry.is("ide.mac.hide.cursor.when.typing")) {
            Foundation.invoke("NSCursor", "setHiddenUntilMouseMoves:", true);
        }
    }

    public static void drawToolbarDecoratorBackground(Graphics g2, int width, int height) {
        Graphics2D g = (Graphics2D)g2;
        int h1 = height / 2;
        g.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray._247, 0.0f, h1, Gray._240));
        g.fillRect(0, 0, width, h1);
        g.setPaint(UIUtil.getGradientPaint(0.0f, h1, Gray._229, 0.0f, height, Gray._234));
        g.fillRect(0, h1, width, height);
    }

    public static Color getFocusRingColor() {
        Object o = UIManager.get("Focus.color");
        if (o instanceof Color) {
            return (Color)o;
        }
        return new Color(64, 113, 167);
    }

    public static void paintTextFieldFocusRing(@NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        if (g2d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/intellij/util/ui/MacUIUtil", "paintTextFieldFocusRing"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/util/ui/MacUIUtil", "paintTextFieldFocusRing"));
        }
        MacUIUtil.paintFocusRing(g2d, MacUIUtil.getFocusRingColor(), bounds);
    }

    public static void paintComboboxFocusRing(@NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        if (g2d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/intellij/util/ui/MacUIUtil", "paintComboboxFocusRing"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/util/ui/MacUIUtil", "paintComboboxFocusRing"));
        }
        Color color = MacUIUtil.getFocusRingColor();
        Color[] colors = new Color[]{ColorUtil.toAlpha(color, 180), ColorUtil.toAlpha(color, 130), ColorUtil.toAlpha(color, 80), ColorUtil.toAlpha(color, 80)};
        Object oldAntialiasingValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldStrokeControlValue = g2d.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        int _y = MAC_COMBO_BORDER_V_OFFSET;
        GeneralPath path1 = new GeneralPath();
        path1.moveTo(2.0f, _y + 4);
        path1.quadTo(2.0f, _y + 2, 4.0f, _y + 2);
        path1.lineTo(bounds.width - 7, _y + 2);
        path1.quadTo(bounds.width - 5, _y + 3, bounds.width - 4, _y + 5);
        path1.lineTo(bounds.width - 4, bounds.height - 7 + _y);
        path1.quadTo(bounds.width - 5, bounds.height - 5 + _y, bounds.width - 7, bounds.height - 4 + _y);
        path1.lineTo(4.0f, bounds.height - 4 + _y);
        path1.quadTo(2.0f, bounds.height - 4 + _y, 2.0f, bounds.height - 6 + _y);
        path1.closePath();
        g2d.setColor(colors[0]);
        g2d.draw(path1);
        GeneralPath path2 = new GeneralPath();
        path2.moveTo(1.0f, 5 + _y);
        path2.quadTo(1.0f, 1 + _y, 5.0f, 1 + _y);
        path2.lineTo(bounds.width - 8, 1 + _y);
        path2.quadTo(bounds.width - 4, 2 + _y, bounds.width - 3, 6 + _y);
        path2.lineTo(bounds.width - 3, bounds.height - 7 + _y);
        path2.quadTo(bounds.width - 4, bounds.height - 4 + _y, bounds.width - 8, bounds.height - 3 + _y);
        path2.lineTo(4.0f, bounds.height - 3 + _y);
        path2.quadTo(1.0f, bounds.height - 3 + _y, 1.0f, bounds.height - 6 + _y);
        path2.closePath();
        g2d.setColor(colors[1]);
        g2d.draw(path2);
        GeneralPath path3 = new GeneralPath();
        path3.moveTo(0.0f, 4 + _y);
        path3.quadTo(0.0f, _y, 7.0f, _y);
        path3.lineTo(bounds.width - 9, _y);
        path3.quadTo(bounds.width - 2, 1 + _y, bounds.width - 2, 7 + _y);
        path3.lineTo(bounds.width - 2, bounds.height - 8 + _y);
        path3.quadTo(bounds.width - 3, bounds.height - 1 + _y, bounds.width - 12, bounds.height - 2 + _y);
        path3.lineTo(7.0f, bounds.height - 2 + _y);
        path3.quadTo(0.0f, bounds.height - 1 + _y, 0.0f, bounds.height - 7 + _y);
        path3.closePath();
        g2d.setColor(colors[2]);
        g2d.draw(path3);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasingValue);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeControlValue);
    }

    public static void drawComboboxFocusRing(@NotNull JComboBox combobox, @NotNull Graphics g) {
        Container ancestor;
        Component focusOwner;
        if (combobox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "combobox", "com/intellij/util/ui/MacUIUtil", "drawComboboxFocusRing"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/util/ui/MacUIUtil", "drawComboboxFocusRing"));
        }
        if (SystemInfo.isMac && combobox.isEnabled() && combobox.isEditable() && UIUtil.isUnderAquaLookAndFeel() && (focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && (ancestor = SwingUtilities.getAncestorOfClass(JComboBox.class, focusOwner)) == combobox) {
            MacUIUtil.paintComboboxFocusRing((Graphics2D)g, combobox.getBounds());
        }
    }

    public static void doNotFillBackground(@NotNull JTree tree, @NotNull DefaultTreeCellRenderer renderer) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/ui/MacUIUtil", "doNotFillBackground"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/util/ui/MacUIUtil", "doNotFillBackground"));
        }
        TreeUI ui = tree.getUI();
        if (ui instanceof WideSelectionTreeUI && ((WideSelectionTreeUI)ui).isWideSelection()) {
            renderer.setOpaque(false);
            try {
                Field fillBackground = DefaultTreeCellRenderer.class.getDeclaredField("fillBackground");
                fillBackground.setAccessible(true);
                fillBackground.set(renderer, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Cursor getInvertedTextCursor() {
        if (INVERTED_TEXT_CURSOR == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image cursorImage = toolkit.createImage(MacUIUtil.class.getClassLoader().getResource("/mac/text.gif"));
            INVERTED_TEXT_CURSOR = toolkit.createCustomCursor(cursorImage, new Point(15, 13), "InvertedTextCursor");
        }
        return INVERTED_TEXT_CURSOR;
    }

    public static class EditorTextFieldBorder
    implements Border {
        private JComponent myEnabledComponent;

        public EditorTextFieldBorder(JComponent enabledComponent) {
            this.myEnabledComponent = enabledComponent;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int x1 = x + 3;
            int y1 = y + 3;
            int width1 = width - 8;
            int height1 = height - 6;
            if (c.isOpaque() || c instanceof JComponent && ((JComponent)c).getClientProperty(MacUIUtil.MAC_FILL_BORDER) == Boolean.TRUE) {
                g.setColor(UIUtil.getPanelBackground());
                g.fillRect(x, y, width, height);
            }
            g.setColor(c.getBackground());
            g.fillRect(x1, y1, width1, height1);
            if (!this.myEnabledComponent.isEnabled()) {
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.4f));
            }
            g.setColor(new Color(100, 100, 100, 200));
            g.drawRect(x1, y1, width1 - 1, height1 - 1);
            g.setColor(Gray._225);
            g.drawRect(x1 + 1, y1 + 1, width1 - 3, height1 - 3);
            if (this.myEnabledComponent.isEnabled() && this.myEnabledComponent.isVisible() && EditorTextFieldBorder.hasFocus(this.myEnabledComponent)) {
                MacUIUtil.paintTextFieldFocusRing((Graphics2D)g, new Rectangle(x1, y1, width1, height1));
            }
        }

        private static boolean hasFocus(@NotNull Component toCheck) {
            if (toCheck == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCheck", "com/intellij/util/ui/MacUIUtil$EditorTextFieldBorder", "hasFocus"));
            }
            if (toCheck.hasFocus()) {
                return true;
            }
            if (toCheck instanceof JComponent) {
                JComponent c = (JComponent)toCheck;
                for (int i = 0; i < c.getComponentCount(); ++i) {
                    boolean b = EditorTextFieldBorder.hasFocus(c.getComponent(i));
                    if (!b) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(6, 7, 6, 7);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

