/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.BundleBase;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemsHolder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.ProblemsHolder");
    private final InspectionManager myManager;
    private final PsiFile myFile;
    private final boolean myOnTheFly;
    private final List<ProblemDescriptor> myProblems;

    public ProblemsHolder(@NotNull InspectionManager manager, @NotNull PsiFile file, boolean onTheFly) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/ProblemsHolder", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ProblemsHolder", "<init>"));
        }
        this.myProblems = new ArrayList<ProblemDescriptor>();
        this.myManager = manager;
        this.myFile = file;
        this.myOnTheFly = onTheFly;
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String descriptionTemplate, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTemplate", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        this.registerProblem(psiElement, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String descriptionTemplate, @NotNull ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTemplate", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        if (highlightType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightType", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        this.registerProblem(this.myManager.createProblemDescriptor(psiElement, descriptionTemplate, this.myOnTheFly, fixes, highlightType));
    }

    public void registerProblem(@NotNull ProblemDescriptor problemDescriptor) {
        PsiElement newTarget;
        ExternallyDefinedPsiElement external;
        if (problemDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        PsiElement element = problemDescriptor.getPsiElement();
        if (element != null && !this.isInPsiFile(element) && (external = PsiTreeUtil.getParentOfType(element, ExternallyDefinedPsiElement.class, false)) != null && (newTarget = external.getProblemTarget()) != null) {
            this.redirectProblem(problemDescriptor, newTarget);
            return;
        }
        this.myProblems.add(problemDescriptor);
    }

    private boolean isInPsiFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ProblemsHolder", "isInPsiFile"));
        }
        PsiFile file = element.getContainingFile();
        return this.myFile.getViewProvider() == file.getViewProvider();
    }

    private void redirectProblem(@NotNull ProblemDescriptor problem, @NotNull PsiElement target) {
        if (problem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "com/intellij/codeInspection/ProblemsHolder", "redirectProblem"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInspection/ProblemsHolder", "redirectProblem"));
        }
        PsiElement original = problem.getPsiElement();
        VirtualFile vFile = original.getContainingFile().getVirtualFile();
        assert (vFile != null);
        String path = FileUtil.toSystemIndependentName(vFile.getPath());
        String description = XmlStringUtil.stripHtml(problem.getDescriptionTemplate());
        String template = InspectionsBundle.message("inspection.redirect.template", description, path, original.getTextRange().getStartOffset(), vFile.getName());
        InspectionManager manager = InspectionManager.getInstance(original.getProject());
        ProblemDescriptor newProblem = manager.createProblemDescriptor(target, template, (LocalQuickFix)null, problem.getHighlightType(), this.isOnTheFly());
        this.registerProblem(newProblem);
    }

    public void registerProblem(@NotNull PsiReference reference, String descriptionTemplate, ProblemHighlightType highlightType) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        LocalQuickFix[] fixes = null;
        if (reference instanceof LocalQuickFixProvider) {
            fixes = ((LocalQuickFixProvider)((Object)reference)).getQuickFixes();
        }
        this.registerProblemForReference(reference, highlightType, descriptionTemplate, fixes);
    }

    public void registerProblemForReference(@NotNull PsiReference reference, @NotNull ProblemHighlightType highlightType, @NotNull String descriptionTemplate, LocalQuickFix ... fixes) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInspection/ProblemsHolder", "registerProblemForReference"));
        }
        if (highlightType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightType", "com/intellij/codeInspection/ProblemsHolder", "registerProblemForReference"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTemplate", "com/intellij/codeInspection/ProblemsHolder", "registerProblemForReference"));
        }
        ProblemDescriptor descriptor = this.myManager.createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), descriptionTemplate, highlightType, this.myOnTheFly, fixes);
        this.registerProblem(descriptor);
    }

    public void registerProblem(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        this.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage(reference), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    @NotNull
    public static String unresolvedReferenceMessage(@NotNull PsiReference reference) {
        String message;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInspection/ProblemsHolder", "unresolvedReferenceMessage"));
        }
        if (reference instanceof EmptyResolveMessageProvider) {
            String pattern = ((EmptyResolveMessageProvider)((Object)reference)).getUnresolvedMessagePattern();
            try {
                message = BundleBase.format(pattern, reference.getCanonicalText());
            }
            catch (IllegalArgumentException ex) {
                message = pattern;
                LOG.info(pattern);
            }
        } else {
            message = CodeInsightBundle.message("error.cannot.resolve.default.message", reference.getCanonicalText());
        }
        String string = message;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemsHolder", "unresolvedReferenceMessage"));
        }
        return string;
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull String message, @NotNull ProblemHighlightType highlightType, @Nullable TextRange rangeInElement, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        if (highlightType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightType", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        ProblemDescriptor descriptor = this.myManager.createProblemDescriptor(psiElement, rangeInElement, message, highlightType, this.myOnTheFly, fixes);
        this.registerProblem(descriptor);
    }

    public void registerProblem(@NotNull PsiElement psiElement, @Nullable TextRange rangeInElement, @NotNull String message, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/ProblemsHolder", "registerProblem"));
        }
        ProblemDescriptor descriptor = this.myManager.createProblemDescriptor(psiElement, rangeInElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, fixes);
        this.registerProblem(descriptor);
    }

    @NotNull
    public List<ProblemDescriptor> getResults() {
        List<ProblemDescriptor> list = this.myProblems;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemsHolder", "getResults"));
        }
        return list;
    }

    @NotNull
    public ProblemDescriptor[] getResultsArray() {
        List<ProblemDescriptor> problems = this.getResults();
        ProblemDescriptor[] problemDescriptorArray = problems.toArray(new ProblemDescriptor[problems.size()]);
        if (problemDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemsHolder", "getResultsArray"));
        }
        return problemDescriptorArray;
    }

    @NotNull
    public final InspectionManager getManager() {
        InspectionManager inspectionManager = this.myManager;
        if (inspectionManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemsHolder", "getManager"));
        }
        return inspectionManager;
    }

    public boolean hasResults() {
        return !this.myProblems.isEmpty();
    }

    public int getResultCount() {
        return this.myProblems.size();
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemsHolder", "getFile"));
        }
        return psiFile;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemsHolder", "getProject"));
        }
        return project;
    }
}

