/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowSearchUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.ThrowSearchUtil");

    private ThrowSearchUtil() {
    }

    private static boolean processExn(@NotNull PsiParameter aCatch, @NotNull Processor<UsageInfo> processor, @NotNull Root root) {
        if (aCatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aCatch", "com/intellij/psi/impl/search/ThrowSearchUtil", "processExn"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ThrowSearchUtil", "processExn"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/search/ThrowSearchUtil", "processExn"));
        }
        PsiType type = aCatch.getType();
        if (type.isAssignableFrom(root.myType)) {
            processor.process(new UsageInfo(aCatch));
            return false;
        }
        if (!root.isExact && root.myType.isAssignableFrom(type)) {
            processor.process(new UsageInfo(aCatch));
            return true;
        }
        return true;
    }

    private static boolean scanCatches(@NotNull PsiElement elem, @NotNull Processor<UsageInfo> processor, @NotNull Root root, @NotNull FindUsagesOptions options, @NotNull Set<PsiMethod> processed) {
        if (elem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/psi/impl/search/ThrowSearchUtil", "scanCatches"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ThrowSearchUtil", "scanCatches"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/search/ThrowSearchUtil", "scanCatches"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/impl/search/ThrowSearchUtil", "scanCatches"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/psi/impl/search/ThrowSearchUtil", "scanCatches"));
        }
        while (elem != null) {
            PsiTryStatement tryStmt;
            PsiElement parent = elem.getParent();
            if (elem instanceof PsiMethod) {
                PsiMethod method;
                PsiMethod deepestSuperMethod = ((PsiMethod)elem).findDeepestSuperMethod();
                PsiMethod psiMethod = method = deepestSuperMethod != null ? deepestSuperMethod : (PsiMethod)elem;
                if (!processed.contains(method)) {
                    processed.add(method);
                    PsiReference[] refs = MethodReferencesSearch.search(method, options.searchScope, true).toArray((PsiReference[])PsiReference.EMPTY_ARRAY);
                    for (int i = 0; i != refs.length; ++i) {
                        if (ThrowSearchUtil.scanCatches(refs[i].getElement(), processor, root, options, processed)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (elem instanceof PsiTryStatement) {
                PsiTryStatement aTry = (PsiTryStatement)elem;
                PsiParameter[] catches = aTry.getCatchBlockParameters();
                for (int i = 0; i != catches.length; ++i) {
                    if (ThrowSearchUtil.processExn(catches[i], processor, root)) continue;
                    return false;
                }
            } else if (parent instanceof PsiTryStatement && elem != (tryStmt = (PsiTryStatement)parent).getTryBlock()) {
                elem = parent.getParent();
                continue;
            }
            elem = parent;
        }
        return true;
    }

    public static boolean addThrowUsages(@NotNull Processor<UsageInfo> processor, @NotNull Root root, @NotNull FindUsagesOptions options) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ThrowSearchUtil", "addThrowUsages"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/search/ThrowSearchUtil", "addThrowUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/impl/search/ThrowSearchUtil", "addThrowUsages"));
        }
        HashSet<PsiMethod> processed = new HashSet<PsiMethod>();
        return ThrowSearchUtil.scanCatches(root.myElement, processor, root, options, processed);
    }

    private static boolean isExactExnType(PsiExpression exn) {
        return exn instanceof PsiNewExpression;
    }

    @Nullable
    public static Root[] getSearchRoots(PsiElement element) {
        PsiElement parent;
        PsiKeyword kwd;
        if (element instanceof PsiThrowStatement) {
            PsiThrowStatement aThrow = (PsiThrowStatement)element;
            PsiExpression exn = aThrow.getException();
            return new Root[]{new Root(aThrow.getParent(), exn.getType(), ThrowSearchUtil.isExactExnType(exn))};
        }
        if (element instanceof PsiKeyword && "throws".equals((kwd = (PsiKeyword)element).getText()) && (parent = kwd.getParent()) != null && parent.getParent() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent.getParent();
            PsiReferenceList throwsList = method.getThrowsList();
            PsiClassType[] exns = throwsList.getReferencedTypes();
            Root[] roots = new Root[exns.length];
            for (int i = 0; i != roots.length; ++i) {
                PsiClassType exn = exns[i];
                roots[i] = new Root(method, exn, false);
            }
            return roots;
        }
        return null;
    }

    public static boolean isSearchable(PsiElement element) {
        return ThrowSearchUtil.getSearchRoots(element) != null;
    }

    public static String getSearchableTypeName(PsiElement e) {
        if (e instanceof PsiThrowStatement) {
            PsiThrowStatement aThrow = (PsiThrowStatement)e;
            PsiType type = aThrow.getException().getType();
            return PsiFormatUtil.formatType(type, 8192, PsiSubstitutor.EMPTY);
        }
        if (e instanceof PsiKeyword && "throws".equals(e.getText())) {
            return e.getParent().getText();
        }
        LOG.error("invalid searchable element");
        return e.getText();
    }

    public static class Root {
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final PsiType myType;
        private final boolean isExact;

        public Root(@NotNull PsiElement root, @NotNull PsiType type, boolean exact) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/search/ThrowSearchUtil$Root", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/search/ThrowSearchUtil$Root", "<init>"));
            }
            this.myElement = root;
            this.myType = type;
            this.isExact = exact;
        }

        public String toString() {
            return PsiFormatUtil.formatType(this.myType, 8192, PsiSubstitutor.EMPTY);
        }
    }
}

