/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotatedPackagesSearcher
implements QueryExecutor<PsiPackage, AnnotatedPackagesSearch.Parameters> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.AnnotatedPackagesSearcher");

    @Override
    public boolean execute(@NotNull AnnotatedPackagesSearch.Parameters p, final @NotNull Processor<PsiPackage> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/AnnotatedPackagesSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/AnnotatedPackagesSearcher", "execute"));
        }
        final PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated packages search";
        String annotationFQN = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                return annClass.getQualifiedName();
            }
        });
        assert (annotationFQN != null);
        final PsiManager psiManager = ApplicationManager.getApplication().runReadAction(new Computable<PsiManager>(){

            @Override
            public PsiManager compute() {
                return annClass.getManager();
            }
        });
        final GlobalSearchScope useScope = (GlobalSearchScope)p.getScope();
        String annotationShortName = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                return annClass.getName();
            }
        });
        assert (annotationShortName != null);
        Collection<PsiAnnotation> annotations = JavaAnnotationIndex.getInstance().get(annotationShortName, psiManager.getProject(), useScope);
        for (final PsiAnnotation annotation : annotations) {
            boolean accepted = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                @Override
                public Boolean compute() {
                    PsiClass candidate;
                    PsiModifierList modlist = (PsiModifierList)annotation.getParent();
                    PsiElement owner = modlist.getParent();
                    if (owner instanceof PsiClass && "package-info".equals((candidate = (PsiClass)owner).getName())) {
                        String qname;
                        LOG.assertTrue(candidate.isValid());
                        PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
                        if (ref != null && psiManager.areElementsEquivalent(ref.resolve(), annClass) && useScope.contains(candidate.getContainingFile().getVirtualFile()) && (qname = candidate.getQualifiedName()) != null && !consumer.process(JavaPsiFacade.getInstance(psiManager.getProject()).findPackage(qname.substring(0, qname.lastIndexOf(46))))) {
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (accepted) continue;
            return false;
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance(psiManager.getProject());
        PackageInfoFilesOnly infoFilesFilter = new PackageInfoFilesOnly();
        GlobalSearchScope infoFiles = useScope.intersectWith(infoFilesFilter);
        boolean[] wantMore = new boolean[]{true};
        helper.processAllFilesWithWord(annotationShortName, infoFiles, psiFile -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/AnnotatedPackagesSearcher", "lambda$execute$0"));
            }
            PsiPackageStatement stmt = PsiTreeUtil.getChildOfType(psiFile, PsiPackageStatement.class);
            if (stmt == null) {
                return true;
            }
            PsiModifierList annotations1 = stmt.getAnnotationList();
            if (annotations1 == null) {
                return true;
            }
            PsiAnnotation ann = annotations1.findAnnotation(annotationFQN);
            if (ann == null) {
                return true;
            }
            PsiJavaCodeReferenceElement ref = ann.getNameReferenceElement();
            if (ref == null) {
                return true;
            }
            if (!psiManager.areElementsEquivalent(ref.resolve(), annClass)) {
                return true;
            }
            wantMore[0] = consumer.process(JavaPsiFacade.getInstance(psiManager.getProject()).findPackage(stmt.getPackageName()));
            return wantMore[0];
        }, true);
        return wantMore[0];
    }

    private static class PackageInfoFilesOnly
    extends GlobalSearchScope {
        private PackageInfoFilesOnly() {
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/impl/search/AnnotatedPackagesSearcher$PackageInfoFilesOnly", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/impl/search/AnnotatedPackagesSearcher$PackageInfoFilesOnly", "compare"));
            }
            return 0;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/AnnotatedPackagesSearcher$PackageInfoFilesOnly", "contains"));
            }
            return "package-info.java".equals(file.getName());
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/impl/search/AnnotatedPackagesSearcher$PackageInfoFilesOnly", "isSearchInModuleContent"));
            }
            return true;
        }
    }
}

