/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesOptions
implements Cloneable {
    @NotNull
    public SearchScope searchScope;
    public boolean isSearchForTextOccurrences;
    public boolean isUsages;
    public SearchRequestCollector fastTrack;

    public FindUsagesOptions(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/FindUsagesOptions", "<init>"));
        }
        this(project, null);
    }

    public FindUsagesOptions(@NotNull Project project, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/FindUsagesOptions", "<init>"));
        }
        this.isSearchForTextOccurrences = true;
        this.isUsages = false;
        this.fastTrack = null;
        String defaultScopeName = FindSettings.getInstance().getDefaultScopeName();
        List<SearchScope> predefined = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, dataContext, true, false, false, false);
        SearchScope resultScope = null;
        for (SearchScope scope : predefined) {
            if (!scope.getDisplayName().equals(defaultScopeName)) continue;
            resultScope = scope;
            break;
        }
        if (resultScope == null) {
            resultScope = ProjectScope.getProjectScope(project);
        }
        this.searchScope = resultScope;
    }

    public FindUsagesOptions(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/findUsages/FindUsagesOptions", "<init>"));
        }
        this.isSearchForTextOccurrences = true;
        this.isUsages = false;
        this.fastTrack = null;
        this.searchScope = searchScope;
    }

    public FindUsagesOptions clone() {
        try {
            return (FindUsagesOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindUsagesOptions that = (FindUsagesOptions)o;
        if (this.isSearchForTextOccurrences != that.isSearchForTextOccurrences) {
            return false;
        }
        if (this.isUsages != that.isUsages) {
            return false;
        }
        return this.searchScope.equals(that.searchScope);
    }

    public int hashCode() {
        int result = this.searchScope.hashCode();
        result = 31 * result + (this.isSearchForTextOccurrences ? 1 : 0);
        result = 31 * result + (this.isUsages ? 1 : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "searchScope=" + this.searchScope + ", isSearchForTextOccurrences=" + this.isSearchForTextOccurrences + ", isUsages=" + this.isUsages + '}';
    }

    @NotNull
    public String generateUsagesString() {
        if ("Usages" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesOptions", "generateUsagesString"));
        }
        return "Usages";
    }
}

