/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StructureViewComposite
implements StructureView {
    @NotNull
    private final StructureViewDescriptor[] myStructureViews;
    @NotNull
    private final StructureViewDescriptor mySelectedViewDescriptor;

    public StructureViewComposite(StructureViewDescriptor ... views) {
        if (views == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "views", "com/intellij/ide/structureView/impl/StructureViewComposite", "<init>"));
        }
        this.myStructureViews = views;
        for (StructureViewDescriptor descriptor : views) {
            Disposer.register(this, descriptor.structureView);
        }
        this.mySelectedViewDescriptor = views[0];
    }

    public StructureView getSelectedStructureView() {
        return this.mySelectedViewDescriptor.structureView;
    }

    public void setStructureView(int index, StructureViewDescriptor view) {
        this.myStructureViews[index] = view;
        Disposer.register(this, view.structureView);
    }

    @Override
    public FileEditor getFileEditor() {
        return this.getSelectedStructureView().getFileEditor();
    }

    @Override
    public boolean navigateToSelectedElement(boolean requestFocus) {
        return this.getSelectedStructureView().navigateToSelectedElement(requestFocus);
    }

    @Override
    public JComponent getComponent() {
        return this.mySelectedViewDescriptor.structureView.getComponent();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void centerSelectedRow() {
        this.getSelectedStructureView().centerSelectedRow();
    }

    @Override
    public void restoreState() {
        for (StructureViewDescriptor descriptor : this.myStructureViews) {
            descriptor.structureView.restoreState();
        }
    }

    @Override
    public void storeState() {
        for (StructureViewDescriptor descriptor : this.myStructureViews) {
            descriptor.structureView.storeState();
        }
    }

    @NotNull
    public StructureViewDescriptor[] getStructureViews() {
        if (this.myStructureViews == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewComposite", "getStructureViews"));
        }
        return this.myStructureViews;
    }

    @Override
    @NotNull
    public StructureViewModel getTreeModel() {
        StructureViewModel structureViewModel = this.getSelectedStructureView().getTreeModel();
        if (structureViewModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewComposite", "getTreeModel"));
        }
        return structureViewModel;
    }

    public static class StructureViewDescriptor {
        public final String title;
        public final StructureView structureView;
        public final Icon icon;

        public StructureViewDescriptor(String title, @NotNull StructureView structureView, Icon icon) {
            if (structureView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureView", "com/intellij/ide/structureView/impl/StructureViewComposite$StructureViewDescriptor", "<init>"));
            }
            this.title = title;
            this.structureView = structureView;
            this.icon = icon;
        }
    }
}

