/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.source.PsiParameterImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.ParameterElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaParameterElementType
extends JavaStubElementType<PsiParameterStub, PsiParameter> {
    public JavaParameterElementType() {
        super("PARAMETER");
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        ParameterElement parameterElement = new ParameterElement(JavaElementType.PARAMETER);
        if (parameterElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "createCompositeNode"));
        }
        return parameterElement;
    }

    @Override
    public PsiParameter createPsi(@NotNull PsiParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "createPsi"));
        }
        return this.getPsiFactory(stub).createParameter(stub);
    }

    @Override
    public PsiParameter createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "createPsi"));
        }
        return new PsiParameterImpl(node);
    }

    @Override
    public PsiParameterStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        TypeInfo typeInfo = TypeInfo.create(tree, node, parentStub);
        LighterASTNode id = LightTreeUtil.requiredChildOfType(tree, node, JavaTokenType.IDENTIFIER);
        String name = RecordUtil.intern(tree.getCharTable(), id);
        return new PsiParameterStubImpl(parentStub, name, typeInfo, typeInfo.isEllipsis, false);
    }

    @Override
    public void serialize(@NotNull PsiParameterStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getType(false));
        dataStream.writeByte(((PsiParameterStubImpl)stub).getFlags());
    }

    @Override
    @NotNull
    public PsiParameterStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "deserialize"));
        }
        StringRef name = dataStream.readName();
        if (name == null) {
            throw new IOException("corrupted indices");
        }
        TypeInfo type = TypeInfo.readTYPE(dataStream);
        byte flags = dataStream.readByte();
        PsiParameterStubImpl psiParameterStubImpl = new PsiParameterStubImpl(parentStub, name, type, flags);
        if (psiParameterStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "deserialize"));
        }
        return psiParameterStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiParameterStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/psi/impl/java/stubs/JavaParameterElementType", "indexStub"));
        }
    }
}

