/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyDirectoryInspection
extends BaseGlobalInspection {
    public boolean onlyReportDirectoriesUnderSourceRoots = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.directory.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/packaging/EmptyDirectoryInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("empty.directories.only.under.source.roots.option", new Object[0]), this, "onlyReportDirectoriesUnderSourceRoots");
    }

    @Override
    public boolean isGraphNeeded() {
        return false;
    }

    @Override
    public void runInspection(@NotNull AnalysisScope scope, final @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext context, final @NotNull ProblemDescriptionsProcessor processor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/packaging/EmptyDirectoryInspection", "runInspection"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/siyeh/ig/packaging/EmptyDirectoryInspection", "runInspection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/packaging/EmptyDirectoryInspection", "runInspection"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/siyeh/ig/packaging/EmptyDirectoryInspection", "runInspection"));
        }
        final Project project = context.getProject();
        final ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
        SearchScope searchScope = scope.toSearchScope();
        if (!(searchScope instanceof GlobalSearchScope)) {
            return;
        }
        final GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope;
        final PsiManager psiManager = PsiManager.getInstance(project);
        index.iterateContent(new ContentIterator(){

            @Override
            public boolean processFile(final VirtualFile fileOrDir) {
                if (!fileOrDir.isDirectory()) {
                    return true;
                }
                if (!globalSearchScope.contains(fileOrDir)) {
                    return true;
                }
                if (EmptyDirectoryInspection.this.onlyReportDirectoriesUnderSourceRoots && !index.isInSourceContent(fileOrDir)) {
                    return true;
                }
                VirtualFile[] children = fileOrDir.getChildren();
                if (children.length != 0) {
                    return true;
                }
                Application application = ApplicationManager.getApplication();
                PsiDirectory directory = application.runReadAction(new Computable<PsiDirectory>(){

                    @Override
                    public PsiDirectory compute() {
                        return psiManager.findDirectory(fileOrDir);
                    }
                });
                RefElement refDirectory = context.getRefManager().getReference(directory);
                if (context.shouldCheck(refDirectory, EmptyDirectoryInspection.this)) {
                    return true;
                }
                String relativePath = EmptyDirectoryInspection.getPathRelativeToModule(fileOrDir, project);
                if (relativePath == null) {
                    return true;
                }
                processor.addProblemElement(refDirectory, manager.createProblemDescriptor(InspectionGadgetsBundle.message("empty.directories.problem.descriptor", relativePath), new EmptyPackageFix(fileOrDir.getUrl(), fileOrDir.getName())));
                return true;
            }
        });
    }

    @Nullable
    private static String getPathRelativeToModule(VirtualFile file, Project project) {
        VirtualFile[] contentRoots;
        final ProjectRootManager rootManager = ProjectRootManager.getInstance(project);
        Application application = ApplicationManager.getApplication();
        for (VirtualFile otherRoot : contentRoots = application.runReadAction(new Computable<VirtualFile[]>(){

            @Override
            public VirtualFile[] compute() {
                return rootManager.getContentRootsFromAllModules();
            }
        })) {
            if (!VfsUtilCore.isAncestor(otherRoot, file, false)) continue;
            return VfsUtilCore.getRelativePath(file, otherRoot, '/');
        }
        return null;
    }

    private static class EmptyPackageFix
    implements QuickFix {
        private final String url;
        private final String name;

        public EmptyPackageFix(String url, String name) {
            this.url = url;
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("empty.directories.delete.quickfix", this.name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/packaging/EmptyDirectoryInspection$EmptyPackageFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("empty.directories.delete.quickfix", "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/packaging/EmptyDirectoryInspection$EmptyPackageFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/packaging/EmptyDirectoryInspection$EmptyPackageFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/siyeh/ig/packaging/EmptyDirectoryInspection$EmptyPackageFix", "applyFix"));
            }
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(this.url);
            if (file == null) {
                return;
            }
            PsiManager psiManager = PsiManager.getInstance(project);
            PsiDirectory directory = psiManager.findDirectory(file);
            if (directory == null) {
                return;
            }
            directory.delete();
        }
    }
}

