/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodContract {
    public final ValueConstraint[] arguments;
    public final ValueConstraint returnValue;

    public MethodContract(@NotNull ValueConstraint[] arguments, @NotNull ValueConstraint returnValue) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInspection/dataFlow/MethodContract", "<init>"));
        }
        if (returnValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnValue", "com/intellij/codeInspection/dataFlow/MethodContract", "<init>"));
        }
        this.arguments = arguments;
        this.returnValue = returnValue;
    }

    static ValueConstraint[] createConstraintArray(int paramCount) {
        ValueConstraint[] args = new ValueConstraint[paramCount];
        for (int i = 0; i < args.length; ++i) {
            args[i] = ValueConstraint.ANY_VALUE;
        }
        return args;
    }

    public String toString() {
        return StringUtil.join(this.arguments, constraint -> constraint.toString(), ", ") + " -> " + (Object)((Object)this.returnValue);
    }

    public static List<MethodContract> parseContract(String text) throws ParseException {
        ArrayList<MethodContract> result = ContainerUtil.newArrayList();
        for (String clause : StringUtil.replace(text, " ", "").split(";")) {
            ValueConstraint[] args;
            String arrow = "->";
            int arrowIndex = clause.indexOf(arrow);
            if (arrowIndex < 0) {
                throw new ParseException("A contract clause must be in form arg1, ..., argN -> return-value");
            }
            String beforeArrow = clause.substring(0, arrowIndex);
            if (StringUtil.isNotEmpty(beforeArrow)) {
                String[] argStrings = beforeArrow.split(",");
                args = new ValueConstraint[argStrings.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = MethodContract.parseConstraint(argStrings[i]);
                }
            } else {
                args = new ValueConstraint[]{};
            }
            result.add(new MethodContract(args, MethodContract.parseConstraint(clause.substring(arrowIndex + arrow.length()))));
        }
        return result;
    }

    private static ValueConstraint parseConstraint(String name) throws ParseException {
        if (StringUtil.isEmpty(name)) {
            throw new ParseException("Constraint should not be empty");
        }
        for (ValueConstraint constraint : ValueConstraint.values()) {
            if (!constraint.toString().equals(name)) continue;
            return constraint;
        }
        throw new ParseException("Constraint should be one of: null, !null, true, false, fail, _. Found: " + name);
    }

    public static class ParseException
    extends Exception {
        private ParseException(String message) {
            super(message);
        }
    }

    public static enum ValueConstraint {
        ANY_VALUE("_"),
        NULL_VALUE("null"),
        NOT_NULL_VALUE("!null"),
        TRUE_VALUE("true"),
        FALSE_VALUE("false"),
        THROW_EXCEPTION("fail");

        private final String myPresentableName;

        private ValueConstraint(String presentableName) {
            this.myPresentableName = presentableName;
        }

        @Nullable
        DfaConstValue getComparisonValue(DfaValueFactory factory) {
            if (this == NULL_VALUE || this == NOT_NULL_VALUE) {
                return factory.getConstFactory().getNull();
            }
            if (this == TRUE_VALUE || this == FALSE_VALUE) {
                return factory.getConstFactory().getTrue();
            }
            return null;
        }

        boolean shouldUseNonEqComparison() {
            return this == NOT_NULL_VALUE || this == FALSE_VALUE;
        }

        public String toString() {
            return this.myPresentableName;
        }
    }
}

