/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IdIterator;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubIndex {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.StubIndex");

    public static StubIndex getInstance() {
        return StubIndexHolder.ourInstance;
    }

    public abstract <Key, Psi extends PsiElement> Collection<Psi> get(@NotNull StubIndexKey<Key, Psi> var1, @NotNull Key var2, @NotNull Project var3, @Nullable GlobalSearchScope var4);

    public <Key, Psi extends PsiElement> Collection<Psi> get(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, IdFilter filter) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/psi/stubs/StubIndex", "get"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/stubs/StubIndex", "get"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubs/StubIndex", "get"));
        }
        return this.get(indexKey, key, project, scope);
    }

    public <Key, Psi extends PsiElement> boolean process(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, @NotNull Processor<? super Psi> processor) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/psi/stubs/StubIndex", "process"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/stubs/StubIndex", "process"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubs/StubIndex", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/stubs/StubIndex", "process"));
        }
        return this.processElements(indexKey, key, project, scope, PsiElement.class, processor);
    }

    public abstract <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> var1, @NotNull Key var2, @NotNull Project var3, @Nullable GlobalSearchScope var4, Class<Psi> var5, @NotNull Processor<? super Psi> var6);

    public <Key, Psi extends PsiElement> boolean process(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, IdFilter idFilter, @NotNull Processor<? super Psi> processor) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/psi/stubs/StubIndex", "process"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/stubs/StubIndex", "process"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubs/StubIndex", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/stubs/StubIndex", "process"));
        }
        return this.process(indexKey, key, project, scope, processor);
    }

    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, IdFilter idFilter, @NotNull Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/psi/stubs/StubIndex", "processElements"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/stubs/StubIndex", "processElements"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubs/StubIndex", "processElements"));
        }
        if (requiredClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredClass", "com/intellij/psi/stubs/StubIndex", "processElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/stubs/StubIndex", "processElements"));
        }
        return this.process(indexKey, key, project, scope, processor);
    }

    @NotNull
    public abstract <Key> Collection<Key> getAllKeys(@NotNull StubIndexKey<Key, ?> var1, @NotNull Project var2);

    public abstract <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> var1, @NotNull Project var2, Processor<K> var3);

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Processor<K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/psi/stubs/StubIndex", "processAllKeys"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/stubs/StubIndex", "processAllKeys"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/stubs/StubIndex", "processAllKeys"));
        }
        return this.processAllKeys(indexKey, ObjectUtils.assertNotNull(scope.getProject()), processor);
    }

    public <Key, Psi extends PsiElement> Collection<Psi> safeGet(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, GlobalSearchScope scope, @NotNull Class<Psi> requiredClass) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/psi/stubs/StubIndex", "safeGet"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/stubs/StubIndex", "safeGet"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubs/StubIndex", "safeGet"));
        }
        if (requiredClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredClass", "com/intellij/psi/stubs/StubIndex", "safeGet"));
        }
        return StubIndex.getElements(indexKey, key, project, scope, requiredClass);
    }

    public static <Key, Psi extends PsiElement> Collection<Psi> getElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, @NotNull Class<Psi> requiredClass) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/psi/stubs/StubIndex", "getElements"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/stubs/StubIndex", "getElements"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubs/StubIndex", "getElements"));
        }
        if (requiredClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredClass", "com/intellij/psi/stubs/StubIndex", "getElements"));
        }
        return StubIndex.getElements(indexKey, key, project, scope, null, requiredClass);
    }

    public static <Key, Psi extends PsiElement> Collection<Psi> getElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull Class<Psi> requiredClass) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/psi/stubs/StubIndex", "getElements"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/stubs/StubIndex", "getElements"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubs/StubIndex", "getElements"));
        }
        if (requiredClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredClass", "com/intellij/psi/stubs/StubIndex", "getElements"));
        }
        SmartList result = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor(result);
        StubIndex.getInstance().processElements(indexKey, key, project, scope, idFilter, requiredClass, processor);
        return result;
    }

    @NotNull
    public abstract <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> var1, @NotNull Key var2, @NotNull Project var3, @NotNull GlobalSearchScope var4);

    protected <Psi extends PsiElement> void reportStubPsiMismatch(Psi psi, VirtualFile file, Class<Psi> requiredClass) {
        LOG.error("Invalid stub element type in index: " + file + ". found: " + psi + ". expected: " + requiredClass);
    }

    public abstract void forceRebuild(@NotNull Throwable var1);

    private static class StubIndexHolder {
        private static final StubIndex ourInstance = ApplicationManager.getApplication().getComponent(StubIndex.class);

        private StubIndexHolder() {
        }
    }
}

