/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefParameterImpl
extends RefJavaElementImpl
implements RefParameter {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private static final String VALUE_UNDEFINED = "#";
    private final short myIndex;
    private String myActualValueTemplate;

    RefParameterImpl(PsiParameter parameter, int index, RefManager manager) {
        super(parameter, manager);
        this.myIndex = (short)index;
        this.myActualValueTemplate = VALUE_UNDEFINED;
        RefElementImpl owner = (RefElementImpl)manager.getReference(PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class));
        if (owner != null) {
            owner.add(this);
        }
    }

    @Override
    public void parameterReferenced(boolean forWriting) {
        if (forWriting) {
            this.setUsedForWriting();
        } else {
            this.setUsedForReading();
        }
    }

    @Override
    public boolean isUsedForReading() {
        return this.checkFlag(65536L);
    }

    private void setUsedForReading() {
        this.setFlag(true, 65536L);
    }

    @Override
    public PsiParameter getElement() {
        return (PsiParameter)super.getElement();
    }

    @Override
    public boolean isUsedForWriting() {
        return this.checkFlag(131072L);
    }

    private void setUsedForWriting() {
        this.setFlag(true, 131072L);
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefParameterImpl", "accept"));
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefParameterImpl", "lambda$accept$0"));
                }
                ((RefJavaVisitor)visitor).visitParameter(this);
            });
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public void buildReferences() {
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        PsiParameter parameter = this.getElement();
        if (parameter != null) {
            refUtil.addReferences(parameter, this, parameter.getModifierList());
        }
    }

    public void updateTemplateValue(PsiExpression expression) {
        PsiField psiField;
        PsiReferenceExpression referenceExpression;
        PsiElement resolved;
        if (this.myActualValueTemplate == null) {
            return;
        }
        String newTemplate = null;
        if (expression instanceof PsiLiteralExpression) {
            PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)expression;
            newTemplate = psiLiteralExpression.getText();
        } else if (expression instanceof PsiReferenceExpression && (resolved = (referenceExpression = (PsiReferenceExpression)expression).resolve()) instanceof PsiField && (psiField = (PsiField)resolved).hasModifierProperty("static") && psiField.hasModifierProperty("final") && psiField.getContainingClass().getQualifiedName() != null) {
            newTemplate = PsiFormatUtil.formatVariable(psiField, 6145, PsiSubstitutor.EMPTY);
        }
        if (this.myActualValueTemplate == VALUE_UNDEFINED) {
            this.myActualValueTemplate = newTemplate;
        } else if (!Comparing.equal(this.myActualValueTemplate, newTemplate)) {
            this.myActualValueTemplate = null;
        }
    }

    @Override
    public String getActualValueIfSame() {
        if (this.myActualValueTemplate == VALUE_UNDEFINED) {
            return null;
        }
        return this.myActualValueTemplate;
    }

    @Override
    protected void initialize() {
    }

    @Override
    public String getExternalName() {
        String[] result = new String[1];
        Runnable runnable = () -> {
            PsiParameter parameter = this.getElement();
            LOG.assertTrue(parameter != null);
            result[0] = PsiFormatUtil.getExternalName(parameter);
        };
        ApplicationManager.getApplication().runReadAction(runnable);
        return result[0];
    }

    @Nullable
    public static RefElement parameterFromExternalName(RefManager manager, String fqName) {
        int idx = fqName.lastIndexOf(32);
        if (idx > 0) {
            String paramName = fqName.substring(idx + 1);
            String method = fqName.substring(0, idx);
            RefMethod refMethod = RefMethodImpl.methodFromExternalName(manager, method);
            if (refMethod != null) {
                PsiMethod element = (PsiMethod)refMethod.getElement();
                PsiParameterList list = element.getParameterList();
                PsiParameter[] parameters = list.getParameters();
                int paramIdx = 0;
                for (PsiParameter parameter : parameters) {
                    String name = parameter.getName();
                    if (name != null && name.equals(paramName)) {
                        return manager.getExtension(RefJavaManager.MANAGER).getParameterReference(parameter, paramIdx);
                    }
                    ++paramIdx;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiParameter findPsiParameter(String fqName, PsiManager manager) {
        int idx = fqName.lastIndexOf(32);
        if (idx > 0) {
            String paramName = fqName.substring(idx + 1);
            String method = fqName.substring(0, idx);
            PsiMethod psiMethod = RefMethodImpl.findPsiMethod(manager, method);
            if (psiMethod != null) {
                PsiParameter[] parameters;
                PsiParameterList list = psiMethod.getParameterList();
                for (PsiParameter parameter : parameters = list.getParameters()) {
                    String name = parameter.getName();
                    if (name == null || !name.equals(paramName)) continue;
                    return parameter;
                }
            }
        }
        return null;
    }
}

