/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionEngine {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.InspectionEngine");

    @NotNull
    public static PsiElementVisitor createVisitorAndAcceptElements(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session, @NotNull List<PsiElement> elements, @NotNull Set<String> elementDialectIds, @Nullable(value="null means all accepted") Set<String> dialectIdsSpecifiedForTool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        if (elementDialectIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementDialectIds", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        PsiElementVisitor visitor = tool.buildVisitor(holder, isOnTheFly, session);
        if (visitor == null) {
            LOG.error("Tool " + tool + " (" + tool.getClass() + ") must not return null from the buildVisitor() method");
        }
        assert (!(visitor instanceof PsiRecursiveElementVisitor) && !(visitor instanceof PsiRecursiveElementWalkingVisitor)) : "The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive. " + tool;
        tool.inspectionStarted(session, isOnTheFly);
        InspectionEngine.acceptElements(elements, visitor, elementDialectIds, dialectIdsSpecifiedForTool);
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        return psiElementVisitor;
    }

    public static void acceptElements(@NotNull List<PsiElement> elements, @NotNull PsiElementVisitor elementVisitor, @NotNull Set<String> elementDialectIds, @Nullable(value="null means all accepted") Set<String> dialectIdsSpecifiedForTool) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInspection/InspectionEngine", "acceptElements"));
        }
        if (elementVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementVisitor", "com/intellij/codeInspection/InspectionEngine", "acceptElements"));
        }
        if (elementDialectIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementDialectIds", "com/intellij/codeInspection/InspectionEngine", "acceptElements"));
        }
        if (dialectIdsSpecifiedForTool != null && !InspectionEngine.intersect(elementDialectIds, dialectIdsSpecifiedForTool)) {
            return;
        }
        int elementsSize = elements.size();
        for (int i = 0; i < elementsSize; ++i) {
            PsiElement element = elements.get(i);
            element.accept(elementVisitor);
            ProgressManager.checkCanceled();
        }
    }

    private static boolean intersect(@NotNull Set<String> ids1, @NotNull Set<String> ids2) {
        if (ids1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids1", "com/intellij/codeInspection/InspectionEngine", "intersect"));
        }
        if (ids2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids2", "com/intellij/codeInspection/InspectionEngine", "intersect"));
        }
        if (ids1.size() > ids2.size()) {
            return InspectionEngine.intersect(ids2, ids1);
        }
        for (String id : ids1) {
            if (!ids2.contains(id)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<ProblemDescriptor> inspect(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator indicator) {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/InspectionEngine", "inspect"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/InspectionEngine", "inspect"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInspection/InspectionEngine", "inspect"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/InspectionEngine", "inspect"));
        }
        Map<String, List<ProblemDescriptor>> problemDescriptors = InspectionEngine.inspectEx(toolWrappers, file, iManager, isOnTheFly, failFastOnAcquireReadAction, indicator);
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (List<ProblemDescriptor> group : problemDescriptors.values()) {
            result.addAll(group);
        }
        ArrayList<ProblemDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "inspect"));
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator indicator) {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
        }
        if (toolWrappers.isEmpty()) {
            Map<String, List<ProblemDescriptor>> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
            }
            return map;
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        TextRange range = file.getTextRange();
        Divider.divideInsideAndOutside(file, range.getStartOffset(), range.getEndOffset(), range, elements, new ArrayList<ProperTextRange>(), Collections.emptyList(), Collections.emptyList(), true, Conditions.alwaysTrue());
        Map<String, List<ProblemDescriptor>> map = InspectionEngine.inspectElements(toolWrappers, file, iManager, isOnTheFly, failFastOnAcquireReadAction, indicator, elements, InspectionEngine.calcElementDialectIds(elements));
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
        }
        return map;
    }

    @NotNull
    static Map<String, List<ProblemDescriptor>> inspectElements(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator indicator, @NotNull List<PsiElement> elements, @NotNull Set<String> elementDialectIds) {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/InspectionEngine", "inspectElements"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/InspectionEngine", "inspectElements"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInspection/InspectionEngine", "inspectElements"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/InspectionEngine", "inspectElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInspection/InspectionEngine", "inspectElements"));
        }
        if (elementDialectIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementDialectIds", "com/intellij/codeInspection/InspectionEngine", "inspectElements"));
        }
        TextRange range = file.getTextRange();
        LocalInspectionToolSession session = new LocalInspectionToolSession(file, range.getStartOffset(), range.getEndOffset());
        Map<LocalInspectionToolWrapper, Set<String>> toolToSpecifiedDialectIds = InspectionEngine.getToolsToSpecifiedLanguages(toolWrappers);
        ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>> entries = new ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>>(toolToSpecifiedDialectIds.entrySet());
        ConcurrentHashMap<String, List<ProblemDescriptor>> resultDescriptors = new ConcurrentHashMap<String, List<ProblemDescriptor>>();
        Processor<Map.Entry> processor = entry -> {
            if (iManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInspection/InspectionEngine", "lambda$inspectElements$1"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/InspectionEngine", "lambda$inspectElements$1"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInspection/InspectionEngine", "lambda$inspectElements$1"));
            }
            if (elementDialectIds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementDialectIds", "com/intellij/codeInspection/InspectionEngine", "lambda$inspectElements$1"));
            }
            ProblemsHolder holder = new ProblemsHolder(iManager, file, isOnTheFly);
            LocalInspectionTool tool = (LocalInspectionTool)((LocalInspectionToolWrapper)entry.getKey()).getTool();
            Set dialectIdsSpecifiedForTool = (Set)entry.getValue();
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session, elements, elementDialectIds, dialectIdsSpecifiedForTool);
            tool.inspectionFinished(session, holder);
            if (holder.hasResults()) {
                resultDescriptors.put(tool.getShortName(), ContainerUtil.filter(holder.getResults(), descriptor -> {
                    PsiElement element = descriptor.getPsiElement();
                    return element == null || !SuppressionUtil.inspectionResultSuppressed(element, tool);
                }));
            }
            return true;
        };
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(entries, indicator, failFastOnAcquireReadAction, processor);
        ConcurrentHashMap<String, List<ProblemDescriptor>> concurrentHashMap = resultDescriptors;
        if (concurrentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "inspectElements"));
        }
        return concurrentHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<ProblemDescriptor> runInspectionOnFile(final @NotNull PsiFile file, @NotNull InspectionToolWrapper toolWrapper, final @NotNull GlobalInspectionContext inspectionContext) {
        block15: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
            }
            if (toolWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
            }
            if (inspectionContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionContext", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
            }
            final InspectionManager inspectionManager = InspectionManager.getInstance(file.getProject());
            toolWrapper.initialize(inspectionContext);
            RefManagerImpl refManager = (RefManagerImpl)inspectionContext.getRefManager();
            refManager.inspectionReadActionStarted();
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                List<ProblemDescriptor> list = InspectionEngine.inspect(Collections.singletonList((LocalInspectionToolWrapper)toolWrapper), file, inspectionManager, false, false, new EmptyProgressIndicator());
                List<ProblemDescriptor> list2 = list;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
                }
                return list2;
            }
            if (!(toolWrapper instanceof GlobalInspectionToolWrapper)) break block15;
            final GlobalInspectionTool globalTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
            final ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
            if (globalTool instanceof GlobalSimpleInspectionTool) {
                GlobalSimpleInspectionTool simpleTool = (GlobalSimpleInspectionTool)globalTool;
                ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, file, false);
                ProblemDescriptionsProcessor collectProcessor = new ProblemDescriptionsProcessor(){

                    @Override
                    @Nullable
                    public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                        if (refEntity == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/InspectionEngine$1", "getDescriptions"));
                        }
                        return descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
                    }

                    @Override
                    public void ignoreElement(@NotNull RefEntity refEntity) {
                        if (refEntity == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/InspectionEngine$1", "ignoreElement"));
                        }
                        throw new RuntimeException();
                    }

                    @Override
                    public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                        if (commonProblemDescriptors == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonProblemDescriptors", "com/intellij/codeInspection/InspectionEngine$1", "addProblemElement"));
                        }
                        if (!(refEntity instanceof RefElement)) {
                            return;
                        }
                        PsiElement element = ((RefElement)refEntity).getElement();
                        InspectionEngine.convertToProblemDescriptors(element, commonProblemDescriptors, descriptors);
                    }

                    @Override
                    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
                        if (descriptor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/InspectionEngine$1", "getElement"));
                        }
                        throw new RuntimeException();
                    }
                };
                simpleTool.checkFile(file, inspectionManager, problemsHolder, inspectionContext, collectProcessor);
                ArrayList<ProblemDescriptor> arrayList = descriptors;
                ArrayList<ProblemDescriptor> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
                }
                return arrayList2;
            }
            RefElement fileRef = refManager.getReference(file);
            final AnalysisScope scope = new AnalysisScope(file);
            assert (fileRef != null);
            fileRef.accept(new RefVisitor(){

                @Override
                public void visitElement(@NotNull RefEntity elem) {
                    if (elem == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/InspectionEngine$2", "visitElement"));
                    }
                    CommonProblemDescriptor[] elemDescriptors = globalTool.checkElement(elem, scope, inspectionManager, inspectionContext);
                    if (elemDescriptors != null) {
                        InspectionEngine.convertToProblemDescriptors(file, elemDescriptors, descriptors);
                    }
                    for (RefEntity child : elem.getChildren()) {
                        child.accept(this);
                    }
                }
            });
            ArrayList<ProblemDescriptor> arrayList = descriptors;
            ArrayList<ProblemDescriptor> arrayList3 = arrayList;
            if (arrayList3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
            }
            return arrayList3;
            finally {
                refManager.inspectionReadActionFinished();
                toolWrapper.cleanup(file.getProject());
                inspectionContext.cleanup();
            }
        }
        List<ProblemDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
        }
        return list;
    }

    private static void convertToProblemDescriptors(@NotNull PsiElement element, @NotNull CommonProblemDescriptor[] commonProblemDescriptors, @NotNull List<ProblemDescriptor> descriptors) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/InspectionEngine", "convertToProblemDescriptors"));
        }
        if (commonProblemDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonProblemDescriptors", "com/intellij/codeInspection/InspectionEngine", "convertToProblemDescriptors"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/InspectionEngine", "convertToProblemDescriptors"));
        }
        for (CommonProblemDescriptor common : commonProblemDescriptors) {
            if (common instanceof ProblemDescriptor) {
                descriptors.add((ProblemDescriptor)common);
                continue;
            }
            ProblemDescriptorBase base = new ProblemDescriptorBase(element, element, common.getDescriptionTemplate(), (LocalQuickFix[])common.getFixes(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            descriptors.add(base);
        }
    }

    @NotNull
    public static Map<LocalInspectionToolWrapper, Set<String>> getToolsToSpecifiedLanguages(@NotNull List<LocalInspectionToolWrapper> toolWrappers) {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/InspectionEngine", "getToolsToSpecifiedLanguages"));
        }
        THashMap toolToLanguages = new THashMap();
        for (LocalInspectionToolWrapper wrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            Set<String> specifiedLangIds = InspectionEngine.getDialectIdsSpecifiedForTool(wrapper);
            toolToLanguages.put(wrapper, specifiedLangIds);
        }
        THashMap tHashMap = toolToLanguages;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "getToolsToSpecifiedLanguages"));
        }
        return tHashMap;
    }

    @Nullable(value="null means not specified")
    private static Set<String> getDialectIdsSpecifiedForTool(@NotNull LocalInspectionToolWrapper wrapper) {
        Set<String> result;
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/InspectionEngine", "getDialectIdsSpecifiedForTool"));
        }
        String langId = wrapper.getLanguage();
        if (langId == null) {
            return null;
        }
        Language language = Language.findLanguageByID(langId);
        if (language != null) {
            List<Language> dialects = language.getDialects();
            boolean applyToDialects = wrapper.applyToDialects();
            result = applyToDialects && !dialects.isEmpty() ? new THashSet(1 + dialects.size()) : new SmartHashSet();
            result.add(langId);
            if (applyToDialects) {
                for (Language dialect : dialects) {
                    result.add(dialect.getID());
                }
            }
        } else {
            result = Collections.singleton(langId);
        }
        return result;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<PsiElement> inside, @NotNull List<PsiElement> outside) {
        if (inside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inside", "com/intellij/codeInspection/InspectionEngine", "calcElementDialectIds"));
        }
        if (outside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outside", "com/intellij/codeInspection/InspectionEngine", "calcElementDialectIds"));
        }
        SmartHashSet dialectIds = new SmartHashSet();
        SmartHashSet processedLanguages = new SmartHashSet();
        InspectionEngine.addDialects(inside, processedLanguages, dialectIds);
        InspectionEngine.addDialects(outside, processedLanguages, dialectIds);
        SmartHashSet smartHashSet = dialectIds;
        if (smartHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "calcElementDialectIds"));
        }
        return smartHashSet;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInspection/InspectionEngine", "calcElementDialectIds"));
        }
        SmartHashSet dialectIds = new SmartHashSet();
        SmartHashSet processedLanguages = new SmartHashSet();
        InspectionEngine.addDialects(elements, processedLanguages, dialectIds);
        SmartHashSet smartHashSet = dialectIds;
        if (smartHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "calcElementDialectIds"));
        }
        return smartHashSet;
    }

    private static void addDialects(@NotNull List<PsiElement> elements, @NotNull Set<Language> processedLanguages, @NotNull Set<String> dialectIds) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInspection/InspectionEngine", "addDialects"));
        }
        if (processedLanguages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedLanguages", "com/intellij/codeInspection/InspectionEngine", "addDialects"));
        }
        if (dialectIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectIds", "com/intellij/codeInspection/InspectionEngine", "addDialects"));
        }
        for (PsiElement element : elements) {
            Language language = element.getLanguage();
            dialectIds.add(language.getID());
            if (!processedLanguages.add(language)) continue;
            for (Language dialect : language.getDialects()) {
                dialectIds.add(dialect.getID());
            }
        }
    }
}

