/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.NestedSynchronizedStatementInspection;
import org.jetbrains.annotations.NotNull;

public class NestedSwitchStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.switch.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NestedSwitchStatementInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.switch.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NestedSwitchStatementInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedSwitchStatementVisitor();
    }

    private static class NestedSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private NestedSwitchStatementVisitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/NestedSwitchStatementInspection$NestedSwitchStatementVisitor", "visitSwitchStatement"));
            }
            super.visitSwitchStatement(statement);
            if (NestedSynchronizedStatementInspection.isNestedStatement(statement, PsiSwitchStatement.class)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }
    }
}

