/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.SmartList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformDocumentationUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.documentation.PlatformDocumentationUtil");
    @NonNls
    private static final Pattern ourLtFixupPattern = Pattern.compile("<([^/^\\w^!])");
    @NonNls
    private static final Pattern ourToQuote = Pattern.compile("[\\\\\\.\\^\\$\\?\\*\\+\\|\\)\\}\\]\\{\\(\\[]");
    @NonNls
    private static final String LT_ENTITY = "&lt;";

    @Nullable
    public static List<String> getHttpRoots(@NotNull String[] roots, String relPath) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/codeInsight/documentation/PlatformDocumentationUtil", "getHttpRoots"));
        }
        SmartList<String> result = new SmartList<String>();
        for (String root : roots) {
            String url;
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(root);
            if (virtualFile == null || (url = PlatformDocumentationUtil.getDocUrl(virtualFile, relPath)) == null) continue;
            result.add(url);
        }
        return result.isEmpty() ? null : result;
    }

    @Nullable
    public static String getDocUrl(@NotNull VirtualFile root, String relPath) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/documentation/PlatformDocumentationUtil", "getDocUrl"));
        }
        if (root.getFileSystem() instanceof HttpFileSystem) {
            String url = StringUtil.trimEnd(root.getUrl(), "/index.html", true);
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            return url + relPath;
        }
        VirtualFile file = root.findFileByRelativePath(relPath);
        return file == null ? null : file.getUrl();
    }

    private static String quote(String x) {
        if (ourToQuote.matcher(x).find()) {
            return "\\" + x;
        }
        return x;
    }

    public static String fixupText(@NotNull CharSequence docText) {
        if (docText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docText", "com/intellij/codeInsight/documentation/PlatformDocumentationUtil", "fixupText"));
        }
        Matcher fixupMatcher = ourLtFixupPattern.matcher(docText);
        LinkedList<String> secondSymbols = new LinkedList<String>();
        while (fixupMatcher.find()) {
            String s = fixupMatcher.group(1);
            if (s.equals("\\") || secondSymbols.contains(s)) continue;
            secondSymbols.addFirst(s);
        }
        for (String s : secondSymbols) {
            String pattern = "<" + PlatformDocumentationUtil.quote(s);
            try {
                docText = Pattern.compile(pattern).matcher(docText).replaceAll(LT_ENTITY + pattern);
            }
            catch (PatternSyntaxException e) {
                LOG.error("Pattern syntax exception on " + pattern);
            }
        }
        return docText.toString();
    }
}

