/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.EPAvailabilityListenerExtension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class ExtensionsAreaImpl
implements ExtensionsArea {
    private final LogProvider myLogger;
    public static final String ATTRIBUTE_AREA = "area";
    private static final Map<String, String> ourDefaultEPs = new THashMap();
    private static final boolean DEBUG_REGISTRATION = false;
    private final AreaPicoContainer myPicoContainer;
    private final Throwable myCreationTrace;
    private final Map<String, ExtensionPointImpl> myExtensionPoints;
    private final Map<String, Throwable> myEPTraces;
    private final MultiMap<String, ExtensionPointAvailabilityListener> myAvailabilityListeners;
    private final List<Runnable> mySuspendedListenerActions;
    private boolean myAvailabilityNotificationsActive;
    private final AreaInstance myAreaInstance;
    private final String myAreaClass;

    public ExtensionsAreaImpl(String areaClass, AreaInstance areaInstance, PicoContainer parentPicoContainer, @NotNull LogProvider logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "<init>"));
        }
        this.myExtensionPoints = ContainerUtil.newConcurrentMap();
        this.myEPTraces = null;
        this.myAvailabilityListeners = MultiMap.createSmart();
        this.mySuspendedListenerActions = new ArrayList<Runnable>();
        this.myAvailabilityNotificationsActive = true;
        this.myCreationTrace = null;
        this.myAreaClass = areaClass;
        this.myAreaInstance = areaInstance;
        this.myPicoContainer = new DefaultPicoContainer(parentPicoContainer);
        this.myLogger = logger;
        this.initialize();
    }

    ExtensionsAreaImpl(MutablePicoContainer parentPicoContainer, @NotNull LogProvider logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "<init>"));
        }
        this(null, null, (PicoContainer)parentPicoContainer, logger);
    }

    public final void notifyAreaReplaced() {
        for (ExtensionPointImpl point : this.myExtensionPoints.values()) {
            point.notifyAreaReplaced(this);
        }
    }

    @Override
    @NotNull
    public AreaPicoContainer getPicoContainer() {
        AreaPicoContainer areaPicoContainer = this.myPicoContainer;
        if (areaPicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getPicoContainer"));
        }
        return areaPicoContainer;
    }

    @Override
    public String getAreaClass() {
        return this.myAreaClass;
    }

    @Override
    public void registerExtensionPoint(@NotNull String pluginName, @NotNull Element extensionPointElement) {
        if (pluginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (extensionPointElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointElement", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        this.registerExtensionPoint(new DefaultPluginDescriptor(PluginId.getId(pluginName)), extensionPointElement);
    }

    @Override
    public void registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionPointElement) {
        ExtensionPoint.Kind kind;
        String className;
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (extensionPointElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointElement", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        assert (pluginDescriptor.getPluginId() != null);
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        String epName = extensionPointElement.getAttributeValue("qualifiedName");
        if (epName == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw new RuntimeException("'name' attribute not specified for extension point in '" + pluginId + "' plugin");
            }
            epName = pluginId + '.' + name;
        }
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + epName + "' in '" + pluginId + "' plugin");
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + epName + "' in '" + pluginId + "' plugin");
        }
        if (interfaceClassName != null) {
            className = interfaceClassName;
            kind = ExtensionPoint.Kind.INTERFACE;
        } else {
            className = beanClassName;
            kind = ExtensionPoint.Kind.BEAN_CLASS;
        }
        this.registerExtensionPoint(epName, className, pluginDescriptor, kind);
    }

    @Override
    public void registerExtension(@NotNull String pluginName, @NotNull Element extensionElement) {
        if (pluginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtension"));
        }
        if (extensionElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionElement", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtension"));
        }
        this.registerExtension(new DefaultPluginDescriptor(PluginId.getId(pluginName)), extensionElement);
    }

    @Override
    public void registerExtension(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement) {
        ExtensionComponentAdapter adapter;
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtension"));
        }
        if (extensionElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionElement", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtension"));
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        String epName = ExtensionsAreaImpl.extractEPName(extensionElement);
        ExtensionPoint extensionPoint = this.getExtensionPoint(epName);
        if (((ExtensionPointImpl)extensionPoint).getKind() == ExtensionPoint.Kind.INTERFACE) {
            String implClass = extensionElement.getAttributeValue("implementation");
            if (implClass == null) {
                throw new RuntimeException("'implementation' attribute not specified for '" + epName + "' extension in '" + pluginId.getIdString() + "' plugin");
            }
            adapter = new ExtensionComponentAdapter(implClass, extensionElement, (PicoContainer)this.myPicoContainer, pluginDescriptor, ExtensionsAreaImpl.shouldDeserializeInstance(extensionElement));
        } else {
            adapter = new ExtensionComponentAdapter(((ExtensionPointImpl)extensionPoint).getClassName(), extensionElement, (PicoContainer)this.myPicoContainer, pluginDescriptor, true);
        }
        this.myPicoContainer.registerComponent(adapter);
        ((ExtensionPointImpl)extensionPoint).registerExtensionAdapter(adapter);
    }

    private static boolean shouldDeserializeInstance(Element extensionElement) {
        if (!extensionElement.getContent().isEmpty()) {
            return true;
        }
        for (Attribute attribute : extensionElement.getAttributes()) {
            String name = attribute.getName();
            if ("implementation".equals(name) || "id".equals(name) || "order".equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String extractEPName(Element extensionElement) {
        String epName = extensionElement.getAttributeValue("point");
        if (epName == null) {
            String ns;
            Element parentElement = extensionElement.getParentElement();
            String string = ns = parentElement != null ? parentElement.getAttributeValue("defaultExtensionNs") : null;
            if (ns != null) {
                epName = ns + '.' + extensionElement.getName();
            } else {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            }
        }
        return epName;
    }

    @Override
    @NotNull
    public PicoContainer getPluginContainer(@NotNull String pluginName) {
        if (pluginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getPluginContainer"));
        }
        MutablePicoContainer mutablePicoContainer = this.internalGetPluginContainer();
        if (mutablePicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getPluginContainer"));
        }
        return mutablePicoContainer;
    }

    private MutablePicoContainer internalGetPluginContainer() {
        return this.myPicoContainer;
    }

    private void initialize() {
        for (Map.Entry<String, String> entry : ourDefaultEPs.entrySet()) {
            String epName = entry.getKey();
            this.registerExtensionPoint(epName, entry.getValue());
        }
        ((ExtensionPointImpl)this.getExtensionPoint("com.intellij.openapi.extensions.epAvailabilityListener")).addExtensionPointListener(new ExtensionPointListener(){

            public void extensionRemoved(@NotNull Object extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1", "extensionRemoved"));
                }
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                Collection listeners = ExtensionsAreaImpl.this.myAvailabilityListeners.get(epListenerExtension.getExtensionPointName());
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)iterator.next();
                    if (!listener.getClass().getName().equals(epListenerExtension.getListenerClass())) continue;
                    iterator.remove();
                    return;
                }
                ExtensionsAreaImpl.this.myLogger.warn("Failed to find EP availability listener: " + epListenerExtension.getListenerClass());
            }

            public void extensionAdded(@NotNull Object extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1", "extensionAdded"));
                }
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                try {
                    String epName = epListenerExtension.getExtensionPointName();
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)ExtensionsAreaImpl.this.instantiate(epListenerExtension.loadListenerClass());
                    ExtensionsAreaImpl.this.addAvailabilityListener(epName, listener);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Object instantiate(Class clazz) {
        CachingConstructorInjectionComponentAdapter adapter = new CachingConstructorInjectionComponentAdapter(Integer.toString(System.identityHashCode(new Object())), clazz);
        return adapter.getComponentInstance((PicoContainer)this.getPicoContainer());
    }

    public Throwable getCreationTrace() {
        return this.myCreationTrace;
    }

    @Override
    public void addAvailabilityListener(@NotNull String extensionPointName, @NotNull ExtensionPointAvailabilityListener listener) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "addAvailabilityListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "addAvailabilityListener"));
        }
        this.myAvailabilityListeners.putValue(extensionPointName, listener);
        if (this.hasExtensionPoint(extensionPointName)) {
            this.notifyAvailableListener(listener, this.myExtensionPoints.get(extensionPointName));
        }
    }

    @Override
    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (extensionPointBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointBeanClass", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, ExtensionPoint.Kind.INTERFACE);
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (extensionPointBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointBeanClass", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, new UndefinedPluginDescriptor(), kind);
    }

    @Override
    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull PluginDescriptor descriptor) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (extensionPointBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointBeanClass", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, descriptor, ExtensionPoint.Kind.INTERFACE);
    }

    private void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull PluginDescriptor descriptor, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (extensionPointBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointBeanClass", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (this.hasExtensionPoint(extensionPointName)) {
            throw new RuntimeException("Duplicate registration for EP: " + extensionPointName);
        }
        this.registerExtensionPoint(new ExtensionPointImpl(extensionPointName, extensionPointBeanClass, kind, this, this.myAreaInstance, this.myLogger, descriptor));
    }

    public void registerExtensionPoint(@NotNull ExtensionPointImpl extensionPoint) {
        if (extensionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPoint", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        String name = extensionPoint.getName();
        this.myExtensionPoints.put(name, extensionPoint);
        this.notifyEPRegistered(extensionPoint);
    }

    private void notifyEPRegistered(ExtensionPoint extensionPoint) {
        Collection<ExtensionPointAvailabilityListener> listeners = this.myAvailabilityListeners.get(extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyAvailableListener(listener, extensionPoint);
        }
    }

    private void notifyAvailableListener(final ExtensionPointAvailabilityListener listener, final ExtensionPoint extensionPoint) {
        this.queueNotificationAction(new Runnable(){

            @Override
            public void run() {
                listener.extensionPointRegistered(extensionPoint);
            }
        });
    }

    private void queueNotificationAction(Runnable action) {
        if (this.myAvailabilityNotificationsActive) {
            action.run();
        } else {
            this.mySuspendedListenerActions.add(action);
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getExtensionPoint"));
        }
        ExtensionPointImpl extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in area " + this.myAreaInstance);
        }
        ExtensionPointImpl extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getExtensionPoint"));
        }
        return extensionPointImpl;
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getExtensionPoint"));
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getExtensionPoint"));
        }
        return extensionPoint;
    }

    @Override
    @NotNull
    public ExtensionPoint[] getExtensionPoints() {
        ExtensionPoint[] extensionPointArray = this.myExtensionPoints.values().toArray(new ExtensionPoint[this.myExtensionPoints.size()]);
        if (extensionPointArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getExtensionPoints"));
        }
        return extensionPointArray;
    }

    @Override
    public void unregisterExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "unregisterExtensionPoint"));
        }
        ExtensionPoint extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint != null) {
            extensionPoint.reset();
            this.myExtensionPoints.remove(extensionPointName);
            this.notifyEPRemoved(extensionPoint);
        }
    }

    private void notifyEPRemoved(@NotNull ExtensionPoint extensionPoint) {
        if (extensionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPoint", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "notifyEPRemoved"));
        }
        Collection<ExtensionPointAvailabilityListener> listeners = this.myAvailabilityListeners.get(extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyUnavailableListener(extensionPoint, listener);
        }
    }

    private void notifyUnavailableListener(final ExtensionPoint extensionPoint, final ExtensionPointAvailabilityListener listener) {
        this.queueNotificationAction(new Runnable(){

            @Override
            public void run() {
                listener.extensionPointRemoved(extensionPoint);
            }
        });
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "hasExtensionPoint"));
        }
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @Override
    public void suspendInteractions() {
        this.myAvailabilityNotificationsActive = false;
    }

    @Override
    public void resumeInteractions() {
        this.myAvailabilityNotificationsActive = true;
        ExtensionPoint[] extensionPoints = this.getExtensionPoints();
        for (ExtensionPoint extensionPoint : extensionPoints) {
            extensionPoint.getExtensions();
        }
        for (Runnable action : this.mySuspendedListenerActions) {
            try {
                action.run();
            }
            catch (Exception e) {
                this.myLogger.error(e);
            }
        }
        this.mySuspendedListenerActions.clear();
    }

    @Override
    public void killPendingInteractions() {
        this.mySuspendedListenerActions.clear();
    }

    public void removeAllComponents(Set<ExtensionComponentAdapter> extensionAdapters) {
        Iterator<ExtensionComponentAdapter> iterator = extensionAdapters.iterator();
        while (iterator.hasNext()) {
            ExtensionComponentAdapter extensionAdapter;
            ExtensionComponentAdapter componentAdapter = extensionAdapter = iterator.next();
            this.internalGetPluginContainer().unregisterComponent(componentAdapter.getComponentKey());
        }
    }

    public String toString() {
        return (this.myAreaClass == null ? "Root" : this.myAreaClass) + " Area";
    }

    static {
        ourDefaultEPs.put("com.intellij.openapi.extensions.epAvailabilityListener", EPAvailabilityListenerExtension.class.getName());
    }
}

