/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class QuickFixWrapper
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance("com.intellij.codeInspection.ex.QuickFixWrapper");
    private final ProblemDescriptor myDescriptor;
    private final int myFixNumber;

    @NotNull
    public static IntentionAction wrap(@NotNull ProblemDescriptor descriptor, int fixNumber) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ex/QuickFixWrapper", "wrap"));
        }
        LOG.assertTrue(fixNumber >= 0, fixNumber);
        QuickFix[] fixes = descriptor.getFixes();
        LOG.assertTrue(fixes != null && fixes.length > fixNumber);
        QuickFix fix = fixes[fixNumber];
        IntentionAction intentionAction = fix instanceof IntentionAction ? (IntentionAction)((Object)fix) : new QuickFixWrapper(descriptor, fixNumber);
        if (intentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/QuickFixWrapper", "wrap"));
        }
        return intentionAction;
    }

    private QuickFixWrapper(@NotNull ProblemDescriptor descriptor, int fixNumber) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ex/QuickFixWrapper", "<init>"));
        }
        this.myDescriptor = descriptor;
        this.myFixNumber = fixNumber;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/QuickFixWrapper", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.myDescriptor.getFixes()[this.myFixNumber].getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/QuickFixWrapper", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixWrapper", "isAvailable"));
        }
        PsiElement psiElement = this.myDescriptor.getPsiElement();
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        LocalQuickFix fix = this.getFix();
        return !(fix instanceof IntentionAction) || ((IntentionAction)((Object)fix)).isAvailable(project, editor, file);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixWrapper", "invoke"));
        }
        PsiElement element = this.myDescriptor.getPsiElement();
        PsiFile fileForUndo = element == null ? null : element.getContainingFile();
        LocalQuickFix fix = this.getFix();
        fix.applyFix(project, this.myDescriptor);
        DaemonCodeAnalyzer.getInstance(project).restart();
        if (fileForUndo != null && !fileForUndo.equals(file)) {
            UndoUtil.markPsiFileForUndo(fileForUndo);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return this.getFix().startInWriteAction();
    }

    public LocalQuickFix getFix() {
        return (LocalQuickFix)this.myDescriptor.getFixes()[this.myFixNumber];
    }

    public String toString() {
        return this.getText();
    }
}

