/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.reference.SoftReference;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import com.intellij.xml.util.XmlResourceResolver;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXParseException;

public class ExternalDocumentValidator {
    private static final Logger LOG = Logger.getInstance("#com.intellij.xml.impl.ExternalDocumentValidator");
    private static final Key<SoftReference<ExternalDocumentValidator>> validatorInstanceKey = Key.create("validatorInstance");
    @NonNls
    public static final String INSPECTION_SHORT_NAME = "CheckXmlFileWithXercesValidator";
    private ValidateXmlActionHandler myHandler;
    private Validator.ValidationHost myHost;
    private long myModificationStamp;
    private PsiFile myFile;
    @NonNls
    private static final String CANNOT_FIND_DECLARATION_ERROR_PREFIX = "Cannot find the declaration of element";
    @NonNls
    private static final String ELEMENT_ERROR_PREFIX = "Element";
    @NonNls
    private static final String ROOT_ELEMENT_ERROR_PREFIX = "Document root element";
    @NonNls
    private static final String CONTENT_OF_ELEMENT_TYPE_ERROR_PREFIX = "The content of element type";
    @NonNls
    private static final String VALUE_ERROR_PREFIX = "Value ";
    @NonNls
    private static final String ATTRIBUTE_ERROR_PREFIX = "Attribute ";
    @NonNls
    private static final String STRING_ERROR_PREFIX = "The string";
    @NonNls
    private static final String ATTRIBUTE_MESSAGE_PREFIX = "cvc-attribute.";
    private WeakReference<List<ValidationInfo>> myInfos;

    private void runJaxpValidation(XmlElement element, Validator.ValidationHost host) {
        Project project;
        Document document;
        final PsiFile file = element.getContainingFile();
        if (this.myFile == file && file != null && this.myModificationStamp == file.getModificationStamp() && !ValidateXmlActionHandler.isValidationDependentFilesOutOfDate((XmlFile)file) && SoftReference.dereference(this.myInfos) != null) {
            ExternalDocumentValidator.addAllInfos(host, (List)this.myInfos.get());
            return;
        }
        if (this.myHandler == null) {
            this.myHandler = new ValidateXmlActionHandler(false);
        }
        if ((document = PsiDocumentManager.getInstance(project = element.getProject()).getDocument(file)) == null) {
            return;
        }
        final LinkedList<ValidationInfo> results = new LinkedList<ValidationInfo>();
        this.myHost = new Validator.ValidationHost(){

            @Override
            public void addMessage(PsiElement context, String message, int type) {
                this.addMessage(context, message, type == 1 ? Validator.ValidationHost.ErrorType.ERROR : (type == 0 ? Validator.ValidationHost.ErrorType.WARNING : Validator.ValidationHost.ErrorType.INFO));
            }

            @Override
            public void addMessage(PsiElement context, String message, @NotNull Validator.ValidationHost.ErrorType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xml/impl/ExternalDocumentValidator$1", "addMessage"));
                }
                ValidationInfo o = new ValidationInfo(context, message, type);
                results.add(o);
            }
        };
        this.myHandler.setErrorReporter(new ErrorReporter(this.myHandler){

            @Override
            public boolean isStopOnUndeclaredResource() {
                return true;
            }

            @Override
            public void processError(SAXParseException e, ValidateXmlActionHandler.ProblemType warning) {
                try {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement currentElement;
                        if (e.getPublicId() != null) {
                            return;
                        }
                        VirtualFile errorFile = this.myHandler.getProblemFile(e);
                        if (!Comparing.equal(errorFile, file.getVirtualFile()) && errorFile != null) {
                            return;
                        }
                        if (document.getLineCount() < e.getLineNumber() || e.getLineNumber() <= 0) {
                            return;
                        }
                        Validator.ValidationHost.ErrorType problemType = ExternalDocumentValidator.getProblemType(warning);
                        int offset = Math.max(0, document.getLineStartOffset(e.getLineNumber() - 1) + e.getColumnNumber() - 2);
                        if (offset >= document.getTextLength()) {
                            return;
                        }
                        PsiElement originalElement = currentElement = PsiDocumentManager.getInstance(project).getPsiFile(document).findElementAt(offset);
                        String elementText = currentElement.getText();
                        if (elementText.equals("</")) {
                            currentElement = currentElement.getNextSibling();
                        } else if (elementText.equals(">") || elementText.equals("=")) {
                            currentElement = currentElement.getPrevSibling();
                        }
                        String localizedMessage = e.getLocalizedMessage();
                        int endIndex = localizedMessage.indexOf(58);
                        if (endIndex < localizedMessage.length() - 1 && localizedMessage.charAt(endIndex + 1) == '/') {
                            endIndex = -1;
                        }
                        String messageId = endIndex != -1 ? localizedMessage.substring(0, endIndex) : "";
                        if ((localizedMessage = localizedMessage.substring(endIndex + 1).trim()).startsWith(ExternalDocumentValidator.CANNOT_FIND_DECLARATION_ERROR_PREFIX) || localizedMessage.startsWith(ExternalDocumentValidator.ELEMENT_ERROR_PREFIX) || localizedMessage.startsWith(ExternalDocumentValidator.ROOT_ELEMENT_ERROR_PREFIX) || localizedMessage.startsWith(ExternalDocumentValidator.CONTENT_OF_ELEMENT_TYPE_ERROR_PREFIX)) {
                            ExternalDocumentValidator.this.addProblemToTagName(currentElement, originalElement, localizedMessage, warning);
                        } else if (localizedMessage.startsWith(ExternalDocumentValidator.VALUE_ERROR_PREFIX)) {
                            ExternalDocumentValidator.this.addProblemToTagName(currentElement, originalElement, localizedMessage, warning);
                        } else if (messageId.startsWith(ExternalDocumentValidator.ATTRIBUTE_MESSAGE_PREFIX)) {
                            String prefix = "of attribute ";
                            int i = localizedMessage.indexOf(prefix);
                            if (i != -1) {
                                int messagePrefixLength = prefix.length() + i;
                                int nextQuoteIndex = localizedMessage.indexOf(localizedMessage.charAt(messagePrefixLength), messagePrefixLength + 1);
                                String attrName = nextQuoteIndex == -1 ? null : localizedMessage.substring(messagePrefixLength + 1, nextQuoteIndex);
                                XmlTag parent = PsiTreeUtil.getParentOfType(originalElement, XmlTag.class);
                                currentElement = parent.getAttribute(attrName, null);
                                if (currentElement != null) {
                                    currentElement = ((XmlAttribute)currentElement).getValueElement();
                                }
                            }
                            if (currentElement != null) {
                                ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
                                ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, problemType);
                            } else {
                                ExternalDocumentValidator.this.addProblemToTagName(originalElement, originalElement, localizedMessage, warning);
                            }
                        } else if (localizedMessage.startsWith(ExternalDocumentValidator.ATTRIBUTE_ERROR_PREFIX)) {
                            int messagePrefixLength = ExternalDocumentValidator.ATTRIBUTE_ERROR_PREFIX.length();
                            if (localizedMessage.charAt(messagePrefixLength) == '\"' || localizedMessage.charAt(messagePrefixLength) == '\'') {
                                int nextQuoteIndex = localizedMessage.indexOf(localizedMessage.charAt(messagePrefixLength), messagePrefixLength + 1);
                                String attrName = nextQuoteIndex == -1 ? null : localizedMessage.substring(messagePrefixLength + 1, nextQuoteIndex);
                                XmlTag parent = PsiTreeUtil.getParentOfType(originalElement, XmlTag.class);
                                currentElement = parent.getAttribute(attrName, null);
                                if (currentElement != null) {
                                    currentElement = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(SourceTreeToPsiMap.psiElementToTree(currentElement)));
                                }
                            } else {
                                currentElement = PsiTreeUtil.getParentOfType(currentElement, XmlTag.class, false);
                            }
                            if (currentElement != null) {
                                ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
                                ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, problemType);
                            } else {
                                ExternalDocumentValidator.this.addProblemToTagName(originalElement, originalElement, localizedMessage, warning);
                            }
                        } else if (localizedMessage.startsWith(ExternalDocumentValidator.STRING_ERROR_PREFIX)) {
                            if (currentElement != null) {
                                ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, Validator.ValidationHost.ErrorType.WARNING);
                            }
                        } else {
                            currentElement = ExternalDocumentValidator.getNodeForMessage(currentElement != null ? currentElement : originalElement);
                            ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
                            if (currentElement != null) {
                                ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, problemType);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    if (ex instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)ex;
                    }
                    if (ex instanceof XmlResourceResolver.IgnoredResourceException) {
                        throw (XmlResourceResolver.IgnoredResourceException)ex;
                    }
                    LOG.error(ex);
                }
            }
        });
        this.myHandler.doValidate((XmlFile)element.getContainingFile());
        this.myFile = file;
        this.myModificationStamp = this.myFile.getModificationStamp();
        this.myInfos = new WeakReference(results);
        ExternalDocumentValidator.addAllInfos(host, results);
    }

    private static Validator.ValidationHost.ErrorType getProblemType(ValidateXmlActionHandler.ProblemType warning) {
        return warning == ValidateXmlActionHandler.ProblemType.WARNING ? Validator.ValidationHost.ErrorType.WARNING : Validator.ValidationHost.ErrorType.ERROR;
    }

    private static PsiElement getNodeForMessage(PsiElement currentElement) {
        Object parentOfType = PsiTreeUtil.getNonStrictParentOfType(currentElement, XmlTag.class, XmlProcessingInstruction.class, XmlElementDecl.class, XmlMarkupDecl.class, XmlEntityRef.class, XmlDoctype.class);
        if (parentOfType == null) {
            parentOfType = currentElement instanceof XmlToken ? currentElement.getParent() : currentElement;
        }
        return parentOfType;
    }

    private static void addAllInfos(Validator.ValidationHost host, List<ValidationInfo> highlightInfos) {
        for (ValidationInfo info : highlightInfos) {
            host.addMessage(info.element, info.message, info.type);
        }
    }

    private PsiElement addProblemToTagName(PsiElement currentElement, PsiElement originalElement, String localizedMessage, ValidateXmlActionHandler.ProblemType problemType) {
        if ((currentElement = PsiTreeUtil.getParentOfType(currentElement, XmlTag.class, false)) == null) {
            currentElement = PsiTreeUtil.getParentOfType(originalElement, XmlElementDecl.class, false);
        }
        if (currentElement == null) {
            currentElement = originalElement;
        }
        ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
        if (currentElement != null) {
            this.myHost.addMessage(currentElement, localizedMessage, ExternalDocumentValidator.getProblemType(problemType));
        }
        return currentElement;
    }

    private static void assertValidElement(PsiElement currentElement, PsiElement originalElement, String message) {
        if (currentElement == null) {
            XmlTag tag = PsiTreeUtil.getParentOfType(originalElement, XmlTag.class);
            LOG.error("The validator message:" + message + " is bound to null node,\n" + "initial element:" + originalElement.getText() + ",\n" + "parent:" + originalElement.getParent() + ",\n" + "tag:" + (tag != null ? tag.getText() : "null") + ",\n" + "offset in tag: " + (originalElement.getTextOffset() - (tag == null ? 0 : tag.getTextOffset())));
        }
    }

    public static synchronized void doValidation(XmlDocument document, Validator.ValidationHost host) {
        PsiFile containingFile = document.getContainingFile();
        if (containingFile == null) {
            return;
        }
        if (containingFile.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            return;
        }
        FileType fileType = containingFile.getViewProvider().getFileType();
        if (fileType != XmlFileType.INSTANCE && fileType != XHtmlFileType.INSTANCE) {
            return;
        }
        for (Language lang : containingFile.getViewProvider().getLanguages()) {
            if (!"ANT".equals(lang.getID())) continue;
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return;
        }
        String namespace = rootTag.getNamespace();
        if ("http://ant.apache.org/schema.xsd".equals(namespace)) {
            return;
        }
        Project project = document.getProject();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        InspectionToolWrapper toolWrapper = profile.getInspectionTool(INSPECTION_SHORT_NAME, containingFile);
        if (toolWrapper == null) {
            return;
        }
        if (!profile.isToolEnabled(HighlightDisplayKey.find(INSPECTION_SHORT_NAME), containingFile)) {
            return;
        }
        SoftReference<ExternalDocumentValidator> validatorReference = project.getUserData(validatorInstanceKey);
        ExternalDocumentValidator validator = SoftReference.dereference(validatorReference);
        if (validator == null) {
            validator = new ExternalDocumentValidator();
            project.putUserData(validatorInstanceKey, new SoftReference<ExternalDocumentValidator>(validator));
        }
        validator.runJaxpValidation(document, host);
    }

    private static class ValidationInfo {
        final PsiElement element;
        final String message;
        final Validator.ValidationHost.ErrorType type;

        private ValidationInfo(PsiElement element, String message, Validator.ValidationHost.ErrorType type) {
            this.element = element;
            this.message = message;
            this.type = type;
        }
    }
}

