/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.imageio;

import java.awt.image.RenderedImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import org.apache.batik.ext.awt.image.codec.imageio.ImageIOImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterParams;

public class ImageIOJPEGImageWriter
extends ImageIOImageWriter {
    private static final String JPEG_NATIVE_FORMAT = "javax_imageio_jpeg_image_1.0";

    public ImageIOJPEGImageWriter() {
        super("image/jpeg");
    }

    @Override
    protected IIOMetadata updateMetadata(IIOMetadata iIOMetadata, ImageWriterParams imageWriterParams) {
        if (JPEG_NATIVE_FORMAT.equals(iIOMetadata.getNativeMetadataFormatName())) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)(iIOMetadata = ImageIOJPEGImageWriter.addAdobeTransform(iIOMetadata)).getAsTree(JPEG_NATIVE_FORMAT);
            IIOMetadataNode iIOMetadataNode2 = ImageIOJPEGImageWriter.getChildNode(iIOMetadataNode, "JPEGvariety");
            if (iIOMetadataNode2 == null) {
                iIOMetadataNode2 = new IIOMetadataNode("JPEGvariety");
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            if (imageWriterParams.getResolution() != null) {
                IIOMetadataNode iIOMetadataNode3 = ImageIOJPEGImageWriter.getChildNode(iIOMetadataNode2, "app0JFIF");
                if (iIOMetadataNode3 == null) {
                    iIOMetadataNode3 = new IIOMetadataNode("app0JFIF");
                    iIOMetadataNode2.appendChild(iIOMetadataNode3);
                }
                iIOMetadataNode3.setAttribute("majorVersion", null);
                iIOMetadataNode3.setAttribute("minorVersion", null);
                iIOMetadataNode3.setAttribute("resUnits", "1");
                iIOMetadataNode3.setAttribute("Xdensity", imageWriterParams.getResolution().toString());
                iIOMetadataNode3.setAttribute("Ydensity", imageWriterParams.getResolution().toString());
                iIOMetadataNode3.setAttribute("thumbWidth", null);
                iIOMetadataNode3.setAttribute("thumbHeight", null);
            }
            try {
                iIOMetadata.setFromTree(JPEG_NATIVE_FORMAT, iIOMetadataNode);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                throw new RuntimeException("Cannot update image metadata: " + iIOInvalidTreeException.getMessage(), iIOInvalidTreeException);
            }
        }
        return iIOMetadata;
    }

    private static IIOMetadata addAdobeTransform(IIOMetadata iIOMetadata) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(JPEG_NATIVE_FORMAT);
        IIOMetadataNode iIOMetadataNode2 = ImageIOJPEGImageWriter.getChildNode(iIOMetadataNode, "markerSequence");
        if (iIOMetadataNode2 == null) {
            throw new RuntimeException("Invalid metadata!");
        }
        IIOMetadataNode iIOMetadataNode3 = ImageIOJPEGImageWriter.getChildNode(iIOMetadataNode2, "app14Adobe");
        if (iIOMetadataNode3 == null) {
            iIOMetadataNode3 = new IIOMetadataNode("app14Adobe");
            iIOMetadataNode3.setAttribute("transform", "1");
            iIOMetadataNode3.setAttribute("version", "101");
            iIOMetadataNode3.setAttribute("flags0", "0");
            iIOMetadataNode3.setAttribute("flags1", "0");
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        } else {
            iIOMetadataNode3.setAttribute("transform", "1");
        }
        try {
            iIOMetadata.setFromTree(JPEG_NATIVE_FORMAT, iIOMetadataNode);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            throw new RuntimeException("Cannot update image metadata: " + iIOInvalidTreeException.getMessage(), iIOInvalidTreeException);
        }
        return iIOMetadata;
    }

    @Override
    protected ImageWriteParam getDefaultWriteParam(ImageWriter imageWriter, RenderedImage renderedImage, ImageWriterParams imageWriterParams) {
        JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(imageWriter.getLocale());
        return jPEGImageWriteParam;
    }
}

